/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.block;

import com.jamieswhiteshirt.clotheslinefabric.api.NetworkManager;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkManagerProvider;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkNode;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import com.jamieswhiteshirt.clotheslinefabric.common.item.ClotheslineItems;
import com.jamieswhiteshirt.clotheslinefabric.common.sound.ClotheslineSoundEvents;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3954;
import net.minecraft.class_3965;

public class ClotheslineAnchorBlock
extends class_2341
implements class_3954,
class_3737 {
    private static final class_265 DOWN = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    private static final class_265 UP = class_2248.method_9541((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 NORTH = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)16.0);
    private static final class_265 SOUTH = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)12.0, (double)10.0);
    private static final class_265 WEST = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    private static final class_265 EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2769<Boolean> CRANK = class_2746.method_11825((String)"crank");

    public ClotheslineAnchorBlock(class_2248.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(CRANK, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11007, field_11177, WATERLOGGED, CRANK});
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 verticalEntityPosition) {
        switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            case field_12475: {
                return DOWN;
            }
            case field_12471: {
                switch ((class_2350)state.method_11654((class_2769)field_11177)) {
                    case field_11043: {
                        return NORTH;
                    }
                    case field_11035: {
                        return SOUTH;
                    }
                    case field_11039: {
                        return WEST;
                    }
                }
                return EAST;
            }
        }
        return UP;
    }

    public class_1921 method_9551() {
        return class_1921.field_9174;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState) {
        if (oldState.method_11614() != this) {
            NetworkManager manager = ((NetworkManagerProvider)world).getNetworkManager();
            manager.createNode(pos);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean var5) {
        if (newState.method_11614() != this) {
            NetworkManager manager = ((NetworkManagerProvider)world).getNetworkManager();
            manager.breakNode(null, pos);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = super.method_9605(ctx);
        if (state != null) {
            class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
            return (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (((Boolean)state.method_11654(CRANK)).booleanValue()) {
            world.method_8501(pos, (class_2680)state.method_11657(CRANK, (Comparable)Boolean.valueOf(false)));
            if (!world.field_9236 && !player.method_7337()) {
                ClotheslineAnchorBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)ClotheslineItems.CRANK));
            }
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        NetworkManager manager = ((NetworkManagerProvider)world).getNetworkManager();
        manager.breakNode((class_1309)player, pos);
        super.method_9576(world, pos, state, player);
    }

    public boolean method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (player.method_5998(hand).method_7909() == ClotheslineItems.CLOTHESLINE) {
            return false;
        }
        if (((Boolean)state.method_11654(CRANK)).booleanValue()) {
            NetworkNode node = ClotheslineAnchorBlock.getNode(world, pos);
            if (node != null) {
                int momentumDelta = ClotheslineAnchorBlock.getCrankMultiplier(pos, hitResult.method_17784().field_1352, hitResult.method_17784().field_1350, player) * 5;
                NetworkState networkState = node.getNetwork().getState();
                networkState.setMomentum(networkState.getMomentum() + momentumDelta);
            }
            return true;
        }
        return super.method_9534(state, world, pos, player, hand, hitResult);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, Random random) {
        NetworkNode node = ClotheslineAnchorBlock.getNode(world, pos);
        if (node != null) {
            int momentum = Math.abs(node.getNetwork().getState().getMomentum());
            float pitch = 0.2f + 0.6f * ((float)momentum / 30.0f) + random.nextFloat() * 0.1f;
            if (random.nextInt(360) < momentum) {
                world.method_8396((class_1657)class_310.method_1551().field_1724, pos, ClotheslineSoundEvents.BLOCK_CLOTHESLINE_ANCHOR_SQUEAK, class_3419.field_15245, 0.1f, pitch);
            }
        }
    }

    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        return new ClotheslineAnchorInventory(((NetworkManagerProvider)world).getNetworkManager(), pos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_8676(pos, (Object)class_3612.field_15910, class_3612.field_15910.method_15789((class_1941)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    private static NetworkNode getNode(class_1937 world, class_2338 pos) {
        return ((NetworkManagerProvider)world).getNetworkManager().getNetworks().getNodes().get(pos);
    }

    public static int getCrankMultiplier(class_2338 pos, double hitX, double hitZ, class_1657 player) {
        double dxCenter = 0.5 + (double)pos.method_10263() - player.field_5987;
        double dzCenter = 0.5 + (double)pos.method_10260() - player.field_6035;
        double dxHit = hitX - player.field_5987;
        double dzHit = hitZ - player.field_6035;
        double y = dzCenter * dxHit - dxCenter * dzHit;
        return (int)Math.signum(y);
    }

    private class ClotheslineAnchorInventory
    implements class_1278 {
        private final NetworkManager manager;
        private final class_2338 pos;

        private ClotheslineAnchorInventory(NetworkManager manager, class_2338 pos) {
            this.manager = manager;
            this.pos = pos;
        }

        @Nullable
        public NetworkNode getNetworkNode() {
            return this.manager.getNetworks().getNodes().get(this.pos);
        }

        public int[] method_5494(class_2350 direction) {
            NetworkNode node = this.getNetworkNode();
            if (node != null && !node.getNetwork().getState().getPath().isEmpty()) {
                int attachmentKey = node.getNetwork().getState().offsetToAttachmentKey(node.getPathNode().getOffsetForDelta(direction.method_10163()));
                List<MutableSortedIntMap.Entry<class_1799>> entries = node.getNetwork().getState().getAttachmentsInRange(attachmentKey - 80, attachmentKey + 80);
                if (entries.isEmpty()) {
                    return new int[]{attachmentKey};
                }
                return new int[]{entries.get(entries.size() / 2).getKey()};
            }
            return new int[0];
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 direction) {
            NetworkNode node = this.getNetworkNode();
            if (node != null) {
                return node.getNetwork().insertItem(slot, stack, true).method_7960();
            }
            return false;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
            return this.getNetworkNode() != null;
        }

        public int method_5439() {
            NetworkNode node = this.getNetworkNode();
            if (node != null) {
                return node.getNetwork().getState().getPathLength();
            }
            return 0;
        }

        public boolean method_5442() {
            NetworkNode node = this.getNetworkNode();
            if (node != null) {
                return node.getNetwork().getState().getAttachments().size() > 0;
            }
            return false;
        }

        public class_1799 method_5438(int slot) {
            NetworkNode node = this.getNetworkNode();
            if (node != null) {
                return node.getNetwork().getAttachment(slot);
            }
            return class_1799.field_8037;
        }

        public class_1799 method_5434(int slot, int amount) {
            return this.method_5441(slot);
        }

        public class_1799 method_5441(int slot) {
            NetworkNode node = this.getNetworkNode();
            if (node != null) {
                return node.getNetwork().extractItem(slot, false);
            }
            return class_1799.field_8037;
        }

        public void method_5447(int slot, class_1799 stack) {
            NetworkNode node = this.getNetworkNode();
            if (node != null) {
                node.getNetwork().insertItem(slot, stack, false);
            }
        }

        public void method_5431() {
        }

        public boolean method_5443(class_1657 var1) {
            return false;
        }

        public void method_5448() {
            this.manager.removeNode(this.pos);
        }

        public int method_5444() {
            return 1;
        }
    }
}

