/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollection;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkManager;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkNode;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.common.Util;
import com.jamieswhiteshirt.clotheslinefabric.common.util.NetworkStateBuilder;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public abstract class CommonNetworkManager
implements NetworkManager {
    private final class_1937 world;
    private final NetworkCollection networks;

    protected CommonNetworkManager(class_1937 world, NetworkCollection networks) {
        this.world = world;
        this.networks = networks;
    }

    protected abstract void createNetwork(NetworkState var1);

    protected abstract void deleteNetwork(Network var1);

    protected abstract void dropItems(NetworkState var1, boolean var2);

    @Override
    public NetworkCollection getNetworks() {
        return this.networks;
    }

    @Override
    public final void update() {
        this.world.method_16107().method_15396("tickClotheslines");
        this.networks.getValues().forEach(Network::update);
        this.world.method_16107().method_15407();
    }

    private void extend(Network network, class_2338 fromPos, class_2338 toPos) {
        NetworkStateBuilder stateBuilder = NetworkStateBuilder.fromAbsolute(network.getState());
        stateBuilder.addEdge(fromPos, toPos);
        this.deleteNetwork(network);
        this.createNetwork(stateBuilder.build());
    }

    @Override
    public final boolean connect(class_2338 fromPos, class_2338 toPos) {
        if (fromPos.equals((Object)toPos)) {
            NetworkNode node = this.networks.getNodes().get(fromPos);
            if (node != null) {
                Network network = node.getNetwork();
                NetworkStateBuilder stateBuilder = NetworkStateBuilder.fromAbsolute(network.getState());
                stateBuilder.reroot(toPos);
                this.deleteNetwork(network);
                this.createNetwork(stateBuilder.build());
            }
            return false;
        }
        NetworkNode fromNode = this.networks.getNodes().get(fromPos);
        NetworkNode toNode = this.networks.getNodes().get(toPos);
        if (fromNode != null) {
            Network fromNetwork = fromNode.getNetwork();
            if (toNode != null) {
                Network toNetwork = toNode.getNetwork();
                if (fromNetwork == toNetwork) {
                    return false;
                }
                this.deleteNetwork(fromNetwork);
                this.deleteNetwork(toNetwork);
                NetworkStateBuilder fromState = NetworkStateBuilder.fromAbsolute(fromNetwork.getState());
                NetworkStateBuilder toState = NetworkStateBuilder.fromAbsolute(toNetwork.getState());
                toState.reroot(toPos);
                fromState.addSubState(fromPos, toState);
                this.createNetwork(fromState.build());
            } else {
                this.extend(fromNetwork, fromPos, toPos);
            }
        } else if (toNode != null) {
            Network toNetwork = toNode.getNetwork();
            this.extend(toNetwork, toPos, fromPos);
        } else {
            NetworkStateBuilder stateBuilder = NetworkStateBuilder.emptyRoot(0, fromPos);
            stateBuilder.addEdge(fromPos, toPos);
            this.createNetwork(stateBuilder.build());
        }
        return true;
    }

    private void applySplitResult(NetworkStateBuilder.SplitResult splitResult, boolean dropClotheslines) {
        for (NetworkStateBuilder subState : splitResult.getSubStates()) {
            this.createNetwork(subState.build());
        }
        this.dropItems(splitResult.getState().build(), dropClotheslines);
    }

    private boolean removeConnection(class_2338 posA, class_2338 posB, boolean dropItems) {
        Network network;
        if (posA.equals((Object)posB)) {
            return false;
        }
        NetworkNode nodeA = this.networks.getNodes().get(posA);
        NetworkNode nodeB = this.networks.getNodes().get(posB);
        if (nodeA != null && nodeB != null && (network = nodeA.getNetwork()) == nodeB.getNetwork()) {
            NetworkStateBuilder state = NetworkStateBuilder.fromAbsolute(network.getState());
            state.reroot(posA);
            this.deleteNetwork(network);
            this.applySplitResult(state.splitEdge(posB), dropItems);
            return true;
        }
        return false;
    }

    @Override
    public boolean breakConnection(@Nullable class_1309 entity, class_2338 posA, class_2338 posB) {
        return this.removeConnection(posA, posB, !Util.isCreativePlayer((class_1297)entity));
    }

    @Override
    public boolean removeConnection(class_2338 posA, class_2338 posB) {
        return this.removeConnection(posA, posB, false);
    }

    @Override
    public void createNode(class_2338 pos) {
        NetworkStateBuilder stateBuilder = NetworkStateBuilder.emptyRoot(0, pos);
        this.createNetwork(stateBuilder.build());
    }

    private boolean removeNode(class_2338 pos, boolean dropItems) {
        NetworkNode node = this.networks.getNodes().get(pos);
        if (node != null) {
            Network network = node.getNetwork();
            NetworkStateBuilder state = NetworkStateBuilder.fromAbsolute(network.getState());
            state.reroot(pos);
            this.deleteNetwork(network);
            this.applySplitResult(state.splitRoot(), dropItems);
            return true;
        }
        return false;
    }

    @Override
    public final boolean breakNode(@Nullable class_1309 entity, class_2338 pos) {
        return this.removeNode(pos, !Util.isCreativePlayer((class_1297)entity));
    }

    @Override
    public boolean removeNode(class_2338 pos) {
        return this.removeNode(pos, false);
    }
}

