/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.jamieswhiteshirt.clotheslinefabric.api.Line;
import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollection;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollectionListener;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkEdge;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkNode;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkEdgeImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkNodeImpl;
import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Configuration;
import com.jamieswhiteshirt.rtree3i.ConfigurationBuilder;
import com.jamieswhiteshirt.rtree3i.RTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public final class NetworkCollectionImpl
implements NetworkCollection {
    private static final Configuration configuration = new ConfigurationBuilder().star().build();
    private final List<Network> values = new ArrayList<Network>();
    private final Int2ObjectMap<Network> byId = new Int2ObjectOpenHashMap();
    private final Map<UUID, Network> byUuid = new HashMap<UUID, Network>();
    private RTreeMap<Line, NetworkEdge> edges = NetworkCollectionImpl.createEdgesMap();
    private RTreeMap<class_2338, NetworkNode> nodes = NetworkCollectionImpl.createNodesMap();
    private final SetMultimap<Long, Network> chunkSpanMap = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final Map<class_2960, NetworkCollectionListener> eventListeners = new TreeMap<class_2960, NetworkCollectionListener>();

    private static <E> RTreeMap<Line, E> createEdgesMap() {
        return RTreeMap.create(configuration, Line::getBox);
    }

    private static <N> RTreeMap<class_2338, N> createNodesMap() {
        return RTreeMap.create(configuration, blockPos -> Box.create(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockPos.method_10263() + 1, blockPos.method_10264() + 1, blockPos.method_10260() + 1));
    }

    @Override
    public List<Network> getValues() {
        return this.values;
    }

    @Override
    @Nullable
    public Network getById(int id) {
        return (Network)this.byId.get(id);
    }

    @Override
    @Nullable
    public Network getByUuid(UUID uuid) {
        return this.byUuid.get(uuid);
    }

    @Override
    public void add(Network network) {
        this.values.add(network);
        this.byId.put(network.getId(), (Object)network);
        this.byUuid.put(network.getUuid(), network);
        for (Path.Node pathNode : network.getState().getPath().getNodes().values()) {
            this.nodes = this.nodes.put(pathNode.getPos(), new NetworkNodeImpl(network, pathNode));
        }
        int i = 0;
        for (Path.Edge pathEdge : network.getState().getPath().getEdges()) {
            this.edges = this.edges.put(pathEdge.getLine(), new NetworkEdgeImpl(network, pathEdge, i++));
        }
        LongIterator longIterator = network.getState().getChunkSpan().iterator();
        while (longIterator.hasNext()) {
            long position = (Long)longIterator.next();
            this.chunkSpanMap.put((Object)position, (Object)network);
        }
        for (NetworkCollectionListener eventListener : this.eventListeners.values()) {
            eventListener.onNetworkAdded(this, network);
        }
    }

    @Override
    public void remove(Network network) {
        this.values.remove(network);
        this.byId.remove(network.getId());
        this.byUuid.remove(network.getUuid());
        for (class_2338 pos : network.getState().getPath().getNodes().keySet()) {
            this.nodes = this.nodes.remove(pos);
        }
        for (Path.Edge pathEdge : network.getState().getPath().getEdges()) {
            this.edges = this.edges.remove(pathEdge.getLine());
        }
        Iterator<Object> iterator = network.getState().getChunkSpan().iterator();
        while (iterator.hasNext()) {
            long position = (Long)iterator.next();
            this.chunkSpanMap.remove((Object)position, (Object)network);
        }
        for (NetworkCollectionListener eventListener : this.eventListeners.values()) {
            eventListener.onNetworkRemoved(this, network);
        }
    }

    @Override
    public void removeById(int id) {
        Network network = this.getById(id);
        if (network != null) {
            this.remove(network);
        }
    }

    @Override
    public void removeByUuid(UUID uuid) {
        Network network = this.getByUuid(uuid);
        if (network != null) {
            this.remove(network);
        }
    }

    @Override
    public RTreeMap<class_2338, NetworkNode> getNodes() {
        return this.nodes;
    }

    @Override
    public RTreeMap<Line, NetworkEdge> getEdges() {
        return this.edges;
    }

    @Override
    public Set<Network> getNetworksSpanningChunk(long pos) {
        return this.chunkSpanMap.get((Object)pos);
    }

    @Override
    public void addEventListener(class_2960 key, NetworkCollectionListener eventListener) {
        this.eventListeners.put(key, eventListener);
    }

    @Override
    public void removeEventListener(class_2960 key) {
        this.eventListeners.remove(key);
    }
}

