/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollection;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollectionListener;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkTracker;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkCollectionTracker;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkMessenger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2960;

public final class NetworkCollectionTrackerImpl<T>
implements NetworkCollectionTracker<T> {
    private static final class_2960 LISTENER_KEY = new class_2960("clothesline", "watcher");
    private final NetworkCollection networks;
    private final Function<class_1923, Collection<T>> getChunkWatchers;
    private final NetworkMessenger<T> messenger;
    private final Int2ObjectMap<NetworkTracker<T>> networkTrackers = new Int2ObjectOpenHashMap();

    public NetworkCollectionTrackerImpl(NetworkCollection networks, Function<class_1923, Collection<T>> getChunkWatchers, NetworkMessenger<T> messenger) {
        this.networks = networks;
        this.getChunkWatchers = getChunkWatchers;
        this.messenger = messenger;
        networks.addEventListener(LISTENER_KEY, new NetworkCollectionListener(){

            @Override
            public void onNetworkAdded(NetworkCollection networks, Network network) {
                NetworkCollectionTrackerImpl.this.addNetworkWatcher(network);
            }

            @Override
            public void onNetworkRemoved(NetworkCollection networks, Network network) {
                NetworkCollectionTrackerImpl.this.removeNetworkWatcher(network);
            }
        });
    }

    @Override
    public void onWatchChunk(T watcher, class_1923 pos) {
        for (Network network : this.networks.getNetworksSpanningChunk(pos.method_8324())) {
            ((NetworkTracker)this.networkTrackers.get(network.getId())).addWatcher(watcher);
        }
    }

    @Override
    public void onUnWatchChunk(T watcher, class_1923 pos) {
        for (Network network : this.networks.getNetworksSpanningChunk(pos.method_8324())) {
            ((NetworkTracker)this.networkTrackers.get(network.getId())).removeWatcher(watcher);
        }
    }

    @Override
    public void update() {
        for (NetworkTracker tracker : this.networkTrackers.values()) {
            tracker.update();
        }
    }

    private void addNetworkWatcher(Network network) {
        NetworkTracker<T> networkTracker = new NetworkTracker<T>(network, this.messenger);
        network.addEventListener(LISTENER_KEY, networkTracker);
        this.networkTrackers.put(network.getId(), networkTracker);
        LongIterator longIterator = network.getState().getChunkSpan().iterator();
        while (longIterator.hasNext()) {
            long position = (Long)longIterator.next();
            for (T watcher : this.getChunkWatchers.apply(new class_1923(position))) {
                networkTracker.addWatcher(watcher);
            }
        }
    }

    private void removeNetworkWatcher(Network network) {
        network.removeEventListener(LISTENER_KEY);
        ((NetworkTracker)this.networkTrackers.remove(network.getId())).clear();
    }
}

