/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkListener;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.internal.PersistentNetwork;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public final class NetworkImpl
implements Network {
    private final int id;
    private final UUID uuid;
    private final NetworkState state;
    private final Map<class_2960, NetworkListener> eventListeners = new TreeMap<class_2960, NetworkListener>();

    public NetworkImpl(int id, PersistentNetwork persistentNetwork) {
        this.id = id;
        this.uuid = persistentNetwork.getUuid();
        this.state = persistentNetwork.getState();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public NetworkState getState() {
        return this.state;
    }

    @Override
    public void update() {
        this.state.update();
    }

    @Override
    public boolean useItem(class_1657 player, class_1268 hand, int attachmentKey) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && this.state.getAttachment(attachmentKey).method_7960()) {
            player.method_6122(hand, this.insertItem(attachmentKey, stack, false));
            return true;
        }
        return false;
    }

    @Override
    public void hitAttachment(class_1657 player, int attachmentKey) {
        class_1799 stack = this.state.getAttachment(attachmentKey);
        if (!stack.method_7960()) {
            this.setAttachment(attachmentKey, class_1799.field_8037);
            class_1937 world = player.field_6002;
            if (!world.field_9236 && world.method_8450().method_8355("doTileDrops")) {
                class_243 pos = this.state.getPath().getPositionForOffset(this.state.attachmentKeyToOffset(attachmentKey));
                class_1542 itemEntity = new class_1542(world, pos.field_1352, pos.field_1351 - 0.5, pos.field_1350, stack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
    }

    @Override
    public class_1799 insertItem(int attachmentKey, class_1799 stack, boolean simulate) {
        if (!stack.method_7960() && this.state.getAttachment(attachmentKey).method_7960()) {
            if (!simulate) {
                class_1799 insertedItem = stack.method_7972();
                insertedItem.method_7939(1);
                this.setAttachment(attachmentKey, insertedItem);
            }
            class_1799 returnedStack = stack.method_7972();
            returnedStack.method_7934(1);
            return returnedStack;
        }
        return stack;
    }

    @Override
    public class_1799 extractItem(int attachmentKey, boolean simulate) {
        class_1799 result = this.state.getAttachment(attachmentKey);
        if (!result.method_7960() && !simulate) {
            this.setAttachment(attachmentKey, class_1799.field_8037);
        }
        return result;
    }

    @Override
    public class_1799 getAttachment(int attachmentKey) {
        return this.state.getAttachment(attachmentKey);
    }

    @Override
    public void setAttachment(int attachmentKey, class_1799 stack) {
        class_1799 previousStack = this.state.getAttachment(attachmentKey);
        this.state.setAttachment(attachmentKey, stack);
        for (NetworkListener eventListener : this.eventListeners.values()) {
            eventListener.onAttachmentChanged(this, attachmentKey, previousStack, stack);
        }
    }

    @Override
    public void addEventListener(class_2960 key, NetworkListener eventListener) {
        this.eventListeners.put(key, eventListener);
    }

    @Override
    public void removeEventListener(class_2960 key) {
        this.eventListeners.remove(key);
    }
}

