/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollection;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkProviderEntry;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkProvider;
import com.jamieswhiteshirt.clotheslinefabric.internal.PersistentNetwork;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_1923;

public final class NetworkProviderImpl
implements NetworkProvider {
    private final NetworkCollection networks;
    private final LongPredicate isChunkLoaded;
    private Map<UUID, NetworkProviderEntry> entryMap = new HashMap<UUID, NetworkProviderEntry>();
    private SetMultimap<Long, UUID> chunkMap = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private int nextNetworkId = 0;

    public NetworkProviderImpl(NetworkCollection networks, LongPredicate isChunkLoaded) {
        this.networks = networks;
        this.isChunkLoaded = isChunkLoaded;
    }

    private void chunkLoaded(NetworkProviderEntry entry) {
        if (entry.incrementLoadCount()) {
            NetworkImpl network = new NetworkImpl(this.nextNetworkId++, entry.getPersistentNetwork());
            this.networks.add(network);
        }
    }

    @Override
    public void reset(Collection<PersistentNetwork> persistentNetworks) {
        for (UUID uuid : this.entryMap.keySet()) {
            Network network = this.networks.getByUuid(uuid);
            if (network == null) continue;
            this.networks.remove(network);
        }
        this.nextNetworkId = 0;
        this.entryMap = new HashMap<UUID, NetworkProviderEntry>();
        this.chunkMap = MultimapBuilder.hashKeys().linkedHashSetValues().build();
        for (PersistentNetwork persistentNetwork : persistentNetworks) {
            this.addNetwork(persistentNetwork);
        }
    }

    @Override
    public Collection<PersistentNetwork> getNetworks() {
        return this.entryMap.values().stream().map(NetworkProviderEntry::getPersistentNetwork).collect(Collectors.toList());
    }

    @Override
    public void addNetwork(PersistentNetwork persistentNetwork) {
        NetworkProviderEntry entry = new NetworkProviderEntry(persistentNetwork);
        this.entryMap.put(persistentNetwork.getUuid(), entry);
        LongIterator longIterator = entry.getPersistentNetwork().getState().getChunkSpan().iterator();
        while (longIterator.hasNext()) {
            long position = (Long)longIterator.next();
            this.chunkMap.put((Object)position, (Object)persistentNetwork.getUuid());
            if (!this.isChunkLoaded.test(position)) continue;
            this.chunkLoaded(entry);
        }
    }

    @Override
    public void removeNetwork(UUID uuid) {
        NetworkProviderEntry entry = this.entryMap.remove(uuid);
        LongIterator longIterator = entry.getPersistentNetwork().getState().getChunkSpan().iterator();
        while (longIterator.hasNext()) {
            long position = (Long)longIterator.next();
            this.chunkMap.remove((Object)position, (Object)uuid);
        }
        this.networks.removeByUuid(uuid);
    }

    @Override
    public void onChunkLoaded(class_1923 pos) {
        for (UUID uuid : this.chunkMap.get((Object)pos.method_8324())) {
            NetworkProviderEntry entry = this.entryMap.get(uuid);
            this.chunkLoaded(entry);
        }
    }

    @Override
    public void onChunkUnloaded(class_1923 pos) {
        for (UUID uuid : this.chunkMap.get((Object)pos.method_8324())) {
            NetworkProviderEntry entry = this.entryMap.get(uuid);
            if (!entry.decrementLoadCount()) continue;
            this.networks.removeByUuid(uuid);
        }
    }
}

