/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MathUtil;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.minecraft.class_1799;

public final class NetworkStateImpl
implements NetworkState {
    private int previousShift;
    private int shift;
    private int previousMomentum;
    private int momentum;
    private final Tree tree;
    private final Path path;
    private final LongSet chunkSpan;
    private final MutableSortedIntMap<class_1799> attachments;

    public NetworkStateImpl(int previousShift, int shift, int previousMomentum, int momentum, Tree tree, Path path, LongSet chunkSpan, MutableSortedIntMap<class_1799> attachments) {
        this.tree = tree;
        this.path = path;
        this.chunkSpan = chunkSpan;
        this.attachments = attachments;
        this.previousShift = previousShift;
        this.previousMomentum = previousMomentum;
        this.shift = shift;
        this.momentum = momentum;
    }

    private int lengthMod(int i) {
        return Math.floorMod(i, this.getPathLength());
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public LongSet getChunkSpan() {
        return this.chunkSpan;
    }

    @Override
    public MutableSortedIntMap<class_1799> getAttachments() {
        return this.attachments;
    }

    @Override
    public List<MutableSortedIntMap.Entry<class_1799>> getAttachmentsInRange(int minAttachmentKey, int maxAttachmentKey) {
        return this.attachments.getInRange(this.lengthMod(minAttachmentKey), this.lengthMod(maxAttachmentKey));
    }

    @Override
    public class_1799 getAttachment(int attachmentKey) {
        class_1799 result = this.attachments.get(this.lengthMod(attachmentKey));
        if (result != null) {
            return result;
        }
        return class_1799.field_8037;
    }

    @Override
    public void setAttachment(int attachmentKey, class_1799 stack) {
        if (stack.method_7960()) {
            this.attachments.remove(this.lengthMod(attachmentKey));
        } else {
            this.attachments.put(this.lengthMod(attachmentKey), stack);
        }
    }

    @Override
    public void update() {
        this.previousMomentum = this.momentum;
        this.previousShift = this.shift;
        if (this.momentum > 0) {
            --this.momentum;
        } else if (this.momentum < 0) {
            ++this.momentum;
        }
        this.shift += this.momentum;
    }

    @Override
    public int getShift() {
        return this.shift;
    }

    @Override
    public void setShift(int shift) {
        this.shift = shift;
    }

    @Override
    public int getPreviousShift() {
        return this.previousShift;
    }

    @Override
    public double getShift(float delta) {
        return (float)this.previousShift + (float)(this.shift - this.previousShift) * delta;
    }

    @Override
    public int getMomentum() {
        return this.momentum;
    }

    @Override
    public void setMomentum(int momentum) {
        this.momentum = Math.min(Math.max(momentum, -30), 30);
    }

    @Override
    public int getPreviousMomentum() {
        return this.previousMomentum;
    }

    @Override
    public double getMomentum(float delta) {
        return (float)this.previousMomentum + (float)(this.momentum - this.previousMomentum) * delta;
    }

    @Override
    public int getPathLength() {
        return this.path.getLength();
    }

    @Override
    public int offsetToAttachmentKey(int offset) {
        return Math.floorMod(offset - this.shift, this.getPathLength());
    }

    @Override
    public double offsetToAttachmentKey(double offset, float delta) {
        return MathUtil.floorMod(offset - this.getShift(delta), (double)this.getPathLength());
    }

    @Override
    public int attachmentKeyToOffset(int attachmentKey) {
        return Math.floorMod(attachmentKey + this.shift, this.getPathLength());
    }

    @Override
    public double attachmentKeyToOffset(double attachmentKey, float delta) {
        return MathUtil.floorMod(attachmentKey + this.getShift(delta), (double)this.getPathLength());
    }
}

