/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkListener;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkMessenger;
import net.minecraft.class_1799;

public final class NetworkTracker<T>
implements NetworkListener {
    private final Network network;
    private final NetworkMessenger<T> messenger;
    private final Multiset<T> watchers = LinkedHashMultiset.create();
    private int lastShift;
    private int lastMomentum;

    public NetworkTracker(Network network, NetworkMessenger<T> messenger) {
        this.network = network;
        this.messenger = messenger;
        this.lastShift = network.getState().getShift();
        this.lastMomentum = network.getState().getMomentum();
    }

    @Override
    public void onAttachmentChanged(Network network, int attachmentKey, class_1799 previousStack, class_1799 newStack) {
        if (!class_1799.method_7973((class_1799)previousStack, (class_1799)newStack)) {
            for (Object watcher : this.watchers.elementSet()) {
                this.messenger.setAttachment(watcher, network, attachmentKey, newStack);
            }
        }
    }

    public void addWatcher(T watcher) {
        if (this.watchers.add(watcher, 1) == 0) {
            this.messenger.addNetwork(watcher, this.network);
        }
    }

    public void removeWatcher(T watcher) {
        if (this.watchers.remove(watcher, 1) == 1) {
            this.messenger.removeNetwork(watcher, this.network);
        }
    }

    public void clear() {
        for (Object watcher : this.watchers.elementSet()) {
            this.messenger.removeNetwork(watcher, this.network);
        }
        this.watchers.clear();
    }

    public void update() {
        int shift = this.network.getState().getShift();
        int momentum = this.network.getState().getMomentum();
        if (shift != this.lastShift || momentum != this.lastMomentum) {
            for (Object watcher : this.watchers.elementSet()) {
                this.messenger.setShiftAndMomentum(watcher, this.network, shift, momentum);
            }
            this.lastShift = shift;
            this.lastMomentum = momentum;
        }
    }
}

