/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.impl;

import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollection;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.CommonNetworkManager;
import com.jamieswhiteshirt.clotheslinefabric.common.item.ClotheslineItems;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkProvider;
import com.jamieswhiteshirt.clotheslinefabric.internal.PersistentNetwork;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public final class ServerNetworkManager
extends CommonNetworkManager {
    private final class_3218 world;
    private final NetworkProvider provider;

    public ServerNetworkManager(class_3218 world, NetworkCollection networks, NetworkProvider provider) {
        super((class_1937)world, networks);
        this.world = world;
        this.provider = provider;
    }

    private void dropAttachment(NetworkState state, class_1799 stack, int attachmentKey) {
        if (!stack.method_7960()) {
            class_243 pos = state.getPath().getPositionForOffset(state.attachmentKeyToOffset(attachmentKey));
            class_1542 itemEntity = new class_1542((class_1937)this.world, pos.field_1352, pos.field_1351 - 0.5, pos.field_1350, stack);
            itemEntity.method_6988();
            this.world.method_8649((class_1297)itemEntity);
        }
    }

    private void dropTreeItems(Tree tree) {
        class_2338 from = tree.getPos();
        for (Tree.Edge edge : tree.getEdges()) {
            class_2338 to = edge.getTree().getPos();
            class_1542 itemEntity = new class_1542((class_1937)this.world, (double)(1 + from.method_10263() + to.method_10263()) / 2.0, (double)(1 + from.method_10264() + to.method_10264()) / 2.0, (double)(1 + from.method_10260() + to.method_10260()) / 2.0, new class_1799((class_1935)ClotheslineItems.CLOTHESLINE));
            itemEntity.method_6988();
            this.world.method_8649((class_1297)itemEntity);
            this.dropTreeItems(edge.getTree());
        }
    }

    @Override
    protected void dropItems(NetworkState state, boolean dropClotheslines) {
        if (this.world.method_8450().method_8355("doTileDrops")) {
            for (MutableSortedIntMap.Entry<class_1799> entry : state.getAttachments().entries()) {
                this.dropAttachment(state, entry.getValue(), entry.getKey());
            }
            if (dropClotheslines) {
                this.dropTreeItems(state.getTree());
            }
        }
    }

    @Override
    protected void createNetwork(NetworkState state) {
        this.provider.addNetwork(new PersistentNetwork(UUID.randomUUID(), state));
    }

    @Override
    protected void deleteNetwork(Network network) {
        this.provider.removeNetwork(network.getUuid());
    }
}

