/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.api.Network;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicPersistentNetwork;
import com.jamieswhiteshirt.clotheslinefabric.internal.PersistentNetwork;
import java.util.Objects;

public final class BasicNetwork {
    private final int id;
    private final BasicPersistentNetwork persistentNetwork;

    public static BasicNetwork fromAbsolute(Network network) {
        return new BasicNetwork(network.getId(), BasicPersistentNetwork.fromAbsolute(new PersistentNetwork(network.getUuid(), network.getState())));
    }

    public BasicNetwork(int id, BasicPersistentNetwork persistentNetwork) {
        this.id = id;
        this.persistentNetwork = persistentNetwork;
    }

    public int getId() {
        return this.id;
    }

    public BasicPersistentNetwork getPersistentNetwork() {
        return this.persistentNetwork;
    }

    public NetworkImpl toAbsolute() {
        return new NetworkImpl(this.id, this.persistentNetwork.toAbsolute());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNetwork that = (BasicNetwork)o;
        return this.id == that.id && Objects.equals(this.persistentNetwork, that.persistentNetwork);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.persistentNetwork);
    }

    public String toString() {
        return "BasicNetwork{id=" + this.id + ", persistentNetwork=" + this.persistentNetwork + '}';
    }
}

