/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkStateImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicAttachment;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicTree;
import com.jamieswhiteshirt.clotheslinefabric.common.util.ChunkSpan;
import com.jamieswhiteshirt.clotheslinefabric.common.util.PathBuilder;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1799;

public final class BasicNetworkState {
    private final int shift;
    private final int momentum;
    private final BasicTree tree;
    private final List<BasicAttachment> attachments;

    public static BasicNetworkState fromAbsolute(NetworkState state) {
        return new BasicNetworkState(state.getShift(), state.getMomentum(), BasicTree.fromAbsolute(state.getTree()), state.getAttachments().entries().stream().map(entry -> new BasicAttachment(entry.getKey(), ((class_1799)entry.getValue()).method_7972())).collect(Collectors.toList()));
    }

    public BasicNetworkState(int shift, int momentum, BasicTree tree, List<BasicAttachment> attachments) {
        this.shift = shift;
        this.momentum = momentum;
        this.tree = tree;
        this.attachments = attachments;
    }

    public int getShift() {
        return this.shift;
    }

    public int getMomentum() {
        return this.momentum;
    }

    public BasicTree getTree() {
        return this.tree;
    }

    public List<BasicAttachment> getAttachments() {
        return this.attachments;
    }

    public NetworkState toAbsolute() {
        Tree tree = this.tree.toAbsolute();
        Path path = PathBuilder.buildPath(tree);
        LongSet chunkSpan = ChunkSpan.ofPath(path);
        MutableSortedIntMap<class_1799> attachments = new MutableSortedIntMap<class_1799>(new ArrayList(this.attachments.stream().map(attachment -> new MutableSortedIntMap.Entry<class_1799>(attachment.getKey(), attachment.getStack())).collect(Collectors.toList())), path.getLength());
        return new NetworkStateImpl(this.shift, this.shift, this.momentum, this.momentum, tree, path, chunkSpan, attachments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNetworkState that = (BasicNetworkState)o;
        return this.shift == that.shift && this.momentum == that.momentum && Objects.equals(this.tree, that.tree) && Objects.equals(this.attachments, that.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.shift, this.momentum, this.tree, this.attachments);
    }

    public String toString() {
        return "BasicNetworkState{shift=" + this.shift + ", momentum=" + this.momentum + ", tree=" + this.tree + ", attachments=" + this.attachments + '}';
    }
}

