/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicNetworkState;
import com.jamieswhiteshirt.clotheslinefabric.internal.PersistentNetwork;
import java.util.Objects;
import java.util.UUID;

public final class BasicPersistentNetwork {
    private final UUID uuid;
    private final BasicNetworkState state;

    public static BasicPersistentNetwork fromAbsolute(PersistentNetwork network) {
        return new BasicPersistentNetwork(network.getUuid(), BasicNetworkState.fromAbsolute(network.getState()));
    }

    public BasicPersistentNetwork(UUID uuid, BasicNetworkState state) {
        this.uuid = uuid;
        this.state = state;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public BasicNetworkState getState() {
        return this.state;
    }

    public PersistentNetwork toAbsolute() {
        return new PersistentNetwork(this.uuid, this.state.toAbsolute());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPersistentNetwork that = (BasicPersistentNetwork)o;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.state);
    }

    public String toString() {
        return "BasicPersistentNetwork{uuid=" + this.uuid + ", state=" + this.state + '}';
    }
}

