/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public final class BasicTree {
    private final class_2338 pos;
    private final List<Edge> edges;
    private final int baseRotation;

    public static BasicTree fromAbsolute(Tree tree) {
        return new BasicTree(tree.getPos(), tree.getEdges().stream().map(Edge::fromAbsolute).collect(Collectors.toList()), tree.getBaseRotation());
    }

    public BasicTree(class_2338 pos, List<Edge> edges, int baseRotation) {
        this.pos = pos;
        this.edges = edges;
        this.baseRotation = baseRotation;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public int getBaseRotation() {
        return this.baseRotation;
    }

    private Tree toAbsolute(int fromOffset) {
        int toOffset = fromOffset;
        ArrayList<Tree.Edge> edgesOut = new ArrayList<Tree.Edge>(this.edges.size());
        for (Edge edge : this.edges) {
            Tree treeOut = edge.tree.toAbsolute(toOffset + edge.length);
            Tree.Edge edgeOut = new Tree.Edge(((Edge)edge).tree.pos.method_10059((class_2382)this.pos), edge.length, toOffset, treeOut);
            edgesOut.add(edgeOut);
            toOffset = edgeOut.getPostMaxOffset();
        }
        return new Tree(this.pos, edgesOut, fromOffset, toOffset, this.baseRotation);
    }

    public Tree toAbsolute() {
        return this.toAbsolute(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicTree basicTree = (BasicTree)o;
        return this.baseRotation == basicTree.baseRotation && Objects.equals(this.pos, basicTree.pos) && Objects.equals(this.edges, basicTree.edges);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.edges);
    }

    public String toString() {
        return "BasicTree{pos=" + this.pos + ", edges=" + this.edges + ", baseRotation" + this.baseRotation + '}';
    }

    public static final class Edge {
        private final int length;
        private final BasicTree tree;

        public Edge(int length, BasicTree tree) {
            this.length = length;
            this.tree = tree;
        }

        public int getLength() {
            return this.length;
        }

        public BasicTree getTree() {
            return this.tree;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.length == edge.length && Objects.equals(this.tree, edge.tree);
        }

        public int hashCode() {
            return Objects.hash(this.length, this.tree);
        }

        public String toString() {
            return "Edge{length=" + this.length + ", tree=" + this.tree + '}';
        }

        public static Edge fromAbsolute(Tree.Edge edge) {
            return new Edge(edge.getLength(), BasicTree.fromAbsolute(edge.getTree()));
        }
    }
}

