/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicAttachment;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicNetworkState;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicPersistentNetwork;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicTree;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class NBTSerialization {
    public static class_2499 writePersistentNetworks(List<BasicPersistentNetwork> networks) {
        class_2499 nbt = new class_2499();
        for (BasicPersistentNetwork network : networks) {
            nbt.add((Object)NBTSerialization.writePersistentNetwork(network));
        }
        return nbt;
    }

    public static List<BasicPersistentNetwork> readPersistentNetworks(class_2499 nbt) {
        BasicPersistentNetwork[] networks = new BasicPersistentNetwork[nbt.size()];
        for (int i = 0; i < nbt.size(); ++i) {
            networks[i] = NBTSerialization.readPersistentNetwork(nbt.method_10602(i));
        }
        return Arrays.asList(networks);
    }

    public static class_2487 writePersistentNetwork(BasicPersistentNetwork network) {
        class_2487 nbt = new class_2487();
        nbt.method_10560("Uuid", network.getUuid());
        nbt.method_10566("State", (class_2520)NBTSerialization.writeNetworkState(network.getState()));
        return nbt;
    }

    public static BasicPersistentNetwork readPersistentNetwork(class_2487 compound) {
        return new BasicPersistentNetwork(compound.method_10584("Uuid"), NBTSerialization.readNetworkState(compound.method_10562("State")));
    }

    public static class_2487 writeNetworkState(BasicNetworkState state) {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Shift", state.getShift());
        nbt.method_10569("Momentum", state.getMomentum());
        nbt.method_10566("Tree", (class_2520)NBTSerialization.writeBasicTree(state.getTree()));
        nbt.method_10566("Attachments", (class_2520)NBTSerialization.writeAttachments(state.getAttachments()));
        return nbt;
    }

    public static BasicNetworkState readNetworkState(class_2487 nbt) {
        return new BasicNetworkState(nbt.method_10550("Shift"), nbt.method_10550("Momentum"), NBTSerialization.readBasicTree(nbt.method_10562("Tree")), NBTSerialization.readAttachments(nbt.method_10554("Attachments", 10)));
    }

    public static class_2487 writeBasicTree(BasicTree tree) {
        class_2487 nbt = new class_2487();
        nbt.method_10569("x", tree.getPos().method_10263());
        nbt.method_10569("y", tree.getPos().method_10264());
        nbt.method_10569("z", tree.getPos().method_10260());
        nbt.method_10566("Children", (class_2520)NBTSerialization.writeBasicTreeEdges(tree.getEdges()));
        nbt.method_10569("BaseRotation", tree.getBaseRotation());
        return nbt;
    }

    public static BasicTree readBasicTree(class_2487 nbt) {
        return new BasicTree(new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z")), NBTSerialization.readBasicTreeEdges(nbt.method_10554("Children", 10)), nbt.method_10550("BaseRotation"));
    }

    public static class_2499 writeBasicTreeEdges(List<BasicTree.Edge> edges) {
        class_2499 nbt = new class_2499();
        for (BasicTree.Edge edge : edges) {
            nbt.add((Object)NBTSerialization.writeBasicTreeEdge(edge));
        }
        return nbt;
    }

    public static List<BasicTree.Edge> readBasicTreeEdges(class_2499 nbt) {
        BasicTree.Edge[] edges = new BasicTree.Edge[nbt.size()];
        for (int i = 0; i < nbt.size(); ++i) {
            edges[i] = NBTSerialization.readBasicTreeEdge(nbt.method_10602(i));
        }
        return Arrays.asList(edges);
    }

    public static class_2487 writeBasicTreeEdge(BasicTree.Edge edge) {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Length", edge.getLength());
        nbt.method_10566("Tree", (class_2520)NBTSerialization.writeBasicTree(edge.getTree()));
        return nbt;
    }

    public static BasicTree.Edge readBasicTreeEdge(class_2487 nbt) {
        return new BasicTree.Edge(nbt.method_10550("Length"), NBTSerialization.readBasicTree(nbt.method_10562("Tree")));
    }

    public static class_2499 writeAttachments(List<BasicAttachment> attachments) {
        class_2499 nbt = new class_2499();
        for (BasicAttachment attachment : attachments) {
            nbt.add((Object)NBTSerialization.writeAttachment(attachment));
        }
        return nbt;
    }

    public static List<BasicAttachment> readAttachments(class_2499 nbt) {
        BasicAttachment[] attachments = new BasicAttachment[nbt.size()];
        for (int i = 0; i < nbt.size(); ++i) {
            attachments[i] = NBTSerialization.readAttachment(nbt.method_10602(i));
        }
        return Arrays.asList(attachments);
    }

    public static class_2487 writeAttachment(BasicAttachment attachment) {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Offset", attachment.getKey());
        attachment.getStack().method_7953(nbt);
        return nbt;
    }

    public static BasicAttachment readAttachment(class_2487 nbt) {
        return new BasicAttachment(nbt.method_10550("Offset"), class_1799.method_7915((class_2487)nbt));
    }
}

