/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.api.NetworkState;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkStateImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.util.ChunkSpan;
import com.jamieswhiteshirt.clotheslinefabric.common.util.PathBuilder;
import com.jamieswhiteshirt.clotheslinefabric.common.util.TreeBuilder;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

public final class NetworkStateBuilder {
    private int momentum;
    private TreeBuilder treeRoot;

    public static NetworkStateBuilder fromAbsolute(NetworkState state) {
        MutableSortedIntMap<Object> itemStacks;
        MutableSortedIntMap<class_1799> attachments = state.getAttachments();
        if (state.getPathLength() != 0) {
            int midAttachmentKey = state.offsetToAttachmentKey(0);
            itemStacks = MutableSortedIntMap.concatenate(Arrays.asList(attachments.shiftedSubMap(midAttachmentKey, attachments.getMaxKey()), attachments.shiftedSubMap(0, midAttachmentKey)));
        } else {
            itemStacks = state.getAttachments();
        }
        TreeBuilder tree = TreeBuilder.fromAbsolute(state.getTree(), itemStacks, state.getShift());
        return new NetworkStateBuilder(state.getMomentum(), tree);
    }

    public static NetworkStateBuilder emptyRoot(int momentum, class_2338 root) {
        return new NetworkStateBuilder(momentum, TreeBuilder.emptyRoot(root));
    }

    private NetworkStateBuilder(int momentum, TreeBuilder treeRoot) {
        this.momentum = momentum;
        this.treeRoot = treeRoot;
    }

    public void reroot(class_2338 pos) {
        this.treeRoot = this.treeRoot.reroot(pos);
    }

    public void addEdge(class_2338 fromPos, class_2338 toPos) {
        this.treeRoot.addChild(fromPos, TreeBuilder.emptyRoot(toPos));
        this.momentum /= 2;
    }

    public void addSubState(class_2338 fromPos, NetworkStateBuilder other) {
        this.treeRoot.addChild(fromPos, other.treeRoot);
        this.momentum = (this.momentum + other.momentum) / 2;
    }

    public SplitResult splitRoot() {
        TreeBuilder.SplitResult result = this.treeRoot.splitNode();
        return new SplitResult(new NetworkStateBuilder(this.momentum, result.getTree()), result.getSubTrees().stream().map(tree -> new NetworkStateBuilder(this.momentum, (TreeBuilder)tree)).collect(Collectors.toList()));
    }

    public SplitResult splitEdge(class_2338 pos) {
        TreeBuilder.SplitResult result = this.treeRoot.splitEdge(pos);
        return new SplitResult(new NetworkStateBuilder(this.momentum, result.getTree()), result.getSubTrees().stream().map(tree -> new NetworkStateBuilder(this.momentum, (TreeBuilder)tree)).collect(Collectors.toList()));
    }

    public NetworkState build() {
        LinkedList attachmentsList = new LinkedList();
        Tree tree = this.treeRoot.build(attachmentsList, 0);
        Path path = PathBuilder.buildPath(tree);
        LongSet chunkSpan = ChunkSpan.ofPath(path);
        return new NetworkStateImpl(0, 0, this.momentum, this.momentum, tree, path, chunkSpan, MutableSortedIntMap.concatenate(attachmentsList));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkStateBuilder that = (NetworkStateBuilder)o;
        return this.momentum == that.momentum && Objects.equals(this.treeRoot, that.treeRoot);
    }

    public int hashCode() {
        return Objects.hash(this.momentum, this.treeRoot);
    }

    public static final class SplitResult {
        private final NetworkStateBuilder state;
        private final List<NetworkStateBuilder> subStates;

        public SplitResult(NetworkStateBuilder state, List<NetworkStateBuilder> subStates) {
            this.state = state;
            this.subStates = subStates;
        }

        public NetworkStateBuilder getState() {
            return this.state;
        }

        public List<NetworkStateBuilder> getSubStates() {
            return this.subStates;
        }
    }
}

