/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicAttachment;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicNetwork;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicNetworkState;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicPersistentNetwork;
import com.jamieswhiteshirt.clotheslinefabric.common.util.BasicTree;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;

public class PacketByteBufSerialization {
    public static void writeNetwork(class_2540 buf, BasicNetwork network) {
        PacketByteBufSerialization.writeNetworkId(buf, network.getId());
        PacketByteBufSerialization.writePersistentNetwork(buf, network.getPersistentNetwork());
    }

    public static BasicNetwork readNetwork(class_2540 buf) {
        return new BasicNetwork(PacketByteBufSerialization.readNetworkId(buf), PacketByteBufSerialization.readPersistentNetwork(buf));
    }

    public static void writePersistentNetwork(class_2540 buf, BasicPersistentNetwork network) {
        PacketByteBufSerialization.writeNetworkUuid(buf, network.getUuid());
        PacketByteBufSerialization.writeNetworkState(buf, network.getState());
    }

    public static BasicPersistentNetwork readPersistentNetwork(class_2540 buf) {
        return new BasicPersistentNetwork(PacketByteBufSerialization.readNetworkUuid(buf), PacketByteBufSerialization.readNetworkState(buf));
    }

    public static void writeNetworkUuid(class_2540 buf, UUID networkUuid) {
        buf.writeLong(networkUuid.getMostSignificantBits());
        buf.writeLong(networkUuid.getLeastSignificantBits());
    }

    public static UUID readNetworkUuid(class_2540 buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void writeNetworkId(class_2540 buf, int networkId) {
        buf.method_10804(networkId);
    }

    public static int readNetworkId(class_2540 buf) {
        return buf.method_10816();
    }

    public static void writeNetworkState(class_2540 buf, BasicNetworkState state) {
        PacketByteBufSerialization.writeBasicTree(buf, state.getTree());
        buf.writeInt(state.getShift());
        buf.writeInt(state.getMomentum());
        buf.writeShort(state.getAttachments().size());
        for (BasicAttachment attachment : state.getAttachments()) {
            buf.writeInt(attachment.getKey());
            buf.method_10793(attachment.getStack());
        }
    }

    public static BasicNetworkState readNetworkState(class_2540 buf) {
        BasicTree tree = PacketByteBufSerialization.readBasicTree(buf);
        int offset = buf.readInt();
        int momentum = buf.readInt();
        int numAttachments = buf.readUnsignedShort();
        BasicAttachment[] attachments = new BasicAttachment[numAttachments];
        for (int i = 0; i < numAttachments; ++i) {
            attachments[i] = new BasicAttachment(buf.readInt(), buf.method_10819());
        }
        return new BasicNetworkState(offset, momentum, tree, Arrays.asList(attachments));
    }

    public static void writeBasicTree(class_2540 buf, BasicTree tree) {
        buf.writeLong(tree.getPos().method_10063());
        buf.writeByte(tree.getEdges().size());
        for (BasicTree.Edge edge : tree.getEdges()) {
            buf.writeShort(edge.getLength());
            PacketByteBufSerialization.writeBasicTree(buf, edge.getTree());
        }
        buf.writeInt(tree.getBaseRotation());
    }

    public static BasicTree readBasicTree(class_2540 buf) {
        class_2338 pos = class_2338.method_10092((long)buf.readLong());
        int numChildren = buf.readUnsignedByte();
        BasicTree.Edge[] edges = new BasicTree.Edge[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            edges[i] = new BasicTree.Edge(buf.readUnsignedShort(), PacketByteBufSerialization.readBasicTree(buf));
        }
        return new BasicTree(pos, Arrays.asList(edges), buf.readInt());
    }

    public static void writeAttachment(class_2540 buf, BasicAttachment attachment) {
        buf.writeInt(attachment.getKey());
        buf.method_10793(attachment.getStack());
    }

    public static BasicAttachment readAttachment(class_2540 buf) {
        return new BasicAttachment(buf.readInt(), buf.method_10819());
    }
}

