/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.api.DeltaComparator;
import com.jamieswhiteshirt.clotheslinefabric.api.Line;
import com.jamieswhiteshirt.clotheslinefabric.api.Path;
import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public final class PathBuilder {
    private final Map<class_2338, NodeBuilder> nodes = new HashMap<class_2338, NodeBuilder>();
    private final List<Path.Edge> allEdges = new ArrayList<Path.Edge>();

    public int getMaxOffset() {
        if (!this.allEdges.isEmpty()) {
            return this.allEdges.get(this.allEdges.size() - 1).getToOffset();
        }
        return 0;
    }

    public NodeBuilder putNode(class_2338 pos, int baseRotation) {
        NodeBuilder nodeBuilder = new NodeBuilder(pos, baseRotation);
        this.nodes.put(pos, nodeBuilder);
        return nodeBuilder;
    }

    public Path build() {
        Map<class_2338, Path.Node> nodes = this.nodes.values().stream().map(nodeBuilder -> new Path.Node(((NodeBuilder)nodeBuilder).pos, ((NodeBuilder)nodeBuilder).edges, ((NodeBuilder)nodeBuilder).baseRotation)).collect(Collectors.toMap(Path.Node::getPos, Function.identity()));
        return new Path(nodes, new ArrayList<Path.Edge>(this.allEdges));
    }

    private static NodeBuilder buildPath(PathBuilder pathBuilder, Tree tree) {
        NodeBuilder nodeBuilder = pathBuilder.putNode(tree.getPos(), tree.getBaseRotation());
        for (Tree.Edge edge : tree.getEdges()) {
            nodeBuilder.putEdgeTo(edge.getTree().getPos(), edge.getLength());
            NodeBuilder childNodeBuilder = PathBuilder.buildPath(pathBuilder, edge.getTree());
            childNodeBuilder.putEdgeTo(tree.getPos(), edge.getLength());
        }
        return nodeBuilder;
    }

    public static Path buildPath(Tree tree) {
        PathBuilder builder = new PathBuilder();
        PathBuilder.buildPath(builder, tree);
        return builder.build();
    }

    public final class NodeBuilder {
        private final class_2338 pos;
        private final List<Path.Edge> edges = new ArrayList<Path.Edge>();
        private final int baseRotation;

        private NodeBuilder(class_2338 pos, int baseRotation) {
            this.pos = pos;
            this.baseRotation = baseRotation;
        }

        private void putEdge(Path.Edge edge, int minIndex, int maxIndex) {
            if (minIndex != maxIndex) {
                int middleIndex = (minIndex + maxIndex) / 2;
                int comparison = DeltaComparator.getInstance().compare((class_2382)edge.getDelta(), (class_2382)this.edges.get(middleIndex).getDelta());
                if (comparison < 0) {
                    this.putEdge(edge, minIndex, middleIndex);
                } else if (comparison > 0) {
                    this.putEdge(edge, middleIndex + 1, maxIndex);
                }
            } else {
                this.edges.add(minIndex, edge);
            }
        }

        public void putEdgeTo(class_2338 toPos, int length) {
            int minOffset = PathBuilder.this.getMaxOffset();
            Path.Edge edge = new Path.Edge(toPos.method_10059((class_2382)this.pos), new Line(this.pos, toPos), minOffset, minOffset + length);
            PathBuilder.this.allEdges.add(edge);
            this.putEdge(edge, 0, this.edges.size());
        }
    }
}

