/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.common.util;

import com.jamieswhiteshirt.clotheslinefabric.api.AttachmentUnit;
import com.jamieswhiteshirt.clotheslinefabric.api.DeltaComparator;
import com.jamieswhiteshirt.clotheslinefabric.api.Tree;
import com.jamieswhiteshirt.clotheslinefabric.api.util.MutableSortedIntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public final class TreeBuilder {
    private final class_2338 pos;
    private final List<Edge> edges;
    private final int rotation;

    public static TreeBuilder fromAbsolute(Tree tree, MutableSortedIntMap<class_1799> attachments, int shift) {
        ArrayList edges = new ArrayList(tree.getEdges().size());
        edges.sort((a, b) -> DeltaComparator.getInstance().compare((class_2382)((Edge)a).delta, (class_2382)((Edge)b).delta));
        return new TreeBuilder(tree.getPos(), tree.getEdges().stream().map(edge -> Edge.fromAbsolute(edge, attachments, shift)).collect(Collectors.toList()), tree.getBaseRotation() + shift);
    }

    public static TreeBuilder emptyRoot(class_2338 root) {
        return new TreeBuilder(root, new ArrayList<Edge>(), 0);
    }

    private int flooredEdgeIndex(class_2338 delta, int left, int right) {
        while (left < right) {
            int mid = (left + right) / 2;
            int comparison = DeltaComparator.getInstance().compare((class_2382)this.edges.get(mid).delta, (class_2382)delta);
            if (comparison > 0) {
                right = mid;
                continue;
            }
            left = mid + 1;
        }
        return left;
    }

    public int flooredEdgeIndex(class_2338 delta) {
        return this.flooredEdgeIndex(delta, 0, this.edges.size());
    }

    private TreeBuilder(class_2338 pos, List<Edge> edges, int rotation) {
        this.pos = pos;
        this.edges = edges;
        this.rotation = rotation;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public boolean addChild(class_2338 pos, TreeBuilder child) {
        if (this.pos.equals((Object)pos)) {
            this.addChild(child);
            return true;
        }
        for (Edge edge : this.edges) {
            if (!edge.tree.addChild(pos, child)) continue;
            return true;
        }
        return false;
    }

    private void addChild(TreeBuilder child) {
        int length = AttachmentUnit.lengthBetween(this.pos, child.pos);
        this.addEdge(new Edge(child.pos.method_10059((class_2382)this.pos), length, MutableSortedIntMap.empty(length), child, MutableSortedIntMap.empty(length)));
    }

    private void addEdge(Edge edge) {
        int insertionIndex = this.flooredEdgeIndex(edge.delta);
        this.edges.add(insertionIndex, edge);
    }

    private void removeEdge(int index) {
        this.edges.remove(index);
    }

    @Nullable
    private TreeBuilder rerootInner(class_2338 pos) {
        if (this.pos.equals((Object)pos)) {
            return this;
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = this.edges.get(i);
            TreeBuilder childTree = edge.tree;
            TreeBuilder rerooted = childTree.rerootInner(pos);
            if (rerooted == null) continue;
            this.removeEdge(i);
            childTree.addEdge(edge.reverse(this));
            return rerooted;
        }
        return null;
    }

    public TreeBuilder reroot(class_2338 pos) {
        TreeBuilder rerooted = this.rerootInner(pos);
        if (rerooted != null) {
            return rerooted;
        }
        throw new IllegalArgumentException("Position is not in TreeBuilder");
    }

    public SplitResult splitNode() {
        List<Edge> edges = this.edges.stream().map(edge -> new Edge(((Edge)edge).delta, ((Edge)edge).length, ((Edge)edge).preAttachments, TreeBuilder.emptyRoot(((Edge)edge).tree.pos), ((Edge)edge).postAttachments)).collect(Collectors.toList());
        TreeBuilder tree = new TreeBuilder(this.pos, edges, this.rotation);
        return new SplitResult(tree, this.edges.stream().map(edge -> ((Edge)edge).tree).collect(Collectors.toList()));
    }

    public SplitResult splitEdge(class_2338 edgePos) {
        for (int i = 0; i < this.edges.size(); ++i) {
            Edge edge = this.edges.get(i);
            if (!((Edge)edge).tree.pos.equals((Object)edgePos)) continue;
            TreeBuilder edgeTree = new TreeBuilder(this.pos, new ArrayList<Edge>(Collections.singletonList(new Edge(edge.delta, edge.length, edge.preAttachments, TreeBuilder.emptyRoot(((Edge)edge).tree.pos), edge.postAttachments))), this.rotation);
            TreeBuilder pastEdgeTree = edge.tree;
            ArrayList<Edge> restEdges = new ArrayList<Edge>(this.edges.size() - 1);
            restEdges.addAll(this.edges.subList(0, i));
            restEdges.addAll(this.edges.subList(i + 1, this.edges.size()));
            TreeBuilder restTree = new TreeBuilder(this.pos, restEdges, this.rotation);
            return new SplitResult(edgeTree, Arrays.asList(restTree, pastEdgeTree));
        }
        throw new IllegalArgumentException("Position is not in TreeBuilder");
    }

    public Tree build(List<MutableSortedIntMap<class_1799>> stacksList, int fromOffset) {
        int toOffset = fromOffset;
        ArrayList<Tree.Edge> treeEdges = new ArrayList<Tree.Edge>(this.edges.size());
        for (Edge edge : this.edges) {
            Tree.Edge staticEdge = edge.toAbsolute(stacksList, toOffset);
            treeEdges.add(staticEdge);
            toOffset = staticEdge.getPostMaxOffset();
        }
        return new Tree(this.pos, treeEdges, fromOffset, toOffset, this.rotation);
    }

    private Tree build(List<MutableSortedIntMap<class_1799>> stacksList, int fromOffset, class_2338 fromKey) {
        Tree.Edge staticEdge;
        int toOffset = fromOffset;
        int splitIndex = this.flooredEdgeIndex(fromKey);
        ArrayList<Tree.Edge> treeEdges = new ArrayList<Tree.Edge>(this.edges.size());
        for (Edge edge : this.edges.subList(splitIndex, this.edges.size())) {
            staticEdge = edge.toAbsolute(stacksList, toOffset);
            treeEdges.add(staticEdge);
            toOffset = staticEdge.getPostMaxOffset();
        }
        for (Edge edge : this.edges.subList(0, splitIndex)) {
            staticEdge = edge.toAbsolute(stacksList, toOffset);
            treeEdges.add(staticEdge);
            toOffset = staticEdge.getPostMaxOffset();
        }
        return new Tree(this.pos, treeEdges, fromOffset, toOffset, this.rotation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeBuilder that = (TreeBuilder)o;
        return Objects.equals(this.pos, that.pos) && Objects.equals(this.edges, that.edges);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.edges);
    }

    private static final class Edge {
        private final class_2338 delta;
        private final int length;
        private final MutableSortedIntMap<class_1799> preAttachments;
        private final TreeBuilder tree;
        private final MutableSortedIntMap<class_1799> postAttachments;

        private static Edge fromAbsolute(Tree.Edge edge, MutableSortedIntMap<class_1799> attachments, int shift) {
            return new Edge(edge.getDelta(), edge.getLength(), attachments.shiftedSubMap(edge.getPreMinOffset(), edge.getPreMaxOffset()), TreeBuilder.fromAbsolute(edge.getTree(), attachments, shift), attachments.shiftedSubMap(edge.getPostMinOffset(), edge.getPostMaxOffset()));
        }

        private Edge(class_2338 delta, int length, MutableSortedIntMap<class_1799> preAttachments, TreeBuilder tree, MutableSortedIntMap<class_1799> postAttachments) {
            this.delta = delta;
            this.length = length;
            this.preAttachments = preAttachments;
            this.tree = tree;
            this.postAttachments = postAttachments;
        }

        private Edge reverse(TreeBuilder parent) {
            return new Edge(class_2338.field_10980.method_10059((class_2382)this.delta), this.length, this.postAttachments, parent, this.preAttachments);
        }

        private Tree.Edge toAbsolute(List<MutableSortedIntMap<class_1799>> attachmentsList, int fromOffset) {
            attachmentsList.add(this.preAttachments);
            Tree tree = this.tree.build(attachmentsList, fromOffset + this.length, class_2338.field_10980.method_10059((class_2382)this.delta));
            attachmentsList.add(this.postAttachments);
            return new Tree.Edge(this.delta, this.length, fromOffset, tree);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Objects.equals(this.delta, edge.delta) && Objects.equals(this.preAttachments, edge.preAttachments) && Objects.equals(this.tree, edge.tree) && Objects.equals(this.postAttachments, edge.postAttachments);
        }

        public int hashCode() {
            return Objects.hash(this.delta, this.preAttachments, this.tree, this.postAttachments);
        }
    }

    public static final class SplitResult {
        private final TreeBuilder tree;
        private final List<TreeBuilder> subTrees;

        public SplitResult(TreeBuilder tree, List<TreeBuilder> subTrees) {
            this.tree = tree;
            this.subTrees = subTrees;
        }

        public TreeBuilder getTree() {
            return this.tree;
        }

        public List<TreeBuilder> getSubTrees() {
            return this.subTrees;
        }
    }
}

