/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.clotheslinefabric.mixin.server.world;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkCollection;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkManager;
import com.jamieswhiteshirt.clotheslinefabric.api.NetworkManagerProvider;
import com.jamieswhiteshirt.clotheslinefabric.common.NetworkProviderPersistentState;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkCollectionImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkCollectionTrackerImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.NetworkProviderImpl;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.PlayerNetworkMessenger;
import com.jamieswhiteshirt.clotheslinefabric.common.impl.ServerNetworkManager;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkCollectionTracker;
import com.jamieswhiteshirt.clotheslinefabric.internal.NetworkProvider;
import com.jamieswhiteshirt.clotheslinefabric.internal.WorldExtension;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_2802;
import net.minecraft.class_2869;
import net.minecraft.class_2874;
import net.minecraft.class_29;
import net.minecraft.class_31;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_3949;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin
extends class_1937
implements NetworkManagerProvider,
WorldExtension {
    private static final String PERSISTENT_STATE_KEY = "clothesline_provider";
    private final SetMultimap<class_1923, class_3222> chunkWatchers = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final NetworkCollection networkCollection = new NetworkCollectionImpl();
    private final NetworkProvider networkProvider = new NetworkProviderImpl(this.networkCollection, pos -> this.method_8393(class_1923.method_8325((long)pos), class_1923.method_8332((long)pos)));
    private final NetworkManager networkManager = new ServerNetworkManager((class_3218)this, this.networkCollection, this.networkProvider);
    private final NetworkCollectionTracker<class_3222> tracker = new NetworkCollectionTrackerImpl<class_3222>(this.networkCollection, arg_0 -> this.chunkWatchers.get(arg_0), new PlayerNetworkMessenger());

    protected ServerWorldMixin(class_31 levelProperties, class_2874 dimensionType, BiFunction<class_1937, class_2869, class_2802> biFunction, class_3695 profiler, boolean boolean_1) {
        super(levelProperties, dimensionType, biFunction, profiler, boolean_1);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/world/WorldSaveHandler;Lnet/minecraft/world/level/LevelProperties;Lnet/minecraft/world/dimension/DimensionType;Lnet/minecraft/util/profiler/Profiler;Lnet/minecraft/server/WorldGenerationProgressListener;)V"})
    private void constructor(MinecraftServer server, Executor executor, class_29 oldWorldSaveHandler, class_31 levelProperties, class_2874 dimensionType, class_3695 profiler, class_3949 worldGenerationProgressListener, CallbackInfo ci) {
        class_26 persistentStateManager = ((class_3218)this).method_17983();
        persistentStateManager.method_17924(() -> new NetworkProviderPersistentState(PERSISTENT_STATE_KEY, this.networkProvider), PERSISTENT_STATE_KEY);
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @Override
    public void clotheslineTick() {
        this.networkManager.update();
        this.tracker.update();
    }

    @Override
    public void onPlayerWatchChunk(class_1923 pos, class_3222 player) {
        this.chunkWatchers.put((Object)pos, (Object)player);
        this.tracker.onWatchChunk(player, pos);
    }

    @Override
    public void onPlayerUnWatchChunk(class_1923 pos, class_3222 player) {
        this.chunkWatchers.remove((Object)pos, (Object)player);
        this.tracker.onUnWatchChunk(player, pos);
    }

    @Override
    public void onChunkLoaded(class_1923 pos) {
        this.networkProvider.onChunkLoaded(pos);
    }

    @Override
    public void onChunkUnloaded(class_1923 pos) {
        this.networkProvider.onChunkUnloaded(pos);
    }
}

