/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class Box {
    private final int x1;
    private final int y1;
    private final int z1;
    private final int x2;
    private final int y2;
    private final int z2;

    private Box(int x1, int y1, int z1, int x2, int y2, int z2) {
        Preconditions.checkArgument((x2 >= x1 ? 1 : 0) != 0);
        Preconditions.checkArgument((y2 >= y1 ? 1 : 0) != 0);
        Preconditions.checkArgument((z2 >= z1 ? 1 : 0) != 0);
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public int x1() {
        return this.x1;
    }

    public int y1() {
        return this.y1;
    }

    public int z1() {
        return this.z1;
    }

    public int x2() {
        return this.x2;
    }

    public int y2() {
        return this.y2;
    }

    public int z2() {
        return this.z2;
    }

    public int getVolume() {
        return (this.x2 - this.x1) * (this.y2 - this.y1) * (this.z2 - this.z1);
    }

    public Box add(Box r) {
        return new Box(Math.min(this.x1, r.x1), Math.min(this.y1, r.y1), Math.min(this.z1, r.z1), Math.max(this.x2, r.x2), Math.max(this.y2, r.y2), Math.max(this.z2, r.z2));
    }

    public static Box create(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new Box(x1, y1, z1, x2, y2, z2);
    }

    public boolean intersects(Box r) {
        return this.x1 <= r.x2 && this.x2 >= r.x1 && this.y1 <= r.y2 && this.y2 >= r.y1 && this.z1 <= r.z2 && this.z2 >= r.z1;
    }

    public boolean contains(Box r) {
        return this.x1 <= r.x1 && this.x2 >= r.x2 && this.y1 <= r.y1 && this.y2 >= r.y2 && this.z1 <= r.z1 && this.z2 >= r.z2;
    }

    public boolean containedBy(Box r) {
        return r.x1 <= this.x1 && r.x2 >= this.x2 && r.y1 <= this.y1 && r.y2 >= this.y2 && r.z1 <= this.z1 && r.z2 >= this.z2;
    }

    public int intersectionVolume(Box r) {
        if (!this.intersects(r)) {
            return 0;
        }
        return Box.create(Math.max(this.x1, r.x1), Math.max(this.y1, r.y1), Math.max(this.z1, r.z1), Math.min(this.x2, r.x2), Math.min(this.y2, r.y2), Math.min(this.z2, r.z2)).getVolume();
    }

    public int surfaceArea() {
        return 2 * ((this.x2 - this.x1) * (this.y2 - this.y1) + (this.y2 - this.y1) * (this.z2 - this.z1) + (this.x2 - this.x1) * (this.z2 - this.z1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Box box = (Box)o;
        return this.x1 == box.x1 && this.y1 == box.y1 && this.z1 == box.z1 && this.x2 == box.x2 && this.y2 == box.y2 && this.z2 == box.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.z2, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Box{x1=" + this.x1 + ", y1=" + this.y1 + ", z1=" + this.z1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", z2=" + this.z2 + '}';
    }
}

