/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Bucket;
import com.jamieswhiteshirt.rtree3i.Configuration;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Groups;
import com.jamieswhiteshirt.rtree3i.Node;
import com.jamieswhiteshirt.rtree3i.NodeAndEntries;
import com.jamieswhiteshirt.rtree3i.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class Branch<K, V>
implements Node<K, V> {
    private final List<Node<K, V>> children;
    private final Box box;
    private final int size;

    static <K, V> Branch<K, V> containing(List<Node<K, V>> children) {
        return new Branch<K, V>(children, Util.mbb(children.stream().map(Node::getBox).collect(Collectors.toList())));
    }

    Branch(List<Node<K, V>> children, Box box) {
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0);
        this.children = children;
        this.box = box;
        int size = 0;
        for (Node<K, V> child : children) {
            size += child.size();
        }
        this.size = size;
    }

    private List<Node<K, V>> makeNonLeaves(Groups<Node<K, V>> pair) {
        ArrayList<Node<K, V>> list = new ArrayList<Node<K, V>>();
        list.add(Branch.containing(pair.getGroup1().getEntries()));
        list.add(Branch.containing(pair.getGroup2().getEntries()));
        return list;
    }

    private Node<K, V> selectChildForPut(Box box, Configuration configuration) {
        for (Node<K, V> child : this.children) {
            if (!child.containsBucket(box)) continue;
            return child;
        }
        return configuration.getSelector().select(box, this.children);
    }

    @Override
    public List<Node<K, V>> put(Box box, Entry<K, V> entry, Configuration configuration) {
        List<Node<K, V>> list;
        Node<K, V> child = this.selectChildForPut(box, configuration);
        List<Node<K, V>> children2 = Util.replace(this.children, child, list = child.put(box, entry, configuration));
        if (children2.size() <= configuration.getMaxChildren()) {
            return Collections.singletonList(Branch.containing(children2));
        }
        Groups<Node<K, V>> pair = configuration.getSplitter().split(children2, configuration.getMinChildren(), Node::getBox);
        return this.makeNonLeaves(pair);
    }

    @Override
    public List<Node<K, V>> putBucket(Bucket<K, V> bucket, Configuration configuration) {
        List<Node<K, V>> list;
        Node<K, V> child = this.selectChildForPut(bucket.getBox(), configuration);
        List<Node<K, V>> children2 = Util.replace(this.children, child, list = child.putBucket(bucket, configuration));
        if (children2.size() <= configuration.getMaxChildren()) {
            return Collections.singletonList(Branch.containing(children2));
        }
        Groups<Node<K, V>> pair = configuration.getSplitter().split(children2, configuration.getMinChildren(), Node::getBox);
        return this.makeNonLeaves(pair);
    }

    @Override
    public NodeAndEntries<K, V> remove(Box box, Entry<K, V> entry, Configuration configuration) {
        ArrayList addTheseEntries = new ArrayList();
        ArrayList<Node<Entry<K, V>, V>> removeTheseNodes = new ArrayList<Node<Entry<K, V>, V>>();
        ArrayList<Node<Entry<K, V>, V>> addTheseNodes = new ArrayList<Node<Entry<K, V>, V>>();
        int countDeleted = 0;
        for (Node<Entry<K, V>, V> node : this.children) {
            if (!node.getBox().contains(box)) continue;
            NodeAndEntries<Entry<K, V>, V> result = node.remove(box, entry, configuration);
            if (result.getNode() != null) {
                if (result.getNode() == node) continue;
                addTheseNodes.add(result.getNode());
                removeTheseNodes.add(node);
                addTheseEntries.addAll(result.getEntriesToAdd());
                countDeleted += result.countDeleted();
                continue;
            }
            removeTheseNodes.add(node);
            addTheseEntries.addAll(result.getEntriesToAdd());
            countDeleted += result.countDeleted();
        }
        if (removeTheseNodes.isEmpty()) {
            return new NodeAndEntries(this, Collections.emptyList(), 0);
        }
        List nodes = Util.remove(this.children, removeTheseNodes);
        nodes.addAll(addTheseNodes);
        if (nodes.size() == 0) {
            return new NodeAndEntries(null, addTheseEntries, countDeleted);
        }
        Branch<K, V> branch = Branch.containing(nodes);
        return new NodeAndEntries<K, V>(branch, addTheseEntries, countDeleted);
    }

    @Override
    public NodeAndEntries<K, V> remove(Box box, K key, Configuration configuration) {
        ArrayList addTheseEntries = new ArrayList();
        ArrayList<Node<K, V>> removeTheseNodes = new ArrayList<Node<K, V>>();
        ArrayList<Node<K, V>> addTheseNodes = new ArrayList<Node<K, V>>();
        int countDeleted = 0;
        for (Node<K, V> child : this.children) {
            if (!child.getBox().contains(box)) continue;
            NodeAndEntries<K, V> result = child.remove(box, key, configuration);
            if (result.getNode() != null) {
                if (result.getNode() == child) continue;
                addTheseNodes.add(result.getNode());
                removeTheseNodes.add(child);
                addTheseEntries.addAll(result.getEntriesToAdd());
                countDeleted += result.countDeleted();
                continue;
            }
            removeTheseNodes.add(child);
            addTheseEntries.addAll(result.getEntriesToAdd());
            countDeleted += result.countDeleted();
        }
        if (removeTheseNodes.isEmpty()) {
            return new NodeAndEntries(this, Collections.emptyList(), 0);
        }
        List nodes = Util.remove(this.children, removeTheseNodes);
        nodes.addAll(addTheseNodes);
        if (nodes.size() == 0) {
            return new NodeAndEntries(null, addTheseEntries, countDeleted);
        }
        Branch<K, V> node = Branch.containing(nodes);
        return new NodeAndEntries<K, V>(node, addTheseEntries, countDeleted);
    }

    @Override
    public Entry<K, V> get(Box box, K key) {
        for (Node<K, V> child : this.children) {
            Entry<K, V> entry;
            if (!child.getBox().contains(box) || (entry = child.get(box, key)) == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void forEach(Predicate<? super Box> boxPredicate, Consumer<? super Entry<K, V>> action) {
        if (boxPredicate.test(this.box)) {
            for (Node<K, V> child : this.children) {
                child.forEach(boxPredicate, action);
            }
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super Box> boxPredicate, Predicate<? super Entry<K, V>> entryPredicate) {
        if (boxPredicate.test(this.box)) {
            for (Node<K, V> child : this.children) {
                if (!child.anyMatch(boxPredicate, entryPredicate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super Box> boxPredicate, Predicate<? super Entry<K, V>> entryPredicate) {
        if (boxPredicate.test(this.box)) {
            for (Node<K, V> child : this.children) {
                if (child.allMatch(boxPredicate, entryPredicate)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T reduce(Predicate<? super Box> boxPredicate, T identity, BiFunction<T, Entry<K, V>, T> operator) {
        if (boxPredicate.test(this.box)) {
            T acc = identity;
            for (Node<K, V> child : this.children) {
                acc = child.reduce(boxPredicate, acc, operator);
            }
            return acc;
        }
        return identity;
    }

    @Override
    public int count(Predicate<? super Box> boxPredicate, Predicate<? super Entry<K, V>> entryPredicate) {
        if (boxPredicate.test(this.box)) {
            int count = 0;
            for (Node<K, V> child : this.children) {
                count += child.count(boxPredicate, entryPredicate);
            }
            return count;
        }
        return 0;
    }

    @Override
    public boolean contains(Box box, Entry<K, V> entry) {
        if (this.box.contains(box)) {
            for (Node<K, V> child : this.children) {
                if (!child.contains(box, entry)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsBucket(Box box) {
        if (this.box.contains(box)) {
            for (Node<K, V> child : this.children) {
                if (!child.containsBucket(box)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int calculateDepth() {
        return this.children.get(0).calculateDepth() + 1;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String asString(String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("mbb=");
        s.append(this.getBox());
        s.append('\n');
        for (Node<K, V> child : this.children) {
            s.append(child.asString("  " + margin));
        }
        return s.toString();
    }

    public String toString() {
        return this.asString("");
    }
}

