/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Util;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class Bucket<K, V> {
    private final Box box;
    private final List<Entry<K, V>> entries;

    static <K, V> Bucket<K, V> of(Box box, Entry<K, V> entry) {
        return Bucket.of(box, Collections.singletonList(entry));
    }

    static <K, V> Bucket<K, V> of(Box box, List<Entry<K, V>> entries) {
        return new Bucket<K, V>(box, entries);
    }

    private Bucket(Box box, List<Entry<K, V>> entries) {
        this.box = box;
        this.entries = entries;
    }

    public Box getBox() {
        return this.box;
    }

    public Bucket<K, V> put(Entry<K, V> entry) {
        for (Entry<K, V> existingEntry : this.entries) {
            if (!existingEntry.getKey().equals(entry.getKey())) continue;
            return new Bucket<K, V>(this.box, Util.replace(this.entries, existingEntry, entry));
        }
        return new Bucket<K, V>(this.box, Util.add(this.entries, entry));
    }

    public Bucket<K, V> remove(Entry<K, V> entry) {
        if (this.entries.size() == 1) {
            if (this.entries.get(0).equals(entry)) {
                return null;
            }
        } else {
            return new Bucket<K, V>(this.box, Util.remove(this.entries, entry));
        }
        return this;
    }

    public Bucket<K, V> remove(K key) {
        if (this.entries.size() == 1) {
            if (this.entries.get(0).getKey().equals(key)) {
                return null;
            }
        } else {
            for (Entry<K, V> entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                return new Bucket<K, V>(this.box, Util.remove(this.entries, entry));
            }
        }
        return this;
    }

    public Entry<K, V> get(K key) {
        for (Entry<K, V> entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public void forEach(Consumer<? super Entry<K, V>> action) {
        this.entries.forEach(action);
    }

    public boolean anyMatch(Predicate<? super Entry<K, V>> entryPredicate) {
        for (Entry<K, V> entry : this.entries) {
            if (!entryPredicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean allMatch(Predicate<? super Entry<K, V>> entryPredicate) {
        for (Entry<K, V> entry : this.entries) {
            if (entryPredicate.test(entry)) continue;
            return false;
        }
        return true;
    }

    public <T> T reduce(T identity, BiFunction<T, Entry<K, V>, T> operator) {
        T acc = identity;
        for (Entry<K, V> entry : this.entries) {
            acc = operator.apply(acc, entry);
        }
        return acc;
    }

    public int count(Predicate<? super Entry<K, V>> entryPredicate) {
        int count = 0;
        for (Entry<K, V> entry : this.entries) {
            if (!entryPredicate.test(entry)) continue;
            ++count;
        }
        return count;
    }

    public boolean contains(Entry<K, V> entry) {
        return this.entries.contains(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public String toString() {
        return "Bucket{box=" + this.box + ", entries=" + this.entries + '}';
    }
}

