/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import com.jamieswhiteshirt.rtree3i.Selector;
import com.jamieswhiteshirt.rtree3i.Splitter;

public final class Configuration {
    private final int maxChildren;
    private final int minChildren;
    private final Splitter splitter;
    private final Selector selector;

    public Configuration(int minChildren, int maxChildren, Selector selector, Splitter splitter) {
        Preconditions.checkNotNull((Object)splitter);
        Preconditions.checkNotNull((Object)selector);
        Preconditions.checkArgument((maxChildren > 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((minChildren >= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((minChildren < maxChildren ? 1 : 0) != 0);
        this.selector = selector;
        this.maxChildren = maxChildren;
        this.minChildren = minChildren;
        this.splitter = splitter;
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public int getMinChildren() {
        return this.minChildren;
    }

    public Splitter getSplitter() {
        return this.splitter;
    }

    public Selector getSelector() {
        return this.selector;
    }
}

