/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.jamieswhiteshirt.rtree3i.Configuration;
import com.jamieswhiteshirt.rtree3i.Selector;
import com.jamieswhiteshirt.rtree3i.SelectorMinimalVolumeIncrease;
import com.jamieswhiteshirt.rtree3i.SelectorRStar;
import com.jamieswhiteshirt.rtree3i.Splitter;
import com.jamieswhiteshirt.rtree3i.SplitterQuadratic;
import com.jamieswhiteshirt.rtree3i.SplitterRStar;

public final class ConfigurationBuilder {
    private static final int MAX_CHILDREN_DEFAULT_GUTTMAN = 4;
    private static final int MAX_CHILDREN_DEFAULT_STAR = 4;
    private static final double DEFAULT_FILLING_FACTOR = 0.4;
    private Integer maxChildren = null;
    private Integer minChildren = null;
    private Splitter splitter = new SplitterQuadratic();
    private Selector selector = new SelectorMinimalVolumeIncrease();
    private boolean star = false;

    public ConfigurationBuilder minChildren(int minChildren) {
        this.minChildren = minChildren;
        return this;
    }

    public ConfigurationBuilder maxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
        return this;
    }

    public ConfigurationBuilder splitter(Splitter splitter) {
        this.splitter = splitter;
        return this;
    }

    public ConfigurationBuilder selector(Selector selector) {
        this.selector = selector;
        return this;
    }

    public ConfigurationBuilder star() {
        this.selector = new SelectorRStar();
        this.splitter = new SplitterRStar();
        this.star = true;
        return this;
    }

    public Configuration build() {
        if (this.maxChildren == null) {
            this.maxChildren = this.star ? 4 : 4;
        }
        if (this.minChildren == null) {
            this.minChildren = (int)Math.round((double)this.maxChildren.intValue() * 0.4);
        }
        return new Configuration(this.minChildren, this.maxChildren, this.selector, this.splitter);
    }
}

