/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class Entry<K, V> {
    private final K key;
    private final V value;

    private Entry(K key, V value) {
        Preconditions.checkNotNull(key);
        this.key = key;
        this.value = value;
    }

    public static <K, V> Entry<K, V> of(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public String toString() {
        return "Entry{key=" + this.key + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entry entry = (Entry)o;
        return Objects.equals(this.key, entry.key) && Objects.equals(this.value, entry.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

