/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Node;
import com.jamieswhiteshirt.rtree3i.Selection;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

final class FilteredNodeSelection<K, V, T>
implements Selection<T> {
    private final Node<K, V> node;
    private final Predicate<? super Box> boxPredicate;
    private final Predicate<? super T> filter;
    private final Function<Entry<K, V>, T> entryValueMapper;

    FilteredNodeSelection(Node<K, V> node, Predicate<? super Box> boxPredicate, Predicate<? super T> filter, Function<Entry<K, V>, T> entryMappper) {
        this.node = node;
        this.boxPredicate = boxPredicate;
        this.filter = filter;
        this.entryValueMapper = entryMappper;
    }

    @Override
    public Selection<T> filter(Predicate<? super T> predicate) {
        Predicate filter = this.filter;
        return new FilteredNodeSelection<K, V, Object>(this.node, this.boxPredicate, t -> filter.test(t) && predicate.test(t), this.entryValueMapper);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.node.forEach(this.boxPredicate, entry -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            if (this.filter.test(value)) {
                action.accept((T)value);
            }
        });
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.node.anyMatch(this.boxPredicate, entry -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            return this.filter.test(value) && predicate.test((T)value);
        });
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.node.allMatch(this.boxPredicate, entry -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            return !this.filter.test(value) || predicate.test((T)value);
        });
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.node.anyMatch(this.boxPredicate, entry -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            return !this.filter.test(value) || predicate.test((T)value);
        });
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return (T)this.node.reduce(this.boxPredicate, identity, (acc, entry) -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            return this.filter.test(value) ? accumulator.apply(acc, value) : acc;
        });
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        Object container = supplier.get();
        this.node.forEach(this.boxPredicate, entry -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            if (this.filter.test(value)) {
                accumulator.accept(container, (T)value);
            }
        });
        return container;
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        Object container = collector.supplier().get();
        this.node.forEach(this.boxPredicate, entry -> {
            T value = this.entryValueMapper.apply((Entry<K, V>)entry);
            if (this.filter.test(value)) {
                collector.accumulator().accept(container, value);
            }
        });
        return collector.finisher().apply(container);
    }

    @Override
    public int count() {
        return this.node.count(this.boxPredicate, entry -> this.filter.test(this.entryValueMapper.apply((Entry<K, V>)entry)));
    }

    @Override
    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return this.node.anyMatch(this.boxPredicate, entry -> this.filter.test(this.entryValueMapper.apply((Entry<K, V>)entry)));
    }
}

