/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Bucket;
import com.jamieswhiteshirt.rtree3i.Configuration;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Groups;
import com.jamieswhiteshirt.rtree3i.Node;
import com.jamieswhiteshirt.rtree3i.NodeAndEntries;
import com.jamieswhiteshirt.rtree3i.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class Leaf<K, V>
implements Node<K, V> {
    private final List<Bucket<K, V>> buckets;
    private final Box box;

    static <K, V> Leaf<K, V> containing(List<Bucket<K, V>> buckets) {
        return new Leaf<K, V>(buckets, Util.mbb(buckets.stream().map(Bucket::getBox).collect(Collectors.toList())));
    }

    static <K, V> Leaf<K, V> containing(Bucket<K, V> bucket) {
        return new Leaf<K, V>(Collections.singletonList(bucket), bucket.getBox());
    }

    Leaf(List<Bucket<K, V>> buckets, Box box) {
        Preconditions.checkArgument((!buckets.isEmpty() ? 1 : 0) != 0);
        this.buckets = buckets;
        this.box = box;
    }

    private List<Node<K, V>> makeLeaves(Groups<Bucket<K, V>> pair) {
        ArrayList<Node<K, V>> list = new ArrayList<Node<K, V>>();
        list.add(Leaf.containing(pair.getGroup1().getEntries()));
        list.add(Leaf.containing(pair.getGroup2().getEntries()));
        return list;
    }

    @Override
    public List<Node<K, V>> put(Box box, Entry<K, V> entry, Configuration configuration) {
        for (Bucket<K, V> bucket : this.buckets) {
            if (!bucket.getBox().equals(box)) continue;
            return Collections.singletonList(Leaf.containing(Util.replace(this.buckets, bucket, bucket.put(entry))));
        }
        Bucket<K, V> bucket = Bucket.of(box, entry);
        List<Bucket<K, V>> newBuckets = Util.add(this.buckets, bucket);
        if (newBuckets.size() <= configuration.getMaxChildren()) {
            return Collections.singletonList(Leaf.containing(newBuckets));
        }
        Groups<Bucket<K, V>> pair = configuration.getSplitter().split(newBuckets, configuration.getMinChildren(), Bucket::getBox);
        return this.makeLeaves(pair);
    }

    @Override
    public List<Node<K, V>> putBucket(Bucket<K, V> bucket, Configuration configuration) {
        for (Bucket<K, V> existingBucket : this.buckets) {
            if (!existingBucket.getBox().equals(bucket.getBox())) continue;
            return Collections.singletonList(Leaf.containing(Util.replace(this.buckets, existingBucket, bucket)));
        }
        List<Bucket<K, V>> newBuckets = Util.add(this.buckets, bucket);
        if (newBuckets.size() <= configuration.getMaxChildren()) {
            return Collections.singletonList(Leaf.containing(newBuckets));
        }
        Groups<Bucket<K, V>> pair = configuration.getSplitter().split(newBuckets, configuration.getMinChildren(), Bucket::getBox);
        return this.makeLeaves(pair);
    }

    @Override
    public NodeAndEntries<K, V> remove(Box box, Entry<K, V> entry, Configuration configuration) {
        for (Bucket<Entry<K, V>, V> bucket : this.buckets) {
            if (!bucket.getBox().equals(box)) continue;
            Bucket<Entry<K, V>, V> newBucket = bucket.remove(entry);
            List<Bucket<Object, V>> newBuckets = newBucket == null ? Util.remove(this.buckets, bucket) : Util.replace(this.buckets, bucket, newBucket);
            if (newBuckets.size() >= configuration.getMinChildren()) {
                Leaf<K, V> node = newBuckets.isEmpty() ? null : Leaf.containing(newBuckets);
                return new NodeAndEntries<K, V>(node, Collections.emptyList(), 1);
            }
            return new NodeAndEntries<K, V>(null, newBuckets, 1);
        }
        return new NodeAndEntries(this, Collections.emptyList(), 0);
    }

    @Override
    public NodeAndEntries<K, V> remove(Box box, K key, Configuration configuration) {
        for (Bucket<K, V> bucket : this.buckets) {
            if (!bucket.getBox().equals(box)) continue;
            Bucket<K, V> newBucket = bucket.remove(key);
            List<Bucket<K, V>> newBuckets = newBucket == null ? Util.remove(this.buckets, bucket) : Util.replace(this.buckets, bucket, newBucket);
            if (newBuckets.size() >= configuration.getMinChildren()) {
                Leaf<K, V> node = newBuckets.isEmpty() ? null : Leaf.containing(newBuckets);
                return new NodeAndEntries<K, V>(node, Collections.emptyList(), 1);
            }
            return new NodeAndEntries<K, V>(null, newBuckets, 1);
        }
        return new NodeAndEntries(this, Collections.emptyList(), 0);
    }

    @Override
    public Entry<K, V> get(Box box, K key) {
        for (Bucket<K, V> bucket : this.buckets) {
            if (!bucket.getBox().equals(box)) continue;
            return bucket.get(key);
        }
        return null;
    }

    @Override
    public void forEach(Predicate<? super Box> boxPredicate, Consumer<? super Entry<K, V>> action) {
        if (boxPredicate.test(this.box)) {
            for (Bucket<K, V> bucket : this.buckets) {
                if (!boxPredicate.test(bucket.getBox())) continue;
                bucket.forEach(action);
            }
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super Box> boxPredicate, Predicate<? super Entry<K, V>> entryPredicate) {
        if (boxPredicate.test(this.box)) {
            for (Bucket<K, V> bucket : this.buckets) {
                if (!boxPredicate.test(bucket.getBox()) || !bucket.anyMatch(entryPredicate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super Box> boxPredicate, Predicate<? super Entry<K, V>> entryPredicate) {
        if (boxPredicate.test(this.box)) {
            for (Bucket<K, V> bucket : this.buckets) {
                if (boxPredicate.test(bucket.getBox()) || bucket.allMatch(entryPredicate)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T reduce(Predicate<? super Box> boxPredicate, T identity, BiFunction<T, Entry<K, V>, T> operator) {
        if (boxPredicate.test(this.box)) {
            T acc = identity;
            for (Bucket<K, V> bucket : this.buckets) {
                if (!boxPredicate.test(bucket.getBox())) continue;
                acc = bucket.reduce(acc, operator);
            }
            return acc;
        }
        return identity;
    }

    @Override
    public int count(Predicate<? super Box> boxPredicate, Predicate<? super Entry<K, V>> entryPredicate) {
        if (boxPredicate.test(this.box)) {
            int count = 0;
            for (Bucket<K, V> bucket : this.buckets) {
                if (!boxPredicate.test(bucket.getBox())) continue;
                count += bucket.count(entryPredicate);
            }
            return count;
        }
        return 0;
    }

    @Override
    public boolean contains(Box box, Entry<K, V> entry) {
        if (this.box.contains(box)) {
            for (Bucket<K, V> bucket : this.buckets) {
                if (!bucket.getBox().equals(box)) continue;
                return bucket.contains(entry);
            }
        }
        return false;
    }

    @Override
    public boolean containsBucket(Box box) {
        if (this.box.contains(box)) {
            for (Bucket<K, V> bucket : this.buckets) {
                if (!bucket.getBox().equals(box)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int calculateDepth() {
        return 1;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    @Override
    public int size() {
        int size = 0;
        for (Bucket<K, V> bucket : this.buckets) {
            size += bucket.size();
        }
        return size;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public String asString(String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("mbb=");
        s.append(this.getBox());
        s.append('\n');
        for (Bucket<K, V> bucket : this.buckets) {
            s.append(margin).append("  ").append(bucket.toString());
        }
        return s.toString();
    }

    public String toString() {
        return this.asString("");
    }
}

