/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.FilteredNodeSelection;
import com.jamieswhiteshirt.rtree3i.Node;
import com.jamieswhiteshirt.rtree3i.Selection;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

final class NodeSelection<K, V, T>
implements Selection<T> {
    private final Node<K, V> node;
    private final Predicate<? super Box> boxPredicate;
    private final Function<Entry<K, V>, T> entryValueMapper;

    public static <K, V, T> Selection<T> create(Node<K, V> root, Predicate<? super Box> boxPredicate, Function<Entry<K, V>, T> entryMapper) {
        return new NodeSelection<K, V, T>(root, boxPredicate, entryMapper);
    }

    private NodeSelection(Node<K, V> node, Predicate<? super Box> boxPredicate, Function<Entry<K, V>, T> entryMappper) {
        this.node = node;
        this.boxPredicate = boxPredicate;
        this.entryValueMapper = entryMappper;
    }

    @Override
    public Selection<T> filter(Predicate<? super T> predicate) {
        return new FilteredNodeSelection<K, V, T>(this.node, this.boxPredicate, predicate, this.entryValueMapper);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.node.forEach(this.boxPredicate, entry -> action.accept((T)this.entryValueMapper.apply((Entry<K, V>)entry)));
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.node.anyMatch(this.boxPredicate, entry -> predicate.test((T)this.entryValueMapper.apply((Entry<K, V>)entry)));
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.node.allMatch(this.boxPredicate, entry -> predicate.test((T)this.entryValueMapper.apply((Entry<K, V>)entry)));
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.node.anyMatch(this.boxPredicate, entry -> predicate.test((T)this.entryValueMapper.apply((Entry<K, V>)entry)));
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return (T)this.node.reduce(this.boxPredicate, identity, (acc, entry) -> accumulator.apply(acc, this.entryValueMapper.apply((Entry<K, V>)entry)));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        Object container = supplier.get();
        this.node.forEach(this.boxPredicate, entry -> accumulator.accept(container, (T)this.entryValueMapper.apply((Entry<K, V>)entry)));
        return container;
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        Object container = collector.supplier().get();
        this.node.forEach(this.boxPredicate, entry -> collector.accumulator().accept(container, this.entryValueMapper.apply((Entry<K, V>)entry)));
        return collector.finisher().apply(container);
    }

    @Override
    public int count() {
        return this.node.count(this.boxPredicate, entry -> true);
    }

    @Override
    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return this.node.anyMatch(this.boxPredicate, entry -> true);
    }
}

