/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Branch;
import com.jamieswhiteshirt.rtree3i.Bucket;
import com.jamieswhiteshirt.rtree3i.Configuration;
import com.jamieswhiteshirt.rtree3i.EmptySelection;
import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Leaf;
import com.jamieswhiteshirt.rtree3i.Node;
import com.jamieswhiteshirt.rtree3i.NodeAndEntries;
import com.jamieswhiteshirt.rtree3i.NodeSelection;
import com.jamieswhiteshirt.rtree3i.Selection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public final class RTreeMap<K, V> {
    private final Node<K, V> root;
    private final Configuration configuration;
    private final Function<? super K, Box> keyBoxMapper;

    public static <V> RTreeMap<Box, V> create(Configuration configuration) {
        return RTreeMap.create(configuration, Function.identity());
    }

    public static <K, V> RTreeMap<K, V> create(Configuration configuration, Function<? super K, Box> keyBoxMapper) {
        return new RTreeMap<K, V>(null, configuration, keyBoxMapper);
    }

    private RTreeMap(Node<K, V> root, Configuration configuration, Function<? super K, Box> keyBoxMapper) {
        this.root = root;
        this.configuration = configuration;
        this.keyBoxMapper = keyBoxMapper;
    }

    public Selection<K> keys() {
        return this.keys(box -> true);
    }

    public Selection<K> keys(Predicate<? super Box> boxPredicate) {
        return this.root != null ? NodeSelection.create(this.root, boxPredicate, Entry::getKey) : EmptySelection.create();
    }

    public Selection<V> values() {
        return this.values(box -> true);
    }

    public Selection<V> values(Predicate<? super Box> boxPredicate) {
        return this.root != null ? NodeSelection.create(this.root, boxPredicate, Entry::getValue) : EmptySelection.create();
    }

    public Selection<Entry<K, V>> entries() {
        return this.entries(box -> true);
    }

    public Selection<Entry<K, V>> entries(Predicate<? super Box> boxPredicate) {
        return this.root != null ? NodeSelection.create(this.root, boxPredicate, Function.identity()) : EmptySelection.create();
    }

    public int calculateDepth() {
        return this.root != null ? this.root.calculateDepth() : 0;
    }

    public boolean contains(Entry<K, V> entry) {
        return this.root != null && this.root.contains(this.keyBoxMapper.apply(entry.getKey()), entry);
    }

    public RTreeMap<K, V> put(Entry<K, V> entry) {
        Box box = this.keyBoxMapper.apply(entry.getKey());
        if (this.root != null) {
            List<Node<K, V>> nodes = this.root.put(box, entry, this.configuration);
            Node<K, V> node = nodes.size() == 1 ? nodes.get(0) : Branch.containing(nodes);
            return new RTreeMap<K, V>(node, this.configuration, this.keyBoxMapper);
        }
        return new RTreeMap<K, V>(Leaf.containing(Bucket.of(box, entry)), this.configuration, this.keyBoxMapper);
    }

    public RTreeMap<K, V> put(K key, V value) {
        return this.put(Entry.of(key, value));
    }

    public RTreeMap<K, V> putAll(Iterable<Entry<K, V>> entries) {
        RTreeMap<K, V> tree = this;
        for (Entry<K, V> entry : entries) {
            tree = tree.put(entry);
        }
        return tree;
    }

    public RTreeMap<K, V> removeAll(Iterable<Entry<K, V>> entries) {
        RTreeMap<Entry<Entry<K, V>, V>, V> tree = this;
        for (Entry<K, V> entry : entries) {
            tree = tree.remove((Entry<Entry<K, V>, V>)entry);
        }
        return tree;
    }

    public RTreeMap<K, V> remove(K key, V value) {
        return this.remove((K)Entry.of(key, value));
    }

    public RTreeMap<K, V> remove(Entry<K, V> entry) {
        if (this.root != null) {
            NodeAndEntries<Entry<K, V>, V> nodeAndEntries = this.root.remove(this.keyBoxMapper.apply(entry.getKey()), entry, this.configuration);
            if (nodeAndEntries.getNode() == this.root) {
                return this;
            }
            Node<Entry<Entry<K, V>, V>, V> node = nodeAndEntries.getNode();
            for (Bucket<Entry<K, V>, V> bucket : nodeAndEntries.getEntriesToAdd()) {
                if (node != null) {
                    List nodes = node.putBucket(bucket, this.configuration);
                    if (nodes.size() == 1) {
                        node = nodes.get(0);
                        continue;
                    }
                    node = Branch.containing(nodes);
                    continue;
                }
                node = Leaf.containing(bucket);
            }
            return new RTreeMap<K, V>(node, this.configuration, this.keyBoxMapper);
        }
        return this;
    }

    public RTreeMap<K, V> remove(K key) {
        if (this.root != null) {
            NodeAndEntries<K, V> nodeAndEntries = this.root.remove(this.keyBoxMapper.apply(key), key, this.configuration);
            if (nodeAndEntries.getNode() == this.root) {
                return this;
            }
            Node<K, V> node = nodeAndEntries.getNode();
            for (Bucket<K, V> bucket : nodeAndEntries.getEntriesToAdd()) {
                if (node != null) {
                    List<Node<K, V>> nodes = node.putBucket(bucket, this.configuration);
                    if (nodes.size() == 1) {
                        node = nodes.get(0);
                        continue;
                    }
                    node = Branch.containing(nodes);
                    continue;
                }
                node = Leaf.containing(bucket);
            }
            return new RTreeMap<K, V>(node, this.configuration, this.keyBoxMapper);
        }
        return this;
    }

    public V get(K key) {
        if (this.root != null) {
            Entry<K, V> entry = this.root.get(this.keyBoxMapper.apply(key), key);
            return entry != null ? (V)entry.getValue() : null;
        }
        return null;
    }

    public boolean containsKey(K key) {
        return this.root != null && this.root.get(this.keyBoxMapper.apply(key), key) != null;
    }

    public Box getMbb() {
        return this.root != null ? this.root.getBox() : null;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        return this.root != null ? this.root.size() : 0;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return this.root != null ? this.root.toString() : "";
    }
}

