/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Group;
import com.jamieswhiteshirt.rtree3i.Groups;
import com.jamieswhiteshirt.rtree3i.Pair;
import com.jamieswhiteshirt.rtree3i.Splitter;
import com.jamieswhiteshirt.rtree3i.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SplitterQuadratic
implements Splitter {
    @Override
    public <T> Groups<T> split(List<T> items, int minSize, Function<T, Box> boxAccessor) {
        Preconditions.checkArgument((items.size() >= 2 ? 1 : 0) != 0);
        Pair<T> worstCombination = SplitterQuadratic.worstCombination(items, boxAccessor);
        ArrayList group1 = Lists.newArrayList((Object[])new Object[]{worstCombination.getValue1()});
        ArrayList group2 = Lists.newArrayList((Object[])new Object[]{worstCombination.getValue2()});
        ArrayList<T> remaining = new ArrayList<T>(items);
        remaining.remove(worstCombination.getValue1());
        remaining.remove(worstCombination.getValue2());
        int minGroupSize = items.size() / 2;
        while (remaining.size() > 0) {
            this.assignRemaining(group1, group2, remaining, minGroupSize, boxAccessor);
        }
        return new Groups<T>(Group.of(group1, boxAccessor), Group.of(group2, boxAccessor));
    }

    private <T> void assignRemaining(List<T> group1, List<T> group2, List<T> remaining, int minGroupSize, Function<T, Box> key) {
        boolean volume1LessThanVolume2;
        Box mbb1 = Util.mbb(group1.stream().map(key).collect(Collectors.toList()));
        Box mbb2 = Util.mbb(group2.stream().map(key).collect(Collectors.toList()));
        T item1 = SplitterQuadratic.getBestCandidateForGroup(remaining, mbb1, key);
        T item2 = SplitterQuadratic.getBestCandidateForGroup(remaining, mbb2, key);
        boolean bl = volume1LessThanVolume2 = key.apply(item1).add(mbb1).getVolume() <= key.apply(item2).add(mbb2).getVolume();
        if (volume1LessThanVolume2 && group2.size() + remaining.size() - 1 >= minGroupSize || !volume1LessThanVolume2 && group1.size() + remaining.size() == minGroupSize) {
            group1.add(item1);
            remaining.remove(item1);
        } else {
            group2.add(item2);
            remaining.remove(item2);
        }
    }

    static <T> T getBestCandidateForGroup(List<T> list, Box groupMbb, Function<T, Box> key) {
        T minEntry = null;
        int minVolume = Integer.MAX_VALUE;
        for (T entry : list) {
            int volume = groupMbb.add(key.apply(entry)).getVolume();
            if (volume >= minVolume) continue;
            minVolume = volume;
            minEntry = entry;
        }
        return minEntry;
    }

    static <T> Pair<T> worstCombination(List<T> items, Function<T, Box> key) {
        Object e1 = null;
        Object e2 = null;
        int maxVolume = Integer.MIN_VALUE;
        for (T entry1 : items) {
            for (T entry2 : items) {
                int volume;
                if (entry1 == entry2 || (volume = key.apply(entry1).add(key.apply(entry2)).getVolume()) <= maxVolume) continue;
                e1 = entry1;
                e2 = entry2;
                maxVolume = volume;
            }
        }
        return e1 != null ? new Pair<Object>(e1, e2) : new Pair<T>(items.get(0), items.get(1));
    }
}

