/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import com.jamieswhiteshirt.rtree3i.Box;
import com.jamieswhiteshirt.rtree3i.Comparators;
import com.jamieswhiteshirt.rtree3i.Group;
import com.jamieswhiteshirt.rtree3i.Groups;
import com.jamieswhiteshirt.rtree3i.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public final class SplitterRStar
implements Splitter {
    private final Comparator<Groups<?>> groupsComparator = Comparators.overlapListPairComparator.thenComparing(Comparators.volumePairComparator);
    private static final List<SortType> sortTypes = Collections.unmodifiableList(Arrays.asList(SortType.values()));

    @Override
    public <T> Groups<T> split(List<T> items, int minSize, Function<T, Box> boxAccessor) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        EnumMap<SortType, List<Groups<T>>> map = new EnumMap<SortType, List<Groups<T>>>(SortType.class);
        for (SortType sortType : SortType.values()) {
            ToIntFunction<Object> accessor = item -> sortType.keyAccessor.applyAsInt((Box)boxAccessor.apply(item));
            Comparator<Object> comparator = Comparator.comparingInt(accessor);
            map.put(sortType, SplitterRStar.createPairs(minSize, SplitterRStar.sort(items, comparator), boxAccessor));
        }
        SortType leastMarginSumSortType = Collections.min(sortTypes, SplitterRStar.marginSumComparator(map));
        List pairs = (List)map.get((Object)leastMarginSumSortType);
        return Collections.min(pairs, this.groupsComparator);
    }

    private static <T> Comparator<SortType> marginSumComparator(Map<SortType, List<Groups<T>>> map) {
        return Comparator.comparing(sortType -> SplitterRStar.marginValueSum((List)map.get(sortType)));
    }

    private static <T> int marginValueSum(List<Groups<T>> list) {
        int sum = 0;
        for (Groups<T> p : list) {
            sum += p.getMarginSum();
        }
        return sum;
    }

    static <T> List<Groups<T>> createPairs(int minSize, List<T> list, Function<T, Box> key) {
        ArrayList<Groups<T>> pairs = new ArrayList<Groups<T>>(list.size() - 2 * minSize + 1);
        for (int i = minSize; i < list.size() - minSize + 1; ++i) {
            List<T> list1 = list.subList(0, i);
            List<T> list2 = list.subList(i, list.size());
            Groups<T> pair = new Groups<T>(Group.of(list1, key), Group.of(list2, key));
            pairs.add(pair);
        }
        return pairs;
    }

    private static <T> List<T> sort(List<T> items, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(items);
        list.sort(comparator);
        return list;
    }

    private static enum SortType {
        X1(Box::x1),
        X2(Box::x2),
        Y1(Box::y1),
        Y2(Box::y2),
        Z1(Box::z1),
        Z2(Box::z2);

        final ToIntFunction<Box> keyAccessor;

        private SortType(ToIntFunction<Box> keyAccessor) {
            this.keyAccessor = keyAccessor;
        }
    }
}

