/*
 * Decompiled with CFR 0.152.
 */
package com.jamieswhiteshirt.rtree3i;

import com.google.common.base.Preconditions;
import com.jamieswhiteshirt.rtree3i.Box;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class Util {
    private Util() {
    }

    static Box mbb(Collection<Box> items) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        int minX1 = Integer.MAX_VALUE;
        int minY1 = Integer.MAX_VALUE;
        int minZ1 = Integer.MAX_VALUE;
        int maxX2 = -2147483647;
        int maxY2 = -2147483647;
        int maxZ2 = -2147483647;
        for (Box r : items) {
            if (r.x1() < minX1) {
                minX1 = r.x1();
            }
            if (r.y1() < minY1) {
                minY1 = r.y1();
            }
            if (r.z1() < minZ1) {
                minZ1 = r.z1();
            }
            if (r.x2() > maxX2) {
                maxX2 = r.x2();
            }
            if (r.y2() > maxY2) {
                maxY2 = r.y2();
            }
            if (r.z2() <= maxZ2) continue;
            maxZ2 = r.z2();
        }
        return Box.create(minX1, minY1, minZ1, maxX2, maxY2, maxZ2);
    }

    static <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.addAll(list);
        result.add(element);
        return result;
    }

    static <T> List<T> remove(List<? extends T> list, List<? extends T> elements) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(elements);
        return result;
    }

    static <T> List<T> remove(List<? extends T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return result;
    }

    static <T> List<T> replace(List<? extends T> list, T toReplace, T replacement) {
        ArrayList<T> list2 = new ArrayList<T>(list.size());
        for (T element : list) {
            list2.add(element != toReplace ? element : replacement);
        }
        return list2;
    }

    static <T> List<T> replace(List<T> list, T toReplace, List<T> replacements) {
        ArrayList<T> list2 = new ArrayList<T>(list.size() - 1 + replacements.size());
        for (T node : list) {
            if (node == toReplace) continue;
            list2.add(node);
        }
        list2.addAll(replacements);
        return list2;
    }
}

