/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.prospector.modmenu.gui.ModEntryWidget;
import io.github.prospector.modmenu.gui.ModListGui;
import io.github.prospector.modmenu.util.RenderUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.ModInfo;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListWidget
extends class_350 {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ModContainer> modInfoList = null;
    public ModEntryWidget selected;
    public ModListGui gui;

    public ModListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, Supplier<String> searchTerm, ModListWidget list, ModListGui gui) {
        super(client, width, height, y1, y2, entryHeight);
        if (list != null) {
            this.modInfoList = list.modInfoList;
        }
        this.selected = null;
        this.searchFilter(searchTerm, false);
        this.gui = gui;
    }

    public void method_1930(int i, int i1, float v) {
        super.method_1930(i, i1, v);
        if (this.selected != null) {
            ModInfo info = this.selected.info;
            int x = this.field_2168 + 8;
            int y = this.field_2166;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_2164.method_1531().method_4618(this.selected.nativeImageBackedTexture != null ? this.selected.iconLocation : ModEntryWidget.unknownIcon);
            GlStateManager.enableBlend();
            class_332.method_1781((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            GlStateManager.disableBlend();
            int lineSpacing = this.field_2164.field_1772.field_2000 + 1;
            int imageOffset = 36;
            this.field_2164.field_1772.method_1729(info.getName(), (float)(x + imageOffset), (float)y, 0xFFFFFF);
            this.field_2164.field_1772.method_1729(" (ID: " + info.getId() + ")", (float)(x + imageOffset + this.field_2164.field_1772.method_1727(info.getName())), (float)y, 0xAAAAAA);
            this.field_2164.field_1772.method_1729("v" + info.getVersionString(), (float)(x + imageOffset), (float)(y + lineSpacing), 0xAAAAAA);
            if (info.getLinks().getHomepage() != null && !info.getLinks().getHomepage().isEmpty()) {
                this.field_2164.field_1772.method_1729(class_124.field_1078 + "" + class_124.field_1073 + info.getLinks().getHomepage(), (float)(x + imageOffset), (float)(y + lineSpacing * 2), 0);
            }
            y = this.field_2166 + imageOffset + 24;
            if (info.getDescription() != null && !info.getDescription().isEmpty()) {
                RenderUtils.drawWrappedString(info.getDescription(), x, y, this.gui.field_2561 - this.field_2168 - 20, 5, 0xAAAAAA);
            }
        }
    }

    public int method_1932() {
        return this.field_2168 - 8;
    }

    public void searchFilter(Supplier<String> searchTerm, boolean var2) {
        this.method_1902();
        List mods = FabricLoader.INSTANCE.getMods();
        if (this.modInfoList == null || var2) {
            this.modInfoList = new ArrayList<ModContainer>();
            this.modInfoList.addAll(mods);
            this.modInfoList.sort(Comparator.comparing(modContainer -> modContainer.getInfo().getName()));
        }
        String term = searchTerm.get().toLowerCase(Locale.ROOT);
        Iterator<ModContainer> iter = this.modInfoList.iterator();
        while (iter.hasNext()) {
            ModContainer container = iter.next();
            ModInfo info = container.getInfo();
            if (!info.getName().toLowerCase(Locale.ROOT).contains(term) && !info.getId().toLowerCase(Locale.ROOT).contains(term) && !info.getAuthors().stream().anyMatch(person -> person.getName().equalsIgnoreCase(term))) continue;
            this.method_1901(new ModEntryWidget(container, this));
        }
        return;
    }

    protected int method_1948() {
        return this.field_2168 - 6;
    }

    public int getWidth() {
        return this.field_2168;
    }

    public int getY1() {
        return this.field_2166;
    }

    public int getY2() {
        return this.field_2165;
    }
}

