/*
 * Decompiled with CFR 0.152.
 */
package com.lion328.thaifixes;

import com.lion328.thaifixes.IGlyphRenderer;
import com.lion328.thaifixes.IThaiFixesTrueTypeGlyph;
import com.lion328.thaifixes.IThaiFixesUnicodeGlyph;
import com.lion328.thaifixes.ThaiUtil;
import net.minecraft.class_382;
import net.minecraft.class_383;

public class GlyphProcessor {
    public static class_382 processGlyph(class_383 glyph, class_382 gr) {
        if (glyph instanceof IThaiFixesUnicodeGlyph) {
            return GlyphProcessor.processUnicodeTextureGlyph(glyph, gr);
        }
        if (glyph instanceof IThaiFixesTrueTypeGlyph) {
            return GlyphProcessor.processTrueTypeGlyph(glyph, gr);
        }
        return null;
    }

    private static class_382 processUnicodeTextureGlyph(class_383 glyph, class_382 originalReturnValue) {
        IThaiFixesUnicodeGlyph thaiFixesGlyph = (IThaiFixesUnicodeGlyph)glyph;
        if (!thaiFixesGlyph.getThaiFixesFlag()) {
            return null;
        }
        IGlyphRenderer converted = (IGlyphRenderer)originalReturnValue;
        boolean hangBelow = ThaiUtil.isHangingBelowThaiChar(thaiFixesGlyph.getThaiFixesCharacter());
        float posYShift = 0.0f;
        float height = 2.99f;
        if (hangBelow) {
            posYShift = 6.0f;
            height = 1.99f;
        }
        float v0 = converted.thaiFixesVMin() + posYShift / 128.0f;
        float y0 = converted.thaiFixesYMin() + posYShift;
        return new class_382(originalReturnValue.method_2026(), converted.thaiFixesUMin(), converted.thaiFixesUMax(), v0, v0 + height / 128.0f, converted.thaiFixesXMin() - thaiFixesGlyph.getRealAdvance(), converted.thaiFixesXMax() - thaiFixesGlyph.getRealAdvance(), y0, y0 + height);
    }

    private static class_382 processTrueTypeGlyph(class_383 glyph, class_382 originalReturnValue) {
        float y_offset;
        IThaiFixesTrueTypeGlyph thaiFixesGlyph = (IThaiFixesTrueTypeGlyph)glyph;
        if (!thaiFixesGlyph.getThaiFixesFlag()) {
            return null;
        }
        IGlyphRenderer converted = (IGlyphRenderer)originalReturnValue;
        float x_offset = (float)glyph.method_2031() / thaiFixesGlyph.getThaiFixesOversample() * 1.22f;
        float f = y_offset = ThaiUtil.isHangingAllAboveThaiChar(thaiFixesGlyph.getThaiFixesCharacter()) ? (float)glyph.method_2032() / thaiFixesGlyph.getThaiFixesOversample() : 0.0f;
        if (thaiFixesGlyph.getThaiFixesCharacter() == '\u0e33') {
            x_offset = (float)glyph.method_2031() * 0.1f;
        }
        return new class_382(originalReturnValue.method_2026(), converted.thaiFixesUMin(), converted.thaiFixesUMax(), converted.thaiFixesVMin(), converted.thaiFixesVMax(), converted.thaiFixesXMin() + x_offset, converted.thaiFixesXMax() + x_offset, converted.thaiFixesYMin() - y_offset, converted.thaiFixesYMax() - y_offset);
    }
}

