/*
 * Decompiled with CFR 0.152.
 */
package com.lion328.thaifixes;

public class ThaiUtil {
    public static final char THAI_CHAR_RANGE_MIN = '\u0e01';
    public static final char THAI_CHAR_RANGE_MAX = '\u0e5b';
    public static final String LOWER_CHARS = "\u0e38\u0e39\u0e3a";
    public static final String SPECIAL_UPPER_CHARS = "\u0e48\u0e49\u0e4a\u0e4b";
    public static final String UPPER_CHARS = "\u0e31\u0e34\u0e35\u0e36\u0e37\u0e47\u0e4c\u0e4d\u0e4e\u0e48\u0e49\u0e4a\u0e4b";
    public static final String LONG_TAIL_CHARS = "\u0e1b\u0e1f\u0e1d\u0e2c";
    public static final char SARA_UM = '\u0e33';

    public static boolean isThaiChar(char c) {
        return c >= '\u0e01' && c <= '\u0e5b';
    }

    public static boolean isHangingThaiChar(char c) {
        return ThaiUtil.isHangingAboveThaiChar(c) || ThaiUtil.isHangingBelowThaiChar(c);
    }

    public static boolean isHangingAboveThaiChar(char c) {
        return UPPER_CHARS.indexOf(c) != -1;
    }

    public static boolean isHangingBelowThaiChar(char c) {
        return LOWER_CHARS.indexOf(c) != -1;
    }

    public static boolean isHangingAllAboveThaiChar(char c) {
        return SPECIAL_UPPER_CHARS.indexOf(c) != -1;
    }

    public static boolean isVeryLongTailThaiChar(char c) {
        return LONG_TAIL_CHARS.indexOf(c) != -1;
    }

    public static boolean isEligibleForTrueTypeCorrection(char c) {
        return ThaiUtil.isHangingThaiChar(c) || c == '\u0e33';
    }
}

