/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_3677;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;
import oshi.SystemInfo;
import oshi.hardware.Processor;

public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean isNvidia;
    public static boolean isAmd;
    public static int GL_FRAMEBUFFER;
    public static int GL_RENDERBUFFER;
    public static int GL_COLOR_ATTACHMENT0;
    public static int GL_DEPTH_ATTACHMENT;
    public static int GL_FRAMEBUFFER_COMPLETE;
    public static int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT;
    public static int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT;
    public static int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER;
    public static int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER;
    private static class_1010 fboMode;
    public static final boolean useFbo = true;
    private static boolean hasShaders;
    private static boolean useShaderArb;
    public static int GL_LINK_STATUS;
    public static int GL_COMPILE_STATUS;
    public static int GL_VERTEX_SHADER;
    public static int GL_FRAGMENT_SHADER;
    private static boolean useMultitextureArb;
    public static int GL_TEXTURE0;
    public static int GL_TEXTURE1;
    public static int GL_TEXTURE2;
    private static boolean useTexEnvCombineArb;
    public static int GL_COMBINE;
    public static int GL_INTERPOLATE;
    public static int GL_PRIMARY_COLOR;
    public static int GL_CONSTANT;
    public static int GL_PREVIOUS;
    public static int GL_COMBINE_RGB;
    public static int GL_SOURCE0_RGB;
    public static int GL_SOURCE1_RGB;
    public static int GL_SOURCE2_RGB;
    public static int GL_OPERAND0_RGB;
    public static int GL_OPERAND1_RGB;
    public static int GL_OPERAND2_RGB;
    public static int GL_COMBINE_ALPHA;
    public static int GL_SOURCE0_ALPHA;
    public static int GL_SOURCE1_ALPHA;
    public static int GL_SOURCE2_ALPHA;
    public static int GL_OPERAND0_ALPHA;
    public static int GL_OPERAND1_ALPHA;
    public static int GL_OPERAND2_ALPHA;
    private static boolean separateBlend;
    public static boolean useSeparateBlendExt;
    public static boolean isOpenGl21;
    public static boolean usePostProcess;
    private static String capsString;
    private static String cpuInfo;
    public static final boolean useVbo = true;
    public static boolean needVbo;
    private static boolean useVboArb;
    public static int GL_ARRAY_BUFFER;
    public static int GL_STATIC_DRAW;
    private static final Map<Integer, String> LOOKUP_MAP;

    public static void populateSnooperWithOpenGL(class_3677 class_36772) {
        class_36772.setFixedData("opengl_version", GlStateManager.getString(7938));
        class_36772.setFixedData("opengl_vendor", GlStateManager.getString(7936));
        GLCapabilities gLCapabilities = GL.getCapabilities();
        class_36772.setFixedData("gl_caps[ARB_arrays_of_arrays]", gLCapabilities.GL_ARB_arrays_of_arrays);
        class_36772.setFixedData("gl_caps[ARB_base_instance]", gLCapabilities.GL_ARB_base_instance);
        class_36772.setFixedData("gl_caps[ARB_blend_func_extended]", gLCapabilities.GL_ARB_blend_func_extended);
        class_36772.setFixedData("gl_caps[ARB_clear_buffer_object]", gLCapabilities.GL_ARB_clear_buffer_object);
        class_36772.setFixedData("gl_caps[ARB_color_buffer_float]", gLCapabilities.GL_ARB_color_buffer_float);
        class_36772.setFixedData("gl_caps[ARB_compatibility]", gLCapabilities.GL_ARB_compatibility);
        class_36772.setFixedData("gl_caps[ARB_compressed_texture_pixel_storage]", gLCapabilities.GL_ARB_compressed_texture_pixel_storage);
        class_36772.setFixedData("gl_caps[ARB_compute_shader]", gLCapabilities.GL_ARB_compute_shader);
        class_36772.setFixedData("gl_caps[ARB_copy_buffer]", gLCapabilities.GL_ARB_copy_buffer);
        class_36772.setFixedData("gl_caps[ARB_copy_image]", gLCapabilities.GL_ARB_copy_image);
        class_36772.setFixedData("gl_caps[ARB_depth_buffer_float]", gLCapabilities.GL_ARB_depth_buffer_float);
        class_36772.setFixedData("gl_caps[ARB_compute_shader]", gLCapabilities.GL_ARB_compute_shader);
        class_36772.setFixedData("gl_caps[ARB_copy_buffer]", gLCapabilities.GL_ARB_copy_buffer);
        class_36772.setFixedData("gl_caps[ARB_copy_image]", gLCapabilities.GL_ARB_copy_image);
        class_36772.setFixedData("gl_caps[ARB_depth_buffer_float]", gLCapabilities.GL_ARB_depth_buffer_float);
        class_36772.setFixedData("gl_caps[ARB_depth_clamp]", gLCapabilities.GL_ARB_depth_clamp);
        class_36772.setFixedData("gl_caps[ARB_depth_texture]", gLCapabilities.GL_ARB_depth_texture);
        class_36772.setFixedData("gl_caps[ARB_draw_buffers]", gLCapabilities.GL_ARB_draw_buffers);
        class_36772.setFixedData("gl_caps[ARB_draw_buffers_blend]", gLCapabilities.GL_ARB_draw_buffers_blend);
        class_36772.setFixedData("gl_caps[ARB_draw_elements_base_vertex]", gLCapabilities.GL_ARB_draw_elements_base_vertex);
        class_36772.setFixedData("gl_caps[ARB_draw_indirect]", gLCapabilities.GL_ARB_draw_indirect);
        class_36772.setFixedData("gl_caps[ARB_draw_instanced]", gLCapabilities.GL_ARB_draw_instanced);
        class_36772.setFixedData("gl_caps[ARB_explicit_attrib_location]", gLCapabilities.GL_ARB_explicit_attrib_location);
        class_36772.setFixedData("gl_caps[ARB_explicit_uniform_location]", gLCapabilities.GL_ARB_explicit_uniform_location);
        class_36772.setFixedData("gl_caps[ARB_fragment_layer_viewport]", gLCapabilities.GL_ARB_fragment_layer_viewport);
        class_36772.setFixedData("gl_caps[ARB_fragment_program]", gLCapabilities.GL_ARB_fragment_program);
        class_36772.setFixedData("gl_caps[ARB_fragment_shader]", gLCapabilities.GL_ARB_fragment_shader);
        class_36772.setFixedData("gl_caps[ARB_fragment_program_shadow]", gLCapabilities.GL_ARB_fragment_program_shadow);
        class_36772.setFixedData("gl_caps[ARB_framebuffer_object]", gLCapabilities.GL_ARB_framebuffer_object);
        class_36772.setFixedData("gl_caps[ARB_framebuffer_sRGB]", gLCapabilities.GL_ARB_framebuffer_sRGB);
        class_36772.setFixedData("gl_caps[ARB_geometry_shader4]", gLCapabilities.GL_ARB_geometry_shader4);
        class_36772.setFixedData("gl_caps[ARB_gpu_shader5]", gLCapabilities.GL_ARB_gpu_shader5);
        class_36772.setFixedData("gl_caps[ARB_half_float_pixel]", gLCapabilities.GL_ARB_half_float_pixel);
        class_36772.setFixedData("gl_caps[ARB_half_float_vertex]", gLCapabilities.GL_ARB_half_float_vertex);
        class_36772.setFixedData("gl_caps[ARB_instanced_arrays]", gLCapabilities.GL_ARB_instanced_arrays);
        class_36772.setFixedData("gl_caps[ARB_map_buffer_alignment]", gLCapabilities.GL_ARB_map_buffer_alignment);
        class_36772.setFixedData("gl_caps[ARB_map_buffer_range]", gLCapabilities.GL_ARB_map_buffer_range);
        class_36772.setFixedData("gl_caps[ARB_multisample]", gLCapabilities.GL_ARB_multisample);
        class_36772.setFixedData("gl_caps[ARB_multitexture]", gLCapabilities.GL_ARB_multitexture);
        class_36772.setFixedData("gl_caps[ARB_occlusion_query2]", gLCapabilities.GL_ARB_occlusion_query2);
        class_36772.setFixedData("gl_caps[ARB_pixel_buffer_object]", gLCapabilities.GL_ARB_pixel_buffer_object);
        class_36772.setFixedData("gl_caps[ARB_seamless_cube_map]", gLCapabilities.GL_ARB_seamless_cube_map);
        class_36772.setFixedData("gl_caps[ARB_shader_objects]", gLCapabilities.GL_ARB_shader_objects);
        class_36772.setFixedData("gl_caps[ARB_shader_stencil_export]", gLCapabilities.GL_ARB_shader_stencil_export);
        class_36772.setFixedData("gl_caps[ARB_shader_texture_lod]", gLCapabilities.GL_ARB_shader_texture_lod);
        class_36772.setFixedData("gl_caps[ARB_shadow]", gLCapabilities.GL_ARB_shadow);
        class_36772.setFixedData("gl_caps[ARB_shadow_ambient]", gLCapabilities.GL_ARB_shadow_ambient);
        class_36772.setFixedData("gl_caps[ARB_stencil_texturing]", gLCapabilities.GL_ARB_stencil_texturing);
        class_36772.setFixedData("gl_caps[ARB_sync]", gLCapabilities.GL_ARB_sync);
        class_36772.setFixedData("gl_caps[ARB_tessellation_shader]", gLCapabilities.GL_ARB_tessellation_shader);
        class_36772.setFixedData("gl_caps[ARB_texture_border_clamp]", gLCapabilities.GL_ARB_texture_border_clamp);
        class_36772.setFixedData("gl_caps[ARB_texture_buffer_object]", gLCapabilities.GL_ARB_texture_buffer_object);
        class_36772.setFixedData("gl_caps[ARB_texture_cube_map]", gLCapabilities.GL_ARB_texture_cube_map);
        class_36772.setFixedData("gl_caps[ARB_texture_cube_map_array]", gLCapabilities.GL_ARB_texture_cube_map_array);
        class_36772.setFixedData("gl_caps[ARB_texture_non_power_of_two]", gLCapabilities.GL_ARB_texture_non_power_of_two);
        class_36772.setFixedData("gl_caps[ARB_uniform_buffer_object]", gLCapabilities.GL_ARB_uniform_buffer_object);
        class_36772.setFixedData("gl_caps[ARB_vertex_blend]", gLCapabilities.GL_ARB_vertex_blend);
        class_36772.setFixedData("gl_caps[ARB_vertex_buffer_object]", gLCapabilities.GL_ARB_vertex_buffer_object);
        class_36772.setFixedData("gl_caps[ARB_vertex_program]", gLCapabilities.GL_ARB_vertex_program);
        class_36772.setFixedData("gl_caps[ARB_vertex_shader]", gLCapabilities.GL_ARB_vertex_shader);
        class_36772.setFixedData("gl_caps[EXT_bindable_uniform]", gLCapabilities.GL_EXT_bindable_uniform);
        class_36772.setFixedData("gl_caps[EXT_blend_equation_separate]", gLCapabilities.GL_EXT_blend_equation_separate);
        class_36772.setFixedData("gl_caps[EXT_blend_func_separate]", gLCapabilities.GL_EXT_blend_func_separate);
        class_36772.setFixedData("gl_caps[EXT_blend_minmax]", gLCapabilities.GL_EXT_blend_minmax);
        class_36772.setFixedData("gl_caps[EXT_blend_subtract]", gLCapabilities.GL_EXT_blend_subtract);
        class_36772.setFixedData("gl_caps[EXT_draw_instanced]", gLCapabilities.GL_EXT_draw_instanced);
        class_36772.setFixedData("gl_caps[EXT_framebuffer_multisample]", gLCapabilities.GL_EXT_framebuffer_multisample);
        class_36772.setFixedData("gl_caps[EXT_framebuffer_object]", gLCapabilities.GL_EXT_framebuffer_object);
        class_36772.setFixedData("gl_caps[EXT_framebuffer_sRGB]", gLCapabilities.GL_EXT_framebuffer_sRGB);
        class_36772.setFixedData("gl_caps[EXT_geometry_shader4]", gLCapabilities.GL_EXT_geometry_shader4);
        class_36772.setFixedData("gl_caps[EXT_gpu_program_parameters]", gLCapabilities.GL_EXT_gpu_program_parameters);
        class_36772.setFixedData("gl_caps[EXT_gpu_shader4]", gLCapabilities.GL_EXT_gpu_shader4);
        class_36772.setFixedData("gl_caps[EXT_packed_depth_stencil]", gLCapabilities.GL_EXT_packed_depth_stencil);
        class_36772.setFixedData("gl_caps[EXT_separate_shader_objects]", gLCapabilities.GL_EXT_separate_shader_objects);
        class_36772.setFixedData("gl_caps[EXT_shader_image_load_store]", gLCapabilities.GL_EXT_shader_image_load_store);
        class_36772.setFixedData("gl_caps[EXT_shadow_funcs]", gLCapabilities.GL_EXT_shadow_funcs);
        class_36772.setFixedData("gl_caps[EXT_shared_texture_palette]", gLCapabilities.GL_EXT_shared_texture_palette);
        class_36772.setFixedData("gl_caps[EXT_stencil_clear_tag]", gLCapabilities.GL_EXT_stencil_clear_tag);
        class_36772.setFixedData("gl_caps[EXT_stencil_two_side]", gLCapabilities.GL_EXT_stencil_two_side);
        class_36772.setFixedData("gl_caps[EXT_stencil_wrap]", gLCapabilities.GL_EXT_stencil_wrap);
        class_36772.setFixedData("gl_caps[EXT_texture_array]", gLCapabilities.GL_EXT_texture_array);
        class_36772.setFixedData("gl_caps[EXT_texture_buffer_object]", gLCapabilities.GL_EXT_texture_buffer_object);
        class_36772.setFixedData("gl_caps[EXT_texture_integer]", gLCapabilities.GL_EXT_texture_integer);
        class_36772.setFixedData("gl_caps[EXT_texture_sRGB]", gLCapabilities.GL_EXT_texture_sRGB);
        class_36772.setFixedData("gl_caps[ARB_vertex_shader]", gLCapabilities.GL_ARB_vertex_shader);
        class_36772.setFixedData("gl_caps[gl_max_vertex_uniforms]", GlStateManager.getInteger(35658));
        GlStateManager.getError();
        class_36772.setFixedData("gl_caps[gl_max_fragment_uniforms]", GlStateManager.getInteger(35657));
        GlStateManager.getError();
        class_36772.setFixedData("gl_caps[gl_max_vertex_attribs]", GlStateManager.getInteger(34921));
        GlStateManager.getError();
        class_36772.setFixedData("gl_caps[gl_max_vertex_texture_image_units]", GlStateManager.getInteger(35660));
        GlStateManager.getError();
        class_36772.setFixedData("gl_caps[gl_max_texture_image_units]", GlStateManager.getInteger(34930));
        GlStateManager.getError();
        class_36772.setFixedData("gl_caps[gl_max_array_texture_layers]", GlStateManager.getInteger(35071));
        GlStateManager.getError();
    }

    public static String getOpenGLVersionString() {
        if (GLFW.glfwGetCurrentContext() == 0L) {
            return "NO CONTEXT";
        }
        return GlStateManager.getString(7937) + " GL version " + GlStateManager.getString(7938) + ", " + GlStateManager.getString(7936);
    }

    public static int getRefreshRate(class_1041 class_10412) {
        long l = GLFW.glfwGetWindowMonitor((long)class_10412.method_4490());
        if (l == 0L) {
            l = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode \u26032 = l == 0L ? null : GLFW.glfwGetVideoMode((long)l);
        return \u26032 == null ? 0 : \u26032.refreshRate();
    }

    public static String getLWJGLVersion() {
        return Version.getVersion();
    }

    public static LongSupplier initGlfw() {
        LongSupplier longSupplier;
        class_1041.method_4492((n, string) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", n, string));
        });
        ArrayList arrayList = Lists.newArrayList();
        GLFWErrorCallback \u26032 = GLFW.glfwSetErrorCallback((n, l) -> arrayList.add(String.format("GLFW error during init: [0x%X]%s", n, l)));
        if (GLFW.glfwInit()) {
            longSupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
            for (String string2 : arrayList) {
                LOGGER.error("GLFW error collected during initialization: {}", (Object)string2);
            }
        } else {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)arrayList));
        }
        GLX.setGlfwErrorCallback((GLFWErrorCallbackI)\u26032);
        return longSupplier;
    }

    public static void setGlfwErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)gLFWErrorCallbackI).free();
    }

    public static boolean shouldClose(class_1041 class_10412) {
        return GLFW.glfwWindowShouldClose((long)class_10412.method_4490());
    }

    public static void pollEvents() {
        GLFW.glfwPollEvents();
    }

    public static String getOpenGLVersion() {
        return GlStateManager.getString(7938);
    }

    public static String getRenderer() {
        return GlStateManager.getString(7937);
    }

    public static String getVendor() {
        return GlStateManager.getString(7936);
    }

    public static void setupNvFogDistance() {
        if (GL.getCapabilities().GL_NV_fog_distance) {
            GlStateManager.fogi(34138, 34139);
        }
    }

    public static boolean supportsOpenGL2() {
        return GL.getCapabilities().OpenGL20;
    }

    public static void withTextureRestore(Runnable runnable) {
        GL11.glPushAttrib((int)270336);
        try {
            runnable.run();
        }
        finally {
            GL11.glPopAttrib();
        }
    }

    public static ByteBuffer allocateMemory(int n) {
        return MemoryUtil.memAlloc((int)n);
    }

    public static void freeMemory(Buffer buffer) {
        MemoryUtil.memFree((Buffer)buffer);
    }

    public static void init() {
        GLCapabilities gLCapabilities = GL.getCapabilities();
        useMultitextureArb = gLCapabilities.GL_ARB_multitexture && !gLCapabilities.OpenGL13;
        boolean bl = useTexEnvCombineArb = gLCapabilities.GL_ARB_texture_env_combine && !gLCapabilities.OpenGL13;
        if (useMultitextureArb) {
            capsString = capsString + "Using ARB_multitexture.\n";
            GL_TEXTURE0 = 33984;
            GL_TEXTURE1 = 33985;
            GL_TEXTURE2 = 33986;
        } else {
            capsString = capsString + "Using GL 1.3 multitexturing.\n";
            GL_TEXTURE0 = 33984;
            GL_TEXTURE1 = 33985;
            GL_TEXTURE2 = 33986;
        }
        if (useTexEnvCombineArb) {
            capsString = capsString + "Using ARB_texture_env_combine.\n";
            GL_COMBINE = 34160;
            GL_INTERPOLATE = 34165;
            GL_PRIMARY_COLOR = 34167;
            GL_CONSTANT = 34166;
            GL_PREVIOUS = 34168;
            GL_COMBINE_RGB = 34161;
            GL_SOURCE0_RGB = 34176;
            GL_SOURCE1_RGB = 34177;
            GL_SOURCE2_RGB = 34178;
            GL_OPERAND0_RGB = 34192;
            GL_OPERAND1_RGB = 34193;
            GL_OPERAND2_RGB = 34194;
            GL_COMBINE_ALPHA = 34162;
            GL_SOURCE0_ALPHA = 34184;
            GL_SOURCE1_ALPHA = 34185;
            GL_SOURCE2_ALPHA = 34186;
            GL_OPERAND0_ALPHA = 34200;
            GL_OPERAND1_ALPHA = 34201;
            GL_OPERAND2_ALPHA = 34202;
        } else {
            capsString = capsString + "Using GL 1.3 texture combiners.\n";
            GL_COMBINE = 34160;
            GL_INTERPOLATE = 34165;
            GL_PRIMARY_COLOR = 34167;
            GL_CONSTANT = 34166;
            GL_PREVIOUS = 34168;
            GL_COMBINE_RGB = 34161;
            GL_SOURCE0_RGB = 34176;
            GL_SOURCE1_RGB = 34177;
            GL_SOURCE2_RGB = 34178;
            GL_OPERAND0_RGB = 34192;
            GL_OPERAND1_RGB = 34193;
            GL_OPERAND2_RGB = 34194;
            GL_COMBINE_ALPHA = 34162;
            GL_SOURCE0_ALPHA = 34184;
            GL_SOURCE1_ALPHA = 34185;
            GL_SOURCE2_ALPHA = 34186;
            GL_OPERAND0_ALPHA = 34200;
            GL_OPERAND1_ALPHA = 34201;
            GL_OPERAND2_ALPHA = 34202;
        }
        useSeparateBlendExt = gLCapabilities.GL_EXT_blend_func_separate && !gLCapabilities.OpenGL14;
        separateBlend = gLCapabilities.OpenGL14 || gLCapabilities.GL_EXT_blend_func_separate;
        capsString = capsString + "Using framebuffer objects because ";
        if (gLCapabilities.OpenGL30) {
            capsString = capsString + "OpenGL 3.0 is supported and separate blending is supported.\n";
            fboMode = class_1010.field_4981;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_FRAMEBUFFER_COMPLETE = 36053;
            GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
            GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
            GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
            GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        } else if (gLCapabilities.GL_ARB_framebuffer_object) {
            capsString = capsString + "ARB_framebuffer_object is supported and separate blending is supported.\n";
            fboMode = class_1010.field_4983;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_FRAMEBUFFER_COMPLETE = 36053;
            GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
            GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
            GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
            GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        } else if (gLCapabilities.GL_EXT_framebuffer_object) {
            capsString = capsString + "EXT_framebuffer_object is supported.\n";
            fboMode = class_1010.field_4984;
            GL_FRAMEBUFFER = 36160;
            GL_RENDERBUFFER = 36161;
            GL_COLOR_ATTACHMENT0 = 36064;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_FRAMEBUFFER_COMPLETE = 36053;
            GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
            GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
            GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
            GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
        }
        isOpenGl21 = gLCapabilities.OpenGL21;
        hasShaders = isOpenGl21 || gLCapabilities.GL_ARB_vertex_shader && gLCapabilities.GL_ARB_fragment_shader && gLCapabilities.GL_ARB_shader_objects;
        capsString = capsString + "Shaders are " + (hasShaders ? "" : "not ") + "available because ";
        if (hasShaders) {
            if (gLCapabilities.OpenGL21) {
                capsString = capsString + "OpenGL 2.1 is supported.\n";
                useShaderArb = false;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            } else {
                capsString = capsString + "ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported.\n";
                useShaderArb = true;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            }
        } else {
            capsString = capsString + "OpenGL 2.1 is " + (gLCapabilities.OpenGL21 ? "" : "not ") + "supported, ";
            capsString = capsString + "ARB_shader_objects is " + (gLCapabilities.GL_ARB_shader_objects ? "" : "not ") + "supported, ";
            capsString = capsString + "ARB_vertex_shader is " + (gLCapabilities.GL_ARB_vertex_shader ? "" : "not ") + "supported, and ";
            capsString = capsString + "ARB_fragment_shader is " + (gLCapabilities.GL_ARB_fragment_shader ? "" : "not ") + "supported.\n";
        }
        usePostProcess = hasShaders;
        String \u26032 = GL11.glGetString((int)7936).toLowerCase(Locale.ROOT);
        isNvidia = \u26032.contains("nvidia");
        useVboArb = !gLCapabilities.OpenGL15 && gLCapabilities.GL_ARB_vertex_buffer_object;
        capsString = capsString + "VBOs are available because ";
        if (useVboArb) {
            capsString = capsString + "ARB_vertex_buffer_object is supported.\n";
            GL_STATIC_DRAW = 35044;
            GL_ARRAY_BUFFER = 34962;
        } else {
            capsString = capsString + "OpenGL 1.5 is supported.\n";
            GL_STATIC_DRAW = 35044;
            GL_ARRAY_BUFFER = 34962;
        }
        isAmd = \u26032.contains("ati");
        if (isAmd) {
            needVbo = true;
        }
        try {
            Processor[] processorArray = new SystemInfo().getHardware().getProcessors();
            cpuInfo = String.format("%dx %s", processorArray.length, processorArray[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isNextGen() {
        return usePostProcess;
    }

    public static String getCapsString() {
        return capsString;
    }

    public static int glGetProgrami(int n, int n2) {
        if (useShaderArb) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)n2);
        }
        return GL20.glGetProgrami((int)n, (int)n2);
    }

    public static void glAttachShader(int n, int n2) {
        if (useShaderArb) {
            ARBShaderObjects.glAttachObjectARB((int)n, (int)n2);
        } else {
            GL20.glAttachShader((int)n, (int)n2);
        }
    }

    public static void glDeleteShader(int n) {
        if (useShaderArb) {
            ARBShaderObjects.glDeleteObjectARB((int)n);
        } else {
            GL20.glDeleteShader((int)n);
        }
    }

    public static int glCreateShader(int n) {
        if (useShaderArb) {
            return ARBShaderObjects.glCreateShaderObjectARB((int)n);
        }
        return GL20.glCreateShader((int)n);
    }

    public static void glShaderSource(int n, CharSequence charSequence) {
        if (useShaderArb) {
            ARBShaderObjects.glShaderSourceARB((int)n, (CharSequence)charSequence);
        } else {
            GL20.glShaderSource((int)n, (CharSequence)charSequence);
        }
    }

    public static void glCompileShader(int n) {
        if (useShaderArb) {
            ARBShaderObjects.glCompileShaderARB((int)n);
        } else {
            GL20.glCompileShader((int)n);
        }
    }

    public static int glGetShaderi(int n, int n2) {
        if (useShaderArb) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)n2);
        }
        return GL20.glGetShaderi((int)n, (int)n2);
    }

    public static String glGetShaderInfoLog(int n, int n2) {
        if (useShaderArb) {
            return ARBShaderObjects.glGetInfoLogARB((int)n, (int)n2);
        }
        return GL20.glGetShaderInfoLog((int)n, (int)n2);
    }

    public static String glGetProgramInfoLog(int n, int n2) {
        if (useShaderArb) {
            return ARBShaderObjects.glGetInfoLogARB((int)n, (int)n2);
        }
        return GL20.glGetProgramInfoLog((int)n, (int)n2);
    }

    public static void glUseProgram(int n) {
        if (useShaderArb) {
            ARBShaderObjects.glUseProgramObjectARB((int)n);
        } else {
            GL20.glUseProgram((int)n);
        }
    }

    public static int glCreateProgram() {
        if (useShaderArb) {
            return ARBShaderObjects.glCreateProgramObjectARB();
        }
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int n) {
        if (useShaderArb) {
            ARBShaderObjects.glDeleteObjectARB((int)n);
        } else {
            GL20.glDeleteProgram((int)n);
        }
    }

    public static void glLinkProgram(int n) {
        if (useShaderArb) {
            ARBShaderObjects.glLinkProgramARB((int)n);
        } else {
            GL20.glLinkProgram((int)n);
        }
    }

    public static int glGetUniformLocation(int n, CharSequence charSequence) {
        if (useShaderArb) {
            return ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)charSequence);
        }
        return GL20.glGetUniformLocation((int)n, (CharSequence)charSequence);
    }

    public static void glUniform1(int n, IntBuffer intBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform1ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform1iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void glUniform1i(int n, int n2) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform1iARB((int)n, (int)n2);
        } else {
            GL20.glUniform1i((int)n, (int)n2);
        }
    }

    public static void glUniform1(int n, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform1fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform1fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void glUniform2(int n, IntBuffer intBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform2ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform2iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void glUniform2(int n, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform2fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform2fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void glUniform3(int n, IntBuffer intBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform3ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform3iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void glUniform3(int n, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform3fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform3fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void glUniform4(int n, IntBuffer intBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform4ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform4iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void glUniform4(int n, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniform4fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform4fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void glUniformMatrix2(int n, boolean bl, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniformMatrix2fvARB((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniformMatrix2fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        }
    }

    public static void glUniformMatrix3(int n, boolean bl, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniformMatrix3fvARB((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniformMatrix3fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        }
    }

    public static void glUniformMatrix4(int n, boolean bl, FloatBuffer floatBuffer) {
        if (useShaderArb) {
            ARBShaderObjects.glUniformMatrix4fvARB((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniformMatrix4fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        }
    }

    public static int glGetAttribLocation(int n, CharSequence charSequence) {
        if (useShaderArb) {
            return ARBVertexShader.glGetAttribLocationARB((int)n, (CharSequence)charSequence);
        }
        return GL20.glGetAttribLocation((int)n, (CharSequence)charSequence);
    }

    public static int glGenBuffers() {
        if (useVboArb) {
            return ARBVertexBufferObject.glGenBuffersARB();
        }
        return GL15.glGenBuffers();
    }

    public static void glGenBuffers(IntBuffer intBuffer) {
        if (useVboArb) {
            ARBVertexBufferObject.glGenBuffersARB((IntBuffer)intBuffer);
        } else {
            GL15.glGenBuffers((IntBuffer)intBuffer);
        }
    }

    public static void glBindBuffer(int n, int n2) {
        if (useVboArb) {
            ARBVertexBufferObject.glBindBufferARB((int)n, (int)n2);
        } else {
            GL15.glBindBuffer((int)n, (int)n2);
        }
    }

    public static void glBufferData(int n, ByteBuffer byteBuffer, int n2) {
        if (useVboArb) {
            ARBVertexBufferObject.glBufferDataARB((int)n, (ByteBuffer)byteBuffer, (int)n2);
        } else {
            GL15.glBufferData((int)n, (ByteBuffer)byteBuffer, (int)n2);
        }
    }

    public static void glDeleteBuffers(int n) {
        if (useVboArb) {
            ARBVertexBufferObject.glDeleteBuffersARB((int)n);
        } else {
            GL15.glDeleteBuffers((int)n);
        }
    }

    public static void glDeleteBuffers(IntBuffer intBuffer) {
        if (useVboArb) {
            ARBVertexBufferObject.glDeleteBuffersARB((IntBuffer)intBuffer);
        } else {
            GL15.glDeleteBuffers((IntBuffer)intBuffer);
        }
    }

    public static boolean useVbo() {
        return true;
    }

    public static void glBindFramebuffer(int n, int n2) {
        switch (fboMode) {
            case field_4981: {
                GL30.glBindFramebuffer((int)n, (int)n2);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glBindFramebuffer((int)n, (int)n2);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glBindFramebufferEXT((int)n, (int)n2);
            }
        }
    }

    public static void glBindRenderbuffer(int n, int n2) {
        switch (fboMode) {
            case field_4981: {
                GL30.glBindRenderbuffer((int)n, (int)n2);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glBindRenderbuffer((int)n, (int)n2);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)n, (int)n2);
            }
        }
    }

    public static void glDeleteRenderbuffers(int n) {
        switch (fboMode) {
            case field_4981: {
                GL30.glDeleteRenderbuffers((int)n);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)n);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)n);
            }
        }
    }

    public static void glDeleteFramebuffers(int n) {
        switch (fboMode) {
            case field_4981: {
                GL30.glDeleteFramebuffers((int)n);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glDeleteFramebuffers((int)n);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)n);
            }
        }
    }

    public static int glGenFramebuffers() {
        switch (fboMode) {
            case field_4981: {
                return GL30.glGenFramebuffers();
            }
            case field_4983: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case field_4984: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return -1;
    }

    public static int glGenRenderbuffers() {
        switch (fboMode) {
            case field_4981: {
                return GL30.glGenRenderbuffers();
            }
            case field_4983: {
                return ARBFramebufferObject.glGenRenderbuffers();
            }
            case field_4984: {
                return EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return -1;
    }

    public static void glRenderbufferStorage(int n, int n2, int n3, int n4) {
        switch (fboMode) {
            case field_4981: {
                GL30.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)n, (int)n2, (int)n3, (int)n4);
            }
        }
    }

    public static void glFramebufferRenderbuffer(int n, int n2, int n3, int n4) {
        switch (fboMode) {
            case field_4981: {
                GL30.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)n, (int)n2, (int)n3, (int)n4);
            }
        }
    }

    public static int glCheckFramebufferStatus(int n) {
        switch (fboMode) {
            case field_4981: {
                return GL30.glCheckFramebufferStatus((int)n);
            }
            case field_4983: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)n);
            }
            case field_4984: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)n);
            }
        }
        return -1;
    }

    public static void glFramebufferTexture2D(int n, int n2, int n3, int n4, int n5) {
        switch (fboMode) {
            case field_4981: {
                GL30.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
                break;
            }
            case field_4983: {
                ARBFramebufferObject.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
                break;
            }
            case field_4984: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
            }
        }
    }

    public static int getBoundFramebuffer() {
        switch (fboMode) {
            case field_4981: {
                return GlStateManager.getInteger(36006);
            }
            case field_4983: {
                return GlStateManager.getInteger(36006);
            }
            case field_4984: {
                return GlStateManager.getInteger(36006);
            }
        }
        return 0;
    }

    public static void glActiveTexture(int n) {
        if (useMultitextureArb) {
            ARBMultitexture.glActiveTextureARB((int)n);
        } else {
            GL13.glActiveTexture((int)n);
        }
    }

    public static void glClientActiveTexture(int n) {
        if (useMultitextureArb) {
            ARBMultitexture.glClientActiveTextureARB((int)n);
        } else {
            GL13.glClientActiveTexture((int)n);
        }
    }

    public static void glMultiTexCoord2f(int n, float f, float f2) {
        if (useMultitextureArb) {
            ARBMultitexture.glMultiTexCoord2fARB((int)n, (float)f, (float)f2);
        } else {
            GL13.glMultiTexCoord2f((int)n, (float)f, (float)f2);
        }
    }

    public static void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        if (separateBlend) {
            if (useSeparateBlendExt) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)n, (int)n2, (int)n3, (int)n4);
            } else {
                GL14.glBlendFuncSeparate((int)n, (int)n2, (int)n3, (int)n4);
            }
        } else {
            GL11.glBlendFunc((int)n, (int)n2);
        }
    }

    public static boolean isUsingFBOs() {
        return true;
    }

    public static String getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void renderCrosshair(int n) {
        GLX.renderCrosshair(n, true, true, true);
    }

    public static void renderCrosshair(int n, boolean bl, boolean bl2, boolean bl3) {
        GlStateManager.disableTexture();
        GlStateManager.depthMask(false);
        class_289 class_28910 = class_289.method_1348();
        class_287 \u26032 = class_28910.method_1349();
        GL11.glLineWidth((float)4.0f);
        \u26032.method_1328(1, class_290.field_1576);
        if (bl) {
            \u26032.method_1315(0.0, 0.0, 0.0).method_1323(0, 0, 0, 255).method_1344();
            \u26032.method_1315(n, 0.0, 0.0).method_1323(0, 0, 0, 255).method_1344();
        }
        if (bl2) {
            \u26032.method_1315(0.0, 0.0, 0.0).method_1323(0, 0, 0, 255).method_1344();
            \u26032.method_1315(0.0, n, 0.0).method_1323(0, 0, 0, 255).method_1344();
        }
        if (bl3) {
            \u26032.method_1315(0.0, 0.0, 0.0).method_1323(0, 0, 0, 255).method_1344();
            \u26032.method_1315(0.0, 0.0, n).method_1323(0, 0, 0, 255).method_1344();
        }
        class_28910.method_1350();
        GL11.glLineWidth((float)2.0f);
        \u26032.method_1328(1, class_290.field_1576);
        if (bl) {
            \u26032.method_1315(0.0, 0.0, 0.0).method_1323(255, 0, 0, 255).method_1344();
            \u26032.method_1315(n, 0.0, 0.0).method_1323(255, 0, 0, 255).method_1344();
        }
        if (bl2) {
            \u26032.method_1315(0.0, 0.0, 0.0).method_1323(0, 255, 0, 255).method_1344();
            \u26032.method_1315(0.0, n, 0.0).method_1323(0, 255, 0, 255).method_1344();
        }
        if (bl3) {
            \u26032.method_1315(0.0, 0.0, 0.0).method_1323(127, 127, 255, 255).method_1344();
            \u26032.method_1315(0.0, 0.0, n).method_1323(127, 127, 255, 255).method_1344();
        }
        class_28910.method_1350();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.depthMask(true);
        GlStateManager.enableTexture();
    }

    public static String getErrorString(int n) {
        return LOOKUP_MAP.get(n);
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    static {
        capsString = "";
        LOOKUP_MAP = GLX.make(Maps.newHashMap(), hashMap -> {
            hashMap.put(0, "No error");
            hashMap.put(1280, "Enum parameter is invalid for this function");
            hashMap.put(1281, "Parameter is invalid for this function");
            hashMap.put(1282, "Current state is invalid for this function");
            hashMap.put(1283, "Stack overflow");
            hashMap.put(1284, "Stack underflow");
            hashMap.put(1285, "Out of memory");
            hashMap.put(1286, "Operation on incomplete framebuffer");
            hashMap.put(1286, "Operation on incomplete framebuffer");
        });
    }

    static enum class_1010 {
        field_4981,
        field_4983,
        field_4984;

    }
}

