/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.GLX;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_301;
import net.minecraft.class_308;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.system.MemoryUtil;

public class GlStateManager {
    private static final int LIGHT_COUNT = 8;
    private static final int TEXTURE_COUNT = 8;
    private static final FloatBuffer MATRIX_BUFFER = GLX.make(MemoryUtil.memAllocFloat((int)16), floatBuffer -> class_301.method_1407(MemoryUtil.memAddress((FloatBuffer)floatBuffer)));
    private static final FloatBuffer COLOR_BUFFER = GLX.make(MemoryUtil.memAllocFloat((int)4), floatBuffer -> class_301.method_1407(MemoryUtil.memAddress((FloatBuffer)floatBuffer)));
    private static final class_1016 ALPHA_TEST = new class_1016();
    private static final class_1018 LIGHTING = new class_1018(2896);
    private static final class_1018[] LIGHT_ENABLE = (class_1018[])IntStream.range(0, 8).mapToObj(n -> new class_1018(16384 + n)).toArray(class_1018[]::new);
    private static final class_1023 COLOR_MATERIAL = new class_1023();
    private static final class_1017 BLEND = new class_1017();
    private static final class_1026 DEPTH = new class_1026();
    private static final class_1029 FOG = new class_1029();
    private static final class_1025 CULL = new class_1025();
    private static final class_1031 POLY_OFFSET = new class_1031();
    private static final class_1021 COLOR_LOGIC = new class_1021();
    private static final class_1038 TEX_GEN = new class_1038();
    private static final class_1019 CLEAR = new class_1019();
    private static final class_1035 STENCIL = new class_1035();
    private static final class_1018 NORMALIZE = new class_1018(2977);
    private static int activeTexture;
    private static final class_1039[] TEXTURES;
    private static int shadeModel;
    private static final class_1018 RESCALE_NORMAL;
    private static final class_1022 COLOR_MASK;
    private static final class_1020 COLOR;
    private static final float DEFAULTALPHACUTOFF = 0.1f;

    public static void pushLightingAttributes() {
        GL11.glPushAttrib((int)8256);
    }

    public static void pushTextureAttributes() {
        GL11.glPushAttrib((int)270336);
    }

    public static void popAttributes() {
        GL11.glPopAttrib();
    }

    public static void disableAlphaTest() {
        GlStateManager.ALPHA_TEST.field_5042.method_4469();
    }

    public static void enableAlphaTest() {
        GlStateManager.ALPHA_TEST.field_5042.method_4471();
    }

    public static void alphaFunc(int n, float f) {
        if (n != GlStateManager.ALPHA_TEST.field_5044 || f != GlStateManager.ALPHA_TEST.field_5043) {
            GlStateManager.ALPHA_TEST.field_5044 = n;
            GlStateManager.ALPHA_TEST.field_5043 = f;
            GL11.glAlphaFunc((int)n, (float)f);
        }
    }

    public static void enableLighting() {
        LIGHTING.method_4471();
    }

    public static void disableLighting() {
        LIGHTING.method_4469();
    }

    public static void enableLight(int n) {
        LIGHT_ENABLE[n].method_4471();
    }

    public static void disableLight(int n) {
        LIGHT_ENABLE[n].method_4469();
    }

    public static void enableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.field_5064.method_4471();
    }

    public static void disableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.field_5064.method_4469();
    }

    public static void colorMaterial(int n, int n2) {
        if (n != GlStateManager.COLOR_MATERIAL.field_5066 || n2 != GlStateManager.COLOR_MATERIAL.field_5065) {
            GlStateManager.COLOR_MATERIAL.field_5066 = n;
            GlStateManager.COLOR_MATERIAL.field_5065 = n2;
            GL11.glColorMaterial((int)n, (int)n2);
        }
    }

    public static void light(int n, int n2, FloatBuffer floatBuffer) {
        GL11.glLightfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public static void lightModel(int n, FloatBuffer floatBuffer) {
        GL11.glLightModelfv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void normal3f(float f, float f2, float f3) {
        GL11.glNormal3f((float)f, (float)f2, (float)f3);
    }

    public static void disableDepthTest() {
        GlStateManager.DEPTH.field_5074.method_4469();
    }

    public static void enableDepthTest() {
        GlStateManager.DEPTH.field_5074.method_4471();
    }

    public static void depthFunc(int n) {
        if (n != GlStateManager.DEPTH.field_5075) {
            GlStateManager.DEPTH.field_5075 = n;
            GL11.glDepthFunc((int)n);
        }
    }

    public static void depthMask(boolean bl) {
        if (bl != GlStateManager.DEPTH.field_5076) {
            GlStateManager.DEPTH.field_5076 = bl;
            GL11.glDepthMask((boolean)bl);
        }
    }

    public static void disableBlend() {
        GlStateManager.BLEND.field_5045.method_4469();
    }

    public static void enableBlend() {
        GlStateManager.BLEND.field_5045.method_4471();
    }

    public static void blendFunc(SourceFactor sourceFactor, DestFactor destFactor) {
        GlStateManager.blendFunc(sourceFactor.value, destFactor.value);
    }

    public static void blendFunc(int n, int n2) {
        if (n != GlStateManager.BLEND.field_5049 || n2 != GlStateManager.BLEND.field_5048) {
            GlStateManager.BLEND.field_5049 = n;
            GlStateManager.BLEND.field_5048 = n2;
            GL11.glBlendFunc((int)n, (int)n2);
        }
    }

    public static void blendFuncSeparate(SourceFactor sourceFactor, DestFactor destFactor, SourceFactor sourceFactor2, DestFactor destFactor2) {
        GlStateManager.blendFuncSeparate(sourceFactor.value, destFactor.value, sourceFactor2.value, destFactor2.value);
    }

    public static void blendFuncSeparate(int n, int n2, int n3, int n4) {
        if (n != GlStateManager.BLEND.field_5049 || n2 != GlStateManager.BLEND.field_5048 || n3 != GlStateManager.BLEND.field_5047 || n4 != GlStateManager.BLEND.field_5046) {
            GlStateManager.BLEND.field_5049 = n;
            GlStateManager.BLEND.field_5048 = n2;
            GlStateManager.BLEND.field_5047 = n3;
            GlStateManager.BLEND.field_5046 = n4;
            GLX.glBlendFuncSeparate(n, n2, n3, n4);
        }
    }

    public static void blendEquation(int n) {
        GL14.glBlendEquation((int)n);
    }

    public static void setupSolidRenderingTextureCombine(int n) {
        COLOR_BUFFER.put(0, (float)(n >> 16 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(1, (float)(n >> 8 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(2, (float)(n >> 0 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(3, (float)(n >> 24 & 0xFF) / 255.0f);
        GlStateManager.texEnv(8960, 8705, COLOR_BUFFER);
        GlStateManager.texEnv(8960, 8704, 34160);
        GlStateManager.texEnv(8960, 34161, 7681);
        GlStateManager.texEnv(8960, 34176, 34166);
        GlStateManager.texEnv(8960, 34192, 768);
        GlStateManager.texEnv(8960, 34162, 7681);
        GlStateManager.texEnv(8960, 34184, 5890);
        GlStateManager.texEnv(8960, 34200, 770);
    }

    public static void tearDownSolidRenderingTextureCombine() {
        GlStateManager.texEnv(8960, 8704, 8448);
        GlStateManager.texEnv(8960, 34161, 8448);
        GlStateManager.texEnv(8960, 34162, 8448);
        GlStateManager.texEnv(8960, 34176, 5890);
        GlStateManager.texEnv(8960, 34184, 5890);
        GlStateManager.texEnv(8960, 34192, 768);
        GlStateManager.texEnv(8960, 34200, 770);
    }

    public static void enableFog() {
        GlStateManager.FOG.field_5100.method_4471();
    }

    public static void disableFog() {
        GlStateManager.FOG.field_5100.method_4469();
    }

    public static void fogMode(class_1028 class_10282) {
        GlStateManager.fogMode(class_10282.field_5093);
    }

    private static void fogMode(int n) {
        if (n != GlStateManager.FOG.field_5102) {
            GlStateManager.FOG.field_5102 = n;
            GL11.glFogi((int)2917, (int)n);
        }
    }

    public static void fogDensity(float f) {
        if (f != GlStateManager.FOG.field_5101) {
            GlStateManager.FOG.field_5101 = f;
            GL11.glFogf((int)2914, (float)f);
        }
    }

    public static void fogStart(float f) {
        if (f != GlStateManager.FOG.field_5099) {
            GlStateManager.FOG.field_5099 = f;
            GL11.glFogf((int)2915, (float)f);
        }
    }

    public static void fogEnd(float f) {
        if (f != GlStateManager.FOG.field_5098) {
            GlStateManager.FOG.field_5098 = f;
            GL11.glFogf((int)2916, (float)f);
        }
    }

    public static void fog(int n, FloatBuffer floatBuffer) {
        GL11.glFogfv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void fogi(int n, int n2) {
        GL11.glFogi((int)n, (int)n2);
    }

    public static void enableCull() {
        GlStateManager.CULL.field_5072.method_4471();
    }

    public static void disableCull() {
        GlStateManager.CULL.field_5072.method_4469();
    }

    public static void cullFace(class_1024 class_10242) {
        GlStateManager.cullFace(class_10242.field_5069);
    }

    private static void cullFace(int n) {
        if (n != GlStateManager.CULL.field_5073) {
            GlStateManager.CULL.field_5073 = n;
            GL11.glCullFace((int)n);
        }
    }

    public static void polygonMode(int n, int n2) {
        GL11.glPolygonMode((int)n, (int)n2);
    }

    public static void enablePolygonOffset() {
        GlStateManager.POLY_OFFSET.field_5123.method_4471();
    }

    public static void disablePolygonOffset() {
        GlStateManager.POLY_OFFSET.field_5123.method_4469();
    }

    public static void enableLineOffset() {
        GlStateManager.POLY_OFFSET.field_5121.method_4471();
    }

    public static void disableLineOffset() {
        GlStateManager.POLY_OFFSET.field_5121.method_4469();
    }

    public static void polygonOffset(float f, float f2) {
        if (f != GlStateManager.POLY_OFFSET.field_5124 || f2 != GlStateManager.POLY_OFFSET.field_5122) {
            GlStateManager.POLY_OFFSET.field_5124 = f;
            GlStateManager.POLY_OFFSET.field_5122 = f2;
            GL11.glPolygonOffset((float)f, (float)f2);
        }
    }

    public static void enableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.field_5058.method_4471();
    }

    public static void disableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.field_5058.method_4469();
    }

    public static void logicOp(class_1030 class_10302) {
        GlStateManager.logicOp(class_10302.field_5108);
    }

    public static void logicOp(int n) {
        if (n != GlStateManager.COLOR_LOGIC.field_5059) {
            GlStateManager.COLOR_LOGIC.field_5059 = n;
            GL11.glLogicOp((int)n);
        }
    }

    public static void enableTexGen(class_1036 class_10362) {
        GlStateManager.getTexGen((class_1036)class_10362).field_5159.method_4471();
    }

    public static void disableTexGen(class_1036 class_10362) {
        GlStateManager.getTexGen((class_1036)class_10362).field_5159.method_4469();
    }

    public static void texGenMode(class_1036 class_10362, int n) {
        class_1037 class_10372 = GlStateManager.getTexGen(class_10362);
        if (n != class_10372.field_5160) {
            class_10372.field_5160 = n;
            GL11.glTexGeni((int)class_10372.field_5161, (int)9472, (int)n);
        }
    }

    public static void texGenParam(class_1036 class_10362, int n, FloatBuffer floatBuffer) {
        GL11.glTexGenfv((int)GlStateManager.getTexGen((class_1036)class_10362).field_5161, (int)n, (FloatBuffer)floatBuffer);
    }

    private static class_1037 getTexGen(class_1036 class_10362) {
        switch (class_10362) {
            case field_5154: {
                return GlStateManager.TEX_GEN.field_5162;
            }
            case field_5155: {
                return GlStateManager.TEX_GEN.field_5163;
            }
            case field_5156: {
                return GlStateManager.TEX_GEN.field_5164;
            }
            case field_5157: {
                return GlStateManager.TEX_GEN.field_5165;
            }
        }
        return GlStateManager.TEX_GEN.field_5162;
    }

    public static void activeTexture(int n) {
        if (activeTexture != n - GLX.GL_TEXTURE0) {
            activeTexture = n - GLX.GL_TEXTURE0;
            GLX.glActiveTexture(n);
        }
    }

    public static void enableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5166.method_4471();
    }

    public static void disableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5166.method_4469();
    }

    public static void texEnv(int n, int n2, FloatBuffer floatBuffer) {
        GL11.glTexEnvfv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public static void texEnv(int n, int n2, int n3) {
        GL11.glTexEnvi((int)n, (int)n2, (int)n3);
    }

    public static void texEnv(int n, int n2, float f) {
        GL11.glTexEnvf((int)n, (int)n2, (float)f);
    }

    public static void texParameter(int n, int n2, float f) {
        GL11.glTexParameterf((int)n, (int)n2, (float)f);
    }

    public static void texParameter(int n, int n2, int n3) {
        GL11.glTexParameteri((int)n, (int)n2, (int)n3);
    }

    public static int getTexLevelParameter(int n, int n2, int n3) {
        return GL11.glGetTexLevelParameteri((int)n, (int)n2, (int)n3);
    }

    public static int genTexture() {
        return GL11.glGenTextures();
    }

    public static void deleteTexture(int n) {
        GL11.glDeleteTextures((int)n);
        for (class_1039 class_10392 : TEXTURES) {
            if (class_10392.field_5167 != n) continue;
            class_10392.field_5167 = -1;
        }
    }

    public static void bindTexture(int n) {
        if (n != GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5167) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5167 = n;
            GL11.glBindTexture((int)3553, (int)n);
        }
    }

    public static void texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, @Nullable IntBuffer intBuffer) {
        GL11.glTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (IntBuffer)intBuffer);
    }

    public static void texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        GL11.glTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (long)l);
    }

    public static void copyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GL11.glCopyTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8);
    }

    public static void getTexImage(int n, int n2, int n3, int n4, long l) {
        GL11.glGetTexImage((int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    public static void enableNormalize() {
        NORMALIZE.method_4471();
    }

    public static void disableNormalize() {
        NORMALIZE.method_4469();
    }

    public static void shadeModel(int n) {
        if (n != shadeModel) {
            shadeModel = n;
            GL11.glShadeModel((int)n);
        }
    }

    public static void enableRescaleNormal() {
        RESCALE_NORMAL.method_4471();
    }

    public static void disableRescaleNormal() {
        RESCALE_NORMAL.method_4469();
    }

    public static void viewport(int n, int n2, int n3, int n4) {
        class_1040.field_5169.field_5172 = n;
        class_1040.field_5169.field_5171 = n2;
        class_1040.field_5169.field_5170 = n3;
        class_1040.field_5169.field_5168 = n4;
        GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl != GlStateManager.COLOR_MASK.field_5063 || bl2 != GlStateManager.COLOR_MASK.field_5062 || bl3 != GlStateManager.COLOR_MASK.field_5061 || bl4 != GlStateManager.COLOR_MASK.field_5060) {
            GlStateManager.COLOR_MASK.field_5063 = bl;
            GlStateManager.COLOR_MASK.field_5062 = bl2;
            GlStateManager.COLOR_MASK.field_5061 = bl3;
            GlStateManager.COLOR_MASK.field_5060 = bl4;
            GL11.glColorMask((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4);
        }
    }

    public static void stencilFunc(int n, int n2, int n3) {
        if (n != GlStateManager.STENCIL.field_5149.field_5148 || n != GlStateManager.STENCIL.field_5149.field_16203 || n != GlStateManager.STENCIL.field_5149.field_5147) {
            GlStateManager.STENCIL.field_5149.field_5148 = n;
            GlStateManager.STENCIL.field_5149.field_16203 = n2;
            GlStateManager.STENCIL.field_5149.field_5147 = n3;
            GL11.glStencilFunc((int)n, (int)n2, (int)n3);
        }
    }

    public static void stencilMask(int n) {
        if (n != GlStateManager.STENCIL.field_5153) {
            GlStateManager.STENCIL.field_5153 = n;
            GL11.glStencilMask((int)n);
        }
    }

    public static void stencilOp(int n, int n2, int n3) {
        if (n != GlStateManager.STENCIL.field_5152 || n2 != GlStateManager.STENCIL.field_5151 || n3 != GlStateManager.STENCIL.field_5150) {
            GlStateManager.STENCIL.field_5152 = n;
            GlStateManager.STENCIL.field_5151 = n2;
            GlStateManager.STENCIL.field_5150 = n3;
            GL11.glStencilOp((int)n, (int)n2, (int)n3);
        }
    }

    public static void clearDepth(double d) {
        if (d != GlStateManager.CLEAR.field_5053) {
            GlStateManager.CLEAR.field_5053 = d;
            GL11.glClearDepth((double)d);
        }
    }

    public static void clearColor(float f, float f2, float f3, float f4) {
        if (f != GlStateManager.CLEAR.field_5052.field_5057 || f2 != GlStateManager.CLEAR.field_5052.field_5056 || f3 != GlStateManager.CLEAR.field_5052.field_5055 || f4 != GlStateManager.CLEAR.field_5052.field_5054) {
            GlStateManager.CLEAR.field_5052.field_5057 = f;
            GlStateManager.CLEAR.field_5052.field_5056 = f2;
            GlStateManager.CLEAR.field_5052.field_5055 = f3;
            GlStateManager.CLEAR.field_5052.field_5054 = f4;
            GL11.glClearColor((float)f, (float)f2, (float)f3, (float)f4);
        }
    }

    public static void clearStencil(int n) {
        if (n != GlStateManager.CLEAR.field_16202) {
            GlStateManager.CLEAR.field_16202 = n;
            GL11.glClearStencil((int)n);
        }
    }

    public static void clear(int n, boolean bl) {
        GL11.glClear((int)n);
        if (bl) {
            GlStateManager.getError();
        }
    }

    public static void matrixMode(int n) {
        GL11.glMatrixMode((int)n);
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void getMatrix(int n, FloatBuffer floatBuffer) {
        GL11.glGetFloatv((int)n, (FloatBuffer)floatBuffer);
    }

    public static class_1159 getMatrix4f(int n) {
        GL11.glGetFloatv((int)n, (FloatBuffer)MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        class_1159 class_11592 = new class_1159();
        class_11592.method_4928(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        return class_11592;
    }

    public static void ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        GL11.glOrtho((double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    public static void rotatef(float f, float f2, float f3, float f4) {
        GL11.glRotatef((float)f, (float)f2, (float)f3, (float)f4);
    }

    public static void rotated(double d, double d2, double d3, double d4) {
        GL11.glRotated((double)d, (double)d2, (double)d3, (double)d4);
    }

    public static void scalef(float f, float f2, float f3) {
        GL11.glScalef((float)f, (float)f2, (float)f3);
    }

    public static void scaled(double d, double d2, double d3) {
        GL11.glScaled((double)d, (double)d2, (double)d3);
    }

    public static void translatef(float f, float f2, float f3) {
        GL11.glTranslatef((float)f, (float)f2, (float)f3);
    }

    public static void translated(double d, double d2, double d3) {
        GL11.glTranslated((double)d, (double)d2, (double)d3);
    }

    public static void multMatrix(FloatBuffer floatBuffer) {
        GL11.glMultMatrixf((FloatBuffer)floatBuffer);
    }

    public static void multMatrix(class_1159 class_11592) {
        class_11592.method_4932(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        GL11.glMultMatrixf((FloatBuffer)MATRIX_BUFFER);
    }

    public static void color4f(float f, float f2, float f3, float f4) {
        if (f != GlStateManager.COLOR.field_5057 || f2 != GlStateManager.COLOR.field_5056 || f3 != GlStateManager.COLOR.field_5055 || f4 != GlStateManager.COLOR.field_5054) {
            GlStateManager.COLOR.field_5057 = f;
            GlStateManager.COLOR.field_5056 = f2;
            GlStateManager.COLOR.field_5055 = f3;
            GlStateManager.COLOR.field_5054 = f4;
            GL11.glColor4f((float)f, (float)f2, (float)f3, (float)f4);
        }
    }

    public static void color3f(float f, float f2, float f3) {
        GlStateManager.color4f(f, f2, f3, 1.0f);
    }

    public static void texCoord2f(float f, float f2) {
        GL11.glTexCoord2f((float)f, (float)f2);
    }

    public static void vertex3f(float f, float f2, float f3) {
        GL11.glVertex3f((float)f, (float)f2, (float)f3);
    }

    public static void clearCurrentColor() {
        GlStateManager.COLOR.field_5057 = -1.0f;
        GlStateManager.COLOR.field_5056 = -1.0f;
        GlStateManager.COLOR.field_5055 = -1.0f;
        GlStateManager.COLOR.field_5054 = -1.0f;
    }

    public static void normalPointer(int n, int n2, int n3) {
        GL11.glNormalPointer((int)n, (int)n2, (long)n3);
    }

    public static void normalPointer(int n, int n2, ByteBuffer byteBuffer) {
        GL11.glNormalPointer((int)n, (int)n2, (ByteBuffer)byteBuffer);
    }

    public static void texCoordPointer(int n, int n2, int n3, int n4) {
        GL11.glTexCoordPointer((int)n, (int)n2, (int)n3, (long)n4);
    }

    public static void texCoordPointer(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glTexCoordPointer((int)n, (int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void vertexPointer(int n, int n2, int n3, int n4) {
        GL11.glVertexPointer((int)n, (int)n2, (int)n3, (long)n4);
    }

    public static void vertexPointer(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glVertexPointer((int)n, (int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void colorPointer(int n, int n2, int n3, int n4) {
        GL11.glColorPointer((int)n, (int)n2, (int)n3, (long)n4);
    }

    public static void colorPointer(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glColorPointer((int)n, (int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void disableClientState(int n) {
        GL11.glDisableClientState((int)n);
    }

    public static void enableClientState(int n) {
        GL11.glEnableClientState((int)n);
    }

    public static void begin(int n) {
        GL11.glBegin((int)n);
    }

    public static void end() {
        GL11.glEnd();
    }

    public static void drawArrays(int n, int n2, int n3) {
        GL11.glDrawArrays((int)n, (int)n2, (int)n3);
    }

    public static void lineWidth(float f) {
        GL11.glLineWidth((float)f);
    }

    public static void callList(int n) {
        GL11.glCallList((int)n);
    }

    public static void deleteLists(int n, int n2) {
        GL11.glDeleteLists((int)n, (int)n2);
    }

    public static void newList(int n, int n2) {
        GL11.glNewList((int)n, (int)n2);
    }

    public static void endList() {
        GL11.glEndList();
    }

    public static int genLists(int n) {
        return GL11.glGenLists((int)n);
    }

    public static void pixelStore(int n, int n2) {
        GL11.glPixelStorei((int)n, (int)n2);
    }

    public static void pixelTransfer(int n, float f) {
        GL11.glPixelTransferf((int)n, (float)f);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (ByteBuffer)byteBuffer);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (long)l);
    }

    public static int getError() {
        return GL11.glGetError();
    }

    public static String getString(int n) {
        return GL11.glGetString((int)n);
    }

    public static void getInteger(int n, IntBuffer intBuffer) {
        GL11.glGetIntegerv((int)n, (IntBuffer)intBuffer);
    }

    public static int getInteger(int n) {
        return GL11.glGetInteger((int)n);
    }

    public static void setProfile(class_1032 class_10322) {
        class_10322.method_4472();
    }

    public static void unsetProfile(class_1032 class_10322) {
        class_10322.method_4473();
    }

    static {
        TEXTURES = (class_1039[])IntStream.range(0, 8).mapToObj(n -> new class_1039()).toArray(class_1039[]::new);
        shadeModel = 7425;
        RESCALE_NORMAL = new class_1018(32826);
        COLOR_MASK = new class_1022();
        COLOR = new class_1020();
    }

    public static enum class_1032 {
        field_5127{

            @Override
            public void method_4472() {
                GlStateManager.disableAlphaTest();
                GlStateManager.alphaFunc(519, 0.0f);
                GlStateManager.disableLighting();
                GlStateManager.lightModel(2899, class_308.method_1451(0.2f, 0.2f, 0.2f, 1.0f));
                for (int i = 0; i < 8; ++i) {
                    GlStateManager.disableLight(i);
                    GlStateManager.light(16384 + i, 4608, class_308.method_1451(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.light(16384 + i, 4611, class_308.method_1451(0.0f, 0.0f, 1.0f, 0.0f));
                    if (i == 0) {
                        GlStateManager.light(16384 + i, 4609, class_308.method_1451(1.0f, 1.0f, 1.0f, 1.0f));
                        GlStateManager.light(16384 + i, 4610, class_308.method_1451(1.0f, 1.0f, 1.0f, 1.0f));
                        continue;
                    }
                    GlStateManager.light(16384 + i, 4609, class_308.method_1451(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.light(16384 + i, 4610, class_308.method_1451(0.0f, 0.0f, 0.0f, 1.0f));
                }
                GlStateManager.disableColorMaterial();
                GlStateManager.colorMaterial(1032, 5634);
                GlStateManager.disableDepthTest();
                GlStateManager.depthFunc(513);
                GlStateManager.depthMask(true);
                GlStateManager.disableBlend();
                GlStateManager.blendFunc(SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.blendFuncSeparate(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.blendEquation(32774);
                GlStateManager.disableFog();
                GlStateManager.fogi(2917, 2048);
                GlStateManager.fogDensity(1.0f);
                GlStateManager.fogStart(0.0f);
                GlStateManager.fogEnd(1.0f);
                GlStateManager.fog(2918, class_308.method_1451(0.0f, 0.0f, 0.0f, 0.0f));
                if (GL.getCapabilities().GL_NV_fog_distance) {
                    GlStateManager.fogi(2917, 34140);
                }
                GlStateManager.polygonOffset(0.0f, 0.0f);
                GlStateManager.disableColorLogicOp();
                GlStateManager.logicOp(5379);
                GlStateManager.disableTexGen(class_1036.field_5154);
                GlStateManager.texGenMode(class_1036.field_5154, 9216);
                GlStateManager.texGenParam(class_1036.field_5154, 9474, class_308.method_1451(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(class_1036.field_5154, 9217, class_308.method_1451(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(class_1036.field_5155);
                GlStateManager.texGenMode(class_1036.field_5155, 9216);
                GlStateManager.texGenParam(class_1036.field_5155, 9474, class_308.method_1451(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(class_1036.field_5155, 9217, class_308.method_1451(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(class_1036.field_5156);
                GlStateManager.texGenMode(class_1036.field_5156, 9216);
                GlStateManager.texGenParam(class_1036.field_5156, 9474, class_308.method_1451(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(class_1036.field_5156, 9217, class_308.method_1451(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(class_1036.field_5157);
                GlStateManager.texGenMode(class_1036.field_5157, 9216);
                GlStateManager.texGenParam(class_1036.field_5157, 9474, class_308.method_1451(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(class_1036.field_5157, 9217, class_308.method_1451(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.activeTexture(0);
                GlStateManager.texParameter(3553, 10240, 9729);
                GlStateManager.texParameter(3553, 10241, 9986);
                GlStateManager.texParameter(3553, 10242, 10497);
                GlStateManager.texParameter(3553, 10243, 10497);
                GlStateManager.texParameter(3553, 33085, 1000);
                GlStateManager.texParameter(3553, 33083, 1000);
                GlStateManager.texParameter(3553, 33082, -1000);
                GlStateManager.texParameter(3553, 34049, 0.0f);
                GlStateManager.texEnv(8960, 8704, 8448);
                GlStateManager.texEnv(8960, 8705, class_308.method_1451(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texEnv(8960, 34161, 8448);
                GlStateManager.texEnv(8960, 34162, 8448);
                GlStateManager.texEnv(8960, 34176, 5890);
                GlStateManager.texEnv(8960, 34177, 34168);
                GlStateManager.texEnv(8960, 34178, 34166);
                GlStateManager.texEnv(8960, 34184, 5890);
                GlStateManager.texEnv(8960, 34185, 34168);
                GlStateManager.texEnv(8960, 34186, 34166);
                GlStateManager.texEnv(8960, 34192, 768);
                GlStateManager.texEnv(8960, 34193, 768);
                GlStateManager.texEnv(8960, 34194, 770);
                GlStateManager.texEnv(8960, 34200, 770);
                GlStateManager.texEnv(8960, 34201, 770);
                GlStateManager.texEnv(8960, 34202, 770);
                GlStateManager.texEnv(8960, 34163, 1.0f);
                GlStateManager.texEnv(8960, 3356, 1.0f);
                GlStateManager.disableNormalize();
                GlStateManager.shadeModel(7425);
                GlStateManager.disableRescaleNormal();
                GlStateManager.colorMask(true, true, true, true);
                GlStateManager.clearDepth(1.0);
                GlStateManager.lineWidth(1.0f);
                GlStateManager.normal3f(0.0f, 0.0f, 1.0f);
                GlStateManager.polygonMode(1028, 6914);
                GlStateManager.polygonMode(1029, 6914);
            }

            @Override
            public void method_4473() {
            }
        }
        ,
        field_5128{

            @Override
            public void method_4472() {
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate(770, 771, 1, 0);
            }

            @Override
            public void method_4473() {
                GlStateManager.disableBlend();
            }
        }
        ,
        field_5125{

            @Override
            public void method_4472() {
                GlStateManager.color4f(1.0f, 1.0f, 1.0f, 0.15f);
                GlStateManager.depthMask(false);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.alphaFunc(516, 0.003921569f);
            }

            @Override
            public void method_4473() {
                GlStateManager.disableBlend();
                GlStateManager.alphaFunc(516, 0.1f);
                GlStateManager.depthMask(true);
            }
        };


        public abstract void method_4472();

        public abstract void method_4473();
    }

    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int n2) {
            this.value = n2;
        }
    }

    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int n2) {
            this.value = n2;
        }
    }

    static class class_1018 {
        private final int field_5050;
        private boolean field_5051;

        public class_1018(int n) {
            this.field_5050 = n;
        }

        public void method_4469() {
            this.method_4470(false);
        }

        public void method_4471() {
            this.method_4470(true);
        }

        public void method_4470(boolean bl) {
            if (bl != this.field_5051) {
                this.field_5051 = bl;
                if (bl) {
                    GL11.glEnable((int)this.field_5050);
                } else {
                    GL11.glDisable((int)this.field_5050);
                }
            }
        }
    }

    static class class_1020 {
        public float field_5057 = 1.0f;
        public float field_5056 = 1.0f;
        public float field_5055 = 1.0f;
        public float field_5054 = 1.0f;

        public class_1020() {
            this(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public class_1020(float f, float f2, float f3, float f4) {
            this.field_5057 = f;
            this.field_5056 = f2;
            this.field_5055 = f3;
            this.field_5054 = f4;
        }
    }

    static class class_1022 {
        public boolean field_5063 = true;
        public boolean field_5062 = true;
        public boolean field_5061 = true;
        public boolean field_5060 = true;

        private class_1022() {
        }
    }

    public static enum class_1036 {
        field_5154,
        field_5155,
        field_5156,
        field_5157;

    }

    static class class_1037 {
        public final class_1018 field_5159;
        public final int field_5161;
        public int field_5160 = -1;

        public class_1037(int n, int n2) {
            this.field_5161 = n;
            this.field_5159 = new class_1018(n2);
        }
    }

    static class class_1038 {
        public final class_1037 field_5162 = new class_1037(8192, 3168);
        public final class_1037 field_5163 = new class_1037(8193, 3169);
        public final class_1037 field_5164 = new class_1037(8194, 3170);
        public final class_1037 field_5165 = new class_1037(8195, 3171);

        private class_1038() {
        }
    }

    static class class_1035 {
        public final class_1034 field_5149 = new class_1034();
        public int field_5153 = -1;
        public int field_5152 = 7680;
        public int field_5151 = 7680;
        public int field_5150 = 7680;

        private class_1035() {
        }
    }

    static class class_1034 {
        public int field_5148 = 519;
        public int field_16203;
        public int field_5147 = -1;

        private class_1034() {
        }
    }

    static class class_1019 {
        public double field_5053 = 1.0;
        public final class_1020 field_5052 = new class_1020(0.0f, 0.0f, 0.0f, 0.0f);
        public int field_16202;

        private class_1019() {
        }
    }

    static class class_1021 {
        public final class_1018 field_5058 = new class_1018(3058);
        public int field_5059 = 5379;

        private class_1021() {
        }
    }

    static class class_1031 {
        public final class_1018 field_5123 = new class_1018(32823);
        public final class_1018 field_5121 = new class_1018(10754);
        public float field_5124;
        public float field_5122;

        private class_1031() {
        }
    }

    static class class_1025 {
        public final class_1018 field_5072 = new class_1018(2884);
        public int field_5073 = 1029;

        private class_1025() {
        }
    }

    static class class_1029 {
        public final class_1018 field_5100 = new class_1018(2912);
        public int field_5102 = 2048;
        public float field_5101 = 1.0f;
        public float field_5099;
        public float field_5098 = 1.0f;

        private class_1029() {
        }
    }

    static class class_1026 {
        public final class_1018 field_5074 = new class_1018(2929);
        public boolean field_5076 = true;
        public int field_5075 = 513;

        private class_1026() {
        }
    }

    static class class_1017 {
        public final class_1018 field_5045 = new class_1018(3042);
        public int field_5049 = 1;
        public int field_5048 = 0;
        public int field_5047 = 1;
        public int field_5046 = 0;

        private class_1017() {
        }
    }

    static class class_1023 {
        public final class_1018 field_5064 = new class_1018(2903);
        public int field_5066 = 1032;
        public int field_5065 = 5634;

        private class_1023() {
        }
    }

    static class class_1016 {
        public final class_1018 field_5042 = new class_1018(3008);
        public int field_5044 = 519;
        public float field_5043 = -1.0f;

        private class_1016() {
        }
    }

    static class class_1039 {
        public final class_1018 field_5166 = new class_1018(3553);
        public int field_5167;

        private class_1039() {
        }
    }

    public static enum class_1040 {
        field_5169;

        protected int field_5172;
        protected int field_5171;
        protected int field_5170;
        protected int field_5168;
    }

    public static enum class_1030 {
        field_5120(5377),
        field_5112(5380),
        field_5117(5378),
        field_5103(5376),
        field_5118(5379),
        field_5113(5388),
        field_5119(5385),
        field_5109(5386),
        field_5114(5390),
        field_5115(5381),
        field_5104(5384),
        field_5105(5383),
        field_5116(5389),
        field_5110(5387),
        field_5107(5391),
        field_5111(5382);

        public final int field_5108;

        private class_1030(int n2) {
            this.field_5108 = n2;
        }
    }

    public static enum class_1024 {
        field_5068(1028),
        field_5070(1029),
        field_5071(1032);

        public final int field_5069;

        private class_1024(int n2) {
            this.field_5069 = n2;
        }
    }

    public static enum class_1028 {
        field_5095(9729),
        field_5096(2048),
        field_5097(2049);

        public final int field_5093;

        private class_1028(int n2) {
            this.field_5093 = n2;
        }
    }
}

