/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_1138;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import paulscode.sound.Channel;

public class class_1137
extends Channel {
    public IntBuffer field_5539;
    public int field_5541;
    public int field_5540;
    public float field_5538;

    public class_1137(int n, IntBuffer intBuffer) {
        super(n);
        this.libraryType = class_1138.class;
        this.field_5539 = intBuffer;
    }

    public void cleanup() {
        if (this.field_5539 != null) {
            try {
                AL10.alSourceStop((int)this.field_5539.get(0));
                AL10.alGetError();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                AL10.alDeleteSources((IntBuffer)this.field_5539);
                AL10.alGetError();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.field_5539.clear();
        }
        this.field_5539 = null;
        super.cleanup();
    }

    public boolean method_4827(IntBuffer intBuffer) {
        if (this.errorCheck(this.channelType != 0, "Sound buffers may only be attached to normal sources.")) {
            return false;
        }
        AL10.alSourcei((int)this.field_5539.get(0), (int)4105, (int)intBuffer.get(0));
        if (this.attachedSource != null && this.attachedSource.soundBuffer != null && this.attachedSource.soundBuffer.audioFormat != null) {
            this.setAudioFormat(this.attachedSource.soundBuffer.audioFormat);
        }
        return this.method_4829();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAudioFormat(AudioFormat audioFormat2) {
        int \u26032;
        if (audioFormat2.getChannels() == 1) {
            if (audioFormat2.getSampleSizeInBits() == 8) {
                \u26032 = 4352;
            } else {
                AudioFormat audioFormat2;
                if (audioFormat2.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'setAudioFormat'");
                    return;
                }
                \u26032 = 4353;
            }
        } else {
            if (audioFormat2.getChannels() != 2) {
                this.errorMessage("Audio data neither mono nor stereo in method 'setAudioFormat'");
                return;
            }
            if (audioFormat2.getSampleSizeInBits() == 8) {
                \u26032 = 4354;
            } else {
                if (audioFormat2.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'setAudioFormat'");
                    return;
                }
                \u26032 = 4355;
            }
        }
        this.field_5541 = \u26032;
        this.field_5540 = (int)audioFormat2.getSampleRate();
    }

    public void method_4828(int n, int n2) {
        this.field_5541 = n;
        this.field_5540 = n2;
    }

    public boolean preLoadBuffers(LinkedList<byte[]> linkedList) {
        IntBuffer \u26032;
        if (this.errorCheck(this.channelType != 1, "Buffers may only be queued for streaming sources.")) {
            return false;
        }
        if (this.errorCheck(linkedList == null, "Buffer List null in method 'preLoadBuffers'")) {
            return false;
        }
        boolean bl = this.playing();
        if (bl) {
            AL10.alSourceStop((int)this.field_5539.get(0));
            this.method_4829();
        }
        if ((\u2603 = AL10.alGetSourcei((int)this.field_5539.get(0), (int)4118)) > 0) {
            \u26032 = BufferUtils.createIntBuffer((int)\u2603);
            AL10.alGenBuffers((IntBuffer)\u26032);
            if (this.errorCheck(this.method_4829(), "Error clearing stream buffers in method 'preLoadBuffers'")) {
                return false;
            }
            AL10.alSourceUnqueueBuffers((int)this.field_5539.get(0), (IntBuffer)\u26032);
            if (this.errorCheck(this.method_4829(), "Error unqueuing stream buffers in method 'preLoadBuffers'")) {
                return false;
            }
        }
        if (bl) {
            AL10.alSourcePlay((int)this.field_5539.get(0));
            this.method_4829();
        }
        \u26032 = BufferUtils.createIntBuffer((int)linkedList.size());
        AL10.alGenBuffers((IntBuffer)\u26032);
        if (this.errorCheck(this.method_4829(), "Error generating stream buffers in method 'preLoadBuffers'")) {
            return false;
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            ByteBuffer byteBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)linkedList.get(i).length).put(linkedList.get(i)).flip();
            try {
                AL10.alBufferData((int)\u26032.get(i), (int)this.field_5541, (ByteBuffer)byteBuffer, (int)this.field_5540);
            }
            catch (Exception \u26033) {
                this.errorMessage("Error creating buffers in method 'preLoadBuffers'");
                this.printStackTrace(\u26033);
                return false;
            }
            if (!this.errorCheck(this.method_4829(), "Error creating buffers in method 'preLoadBuffers'")) continue;
            return false;
        }
        try {
            AL10.alSourceQueueBuffers((int)this.field_5539.get(0), (IntBuffer)\u26032);
        }
        catch (Exception exception) {
            this.errorMessage("Error queuing buffers in method 'preLoadBuffers'");
            this.printStackTrace(exception);
            return false;
        }
        if (this.errorCheck(this.method_4829(), "Error queuing buffers in method 'preLoadBuffers'")) {
            return false;
        }
        AL10.alSourcePlay((int)this.field_5539.get(0));
        return !this.errorCheck(this.method_4829(), "Error playing source in method 'preLoadBuffers'");
    }

    public boolean queueBuffer(byte[] byArray) {
        if (this.errorCheck(this.channelType != 1, "Buffers may only be queued for streaming sources.")) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)byArray.length).put(byArray).flip();
        IntBuffer \u26032 = BufferUtils.createIntBuffer((int)1);
        AL10.alSourceUnqueueBuffers((int)this.field_5539.get(0), (IntBuffer)\u26032);
        if (this.method_4829()) {
            return false;
        }
        if (AL10.alIsBuffer((int)\u26032.get(0))) {
            this.field_5538 += this.method_4830(\u26032.get(0));
        }
        this.method_4829();
        AL10.alBufferData((int)\u26032.get(0), (int)this.field_5541, (ByteBuffer)byteBuffer, (int)this.field_5540);
        if (this.method_4829()) {
            return false;
        }
        AL10.alSourceQueueBuffers((int)this.field_5539.get(0), (IntBuffer)\u26032);
        return !this.method_4829();
    }

    public int feedRawAudioData(byte[] byArray) {
        IntBuffer intBuffer;
        if (this.errorCheck(this.channelType != 1, "Raw audio data can only be fed to streaming sources.")) {
            return -1;
        }
        ByteBuffer byteBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)byArray.length).put(byArray).flip();
        int \u26032 = AL10.alGetSourcei((int)this.field_5539.get(0), (int)4118);
        if (\u26032 > 0) {
            intBuffer = BufferUtils.createIntBuffer((int)\u26032);
            AL10.alGenBuffers((IntBuffer)intBuffer);
            if (this.errorCheck(this.method_4829(), "Error clearing stream buffers in method 'feedRawAudioData'")) {
                return -1;
            }
            AL10.alSourceUnqueueBuffers((int)this.field_5539.get(0), (IntBuffer)intBuffer);
            if (this.errorCheck(this.method_4829(), "Error unqueuing stream buffers in method 'feedRawAudioData'")) {
                return -1;
            }
            if (AL10.alIsBuffer((int)intBuffer.get(0))) {
                this.field_5538 += this.method_4830(intBuffer.get(0));
            }
            this.method_4829();
        } else {
            intBuffer = BufferUtils.createIntBuffer((int)1);
            AL10.alGenBuffers((IntBuffer)intBuffer);
            if (this.errorCheck(this.method_4829(), "Error generating stream buffers in method 'preLoadBuffers'")) {
                return -1;
            }
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)this.field_5541, (ByteBuffer)byteBuffer, (int)this.field_5540);
        if (this.method_4829()) {
            return -1;
        }
        AL10.alSourceQueueBuffers((int)this.field_5539.get(0), (IntBuffer)intBuffer);
        if (this.method_4829()) {
            return -1;
        }
        if (this.attachedSource != null && this.attachedSource.channel == this && this.attachedSource.active() && !this.playing()) {
            AL10.alSourcePlay((int)this.field_5539.get(0));
            this.method_4829();
        }
        return \u26032;
    }

    public float method_4830(int n) {
        return (float)(1000 * AL10.alGetBufferi((int)n, (int)8196) / AL10.alGetBufferi((int)n, (int)8195)) / ((float)AL10.alGetBufferi((int)n, (int)8194) / 8.0f) / (float)this.field_5540;
    }

    public float millisecondsPlayed() {
        float f = AL10.alGetSourcei((int)this.field_5539.get(0), (int)4134);
        \u2603 = 1.0f;
        switch (this.field_5541) {
            case 4352: {
                \u2603 = 1.0f;
                break;
            }
            case 4353: {
                \u2603 = 2.0f;
                break;
            }
            case 4354: {
                \u2603 = 2.0f;
                break;
            }
            case 4355: {
                \u2603 = 4.0f;
                break;
            }
        }
        f = f / \u2603 / (float)this.field_5540 * 1000.0f;
        if (this.channelType == 1) {
            f += this.field_5538;
        }
        return f;
    }

    public int buffersProcessed() {
        if (this.channelType != 1) {
            return 0;
        }
        int n = AL10.alGetSourcei((int)this.field_5539.get(0), (int)4118);
        if (this.method_4829()) {
            return 0;
        }
        return n;
    }

    public void flush() {
        if (this.channelType != 1) {
            return;
        }
        if (this.method_4829()) {
            return;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        for (int i = AL10.alGetSourcei((int)this.field_5539.get(0), (int)4117); i > 0; --i) {
            try {
                AL10.alSourceUnqueueBuffers((int)this.field_5539.get(0), (IntBuffer)intBuffer);
            }
            catch (Exception exception) {
                return;
            }
            if (!this.method_4829()) continue;
            return;
        }
        this.field_5538 = 0.0f;
    }

    public void close() {
        try {
            AL10.alSourceStop((int)this.field_5539.get(0));
            AL10.alGetError();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.channelType == 1) {
            this.flush();
        }
    }

    public void play() {
        AL10.alSourcePlay((int)this.field_5539.get(0));
        this.method_4829();
    }

    public void pause() {
        AL10.alSourcePause((int)this.field_5539.get(0));
        this.method_4829();
    }

    public void stop() {
        AL10.alSourceStop((int)this.field_5539.get(0));
        if (!this.method_4829()) {
            this.field_5538 = 0.0f;
        }
    }

    public void rewind() {
        if (this.channelType == 1) {
            return;
        }
        AL10.alSourceRewind((int)this.field_5539.get(0));
        if (!this.method_4829()) {
            this.field_5538 = 0.0f;
        }
    }

    public boolean playing() {
        int n = AL10.alGetSourcei((int)this.field_5539.get(0), (int)4112);
        if (this.method_4829()) {
            return false;
        }
        return n == 4114;
    }

    private boolean method_4829() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter.");
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter.");
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value.");
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call.");
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory.");
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred.");
        return true;
    }
}

