/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_1137;
import net.minecraft.class_1147;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;

public class class_1138
extends Library {
    private FloatBuffer field_5548;
    private FloatBuffer field_5545;
    private FloatBuffer field_5544;
    private Map<String, IntBuffer> field_5546 = Maps.newHashMap();
    private static boolean field_5547 = true;
    private String field_5549 = "PreInit";
    private long field_5543;
    private long field_5542;

    public class_1138() throws SoundSystemException {
        this.reverseByteOrder = true;
    }

    public void init() throws SoundSystemException {
        boolean bl = false;
        long \u26032 = ALC10.alcOpenDevice((ByteBuffer)null);
        if (\u26032 == 0L) {
            throw new class_1139("Failed to open default device", 101);
        }
        ALCCapabilities \u26033 = ALC.createCapabilities((long)\u26032);
        if (!\u26033.OpenALC10) {
            throw new class_1139("OpenAL 1.0 not supported", 101);
        }
        this.field_5542 = ALC10.alcCreateContext((long)\u26032, (IntBuffer)null);
        ALC10.alcMakeContextCurrent((long)this.field_5542);
        AL.createCapabilities((ALCCapabilities)\u26033);
        this.message("OpenAL initialized.");
        this.field_5548 = BufferUtils.createFloatBuffer((int)3).put(new float[]{this.listener.position.x, this.listener.position.y, this.listener.position.z});
        this.field_5545 = BufferUtils.createFloatBuffer((int)6).put(new float[]{this.listener.lookAt.x, this.listener.lookAt.y, this.listener.lookAt.z, this.listener.up.x, this.listener.up.y, this.listener.up.z});
        this.field_5544 = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
        this.field_5548.flip();
        this.field_5545.flip();
        this.field_5544.flip();
        this.field_5549 = "Post Init";
        AL10.alListenerfv((int)4100, (FloatBuffer)this.field_5548);
        bl = this.method_4832() || bl;
        AL10.alListenerfv((int)4111, (FloatBuffer)this.field_5545);
        bl = this.method_4832() || bl;
        AL10.alListenerfv((int)4102, (FloatBuffer)this.field_5544);
        bl = this.method_4832() || bl;
        AL10.alDopplerFactor((float)SoundSystemConfig.getDopplerFactor());
        bl = this.method_4832() || bl;
        AL10.alDopplerVelocity((float)SoundSystemConfig.getDopplerVelocity());
        boolean bl2 = bl = this.method_4832() || bl;
        if (bl) {
            this.importantMessage("OpenAL did not initialize properly!");
            throw new class_1139("Problem encountered while loading OpenAL or creating the listener. Probable cause: OpenAL not supported", 101);
        }
        super.init();
        class_1137 \u26034 = (class_1137)((Object)this.normalChannels.get(1));
        try {
            AL10.alSourcef((int)\u26034.field_5539.get(0), (int)4099, (float)1.0f);
            if (this.method_4832()) {
                class_1138.method_4833(true, false);
                throw new class_1139("OpenAL: AL_PITCH not supported.", 108);
            }
            class_1138.method_4833(true, true);
        }
        catch (Exception \u26035) {
            class_1138.method_4833(true, false);
            throw new class_1139("OpenAL: AL_PITCH not supported.", 108);
        }
        this.field_5549 = "Running";
    }

    protected Channel createChannel(int n) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        try {
            AL10.alGenSources((IntBuffer)intBuffer);
        }
        catch (Exception \u26032) {
            AL10.alGetError();
            return null;
        }
        if (AL10.alGetError() != 0) {
            return null;
        }
        return new class_1137(n, intBuffer);
    }

    public void cleanup() {
        super.cleanup();
        for (String string : this.bufferMap.keySet()) {
            IntBuffer intBuffer = this.field_5546.get(string);
            if (intBuffer == null) continue;
            AL10.alDeleteBuffers((IntBuffer)intBuffer);
            this.method_4832();
            intBuffer.clear();
        }
        this.bufferMap.clear();
        ALC10.alcDestroyContext((long)this.field_5542);
        if (this.field_5543 != 0L) {
            ALC10.alcCloseDevice((long)this.field_5543);
        }
        this.bufferMap = null;
        this.field_5548 = null;
        this.field_5545 = null;
        this.field_5544 = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean loadSound(FilenameURL filenameURL) {
        int n;
        if (this.bufferMap == null) {
            this.bufferMap = Maps.newHashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.field_5546 == null) {
            this.field_5546 = Maps.newHashMap();
            this.importantMessage("Open AL Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec((String)filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.reverseByteOrder(true);
        URL \u26032 = filenameURL.getURL();
        if (this.errorCheck(\u26032 == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(\u26032);
        SoundBuffer \u26033 = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (this.errorCheck(\u26033 == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(filenameURL.getFilename(), \u26033);
        AudioFormat \u26034 = \u26033.audioFormat;
        if (\u26034.getChannels() == 1) {
            if (\u26034.getSampleSizeInBits() == 8) {
                n = 4352;
            } else {
                if (\u26034.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n = 4353;
            }
        } else {
            if (\u26034.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (\u26034.getSampleSizeInBits() == 8) {
                n = 4354;
            } else {
                if (\u26034.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when loading " + filenameURL.getFilename())) {
            return false;
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)n, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)\u26033.audioData.length).put(\u26033.audioData).flip()), (int)((int)\u26034.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when loading " + filenameURL.getFilename()) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + filenameURL.getFilename())) {
            return false;
        }
        this.field_5546.put(filenameURL.getFilename(), intBuffer);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean loadSound(SoundBuffer soundBuffer, String string) {
        int \u26032;
        if (this.bufferMap == null) {
            this.bufferMap = Maps.newHashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.field_5546 == null) {
            this.field_5546 = Maps.newHashMap();
            this.importantMessage("Open AL Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(string == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(string) != null) {
            return true;
        }
        if (this.errorCheck(soundBuffer == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(string, soundBuffer);
        AudioFormat audioFormat = soundBuffer.audioFormat;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                \u26032 = 4352;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                \u26032 = 4353;
            }
        } else {
            if (audioFormat.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (audioFormat.getSampleSizeInBits() == 8) {
                \u26032 = 4354;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                \u26032 = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when saving " + string)) {
            return false;
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)\u26032, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)soundBuffer.audioData.length).put(soundBuffer.audioData).flip()), (int)((int)audioFormat.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when saving " + string) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + string)) {
            return false;
        }
        this.field_5546.put(string, intBuffer);
        return true;
    }

    public void unloadSound(String string) {
        this.field_5546.remove(string);
        super.unloadSound(string);
    }

    public void setMasterVolume(float f) {
        super.setMasterVolume(f);
        AL10.alListenerf((int)4106, (float)f);
        this.method_4832();
    }

    public void newSource(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f, float f2, float f3, int n, float f4) {
        IntBuffer intBuffer = null;
        if (!bl2) {
            intBuffer = this.field_5546.get(filenameURL.getFilename());
            if (intBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage(String.format("Source '%s' was not created because an error occurred while loading %s", string, filenameURL.getFilename()));
                return;
            }
            intBuffer = this.field_5546.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.errorMessage(String.format("Source '%s' was not created because a sound buffer was not found for %s", string, filenameURL.getFilename()));
                return;
            }
        }
        SoundBuffer \u26032 = null;
        if (!bl2) {
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null && !this.loadSound(filenameURL)) {
                this.errorMessage(String.format("Source '%s' was not created because an error occurred while loading %s", string, filenameURL.getFilename()));
                return;
            }
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null) {
                this.errorMessage(String.format("Source '%s' was not created because audio data was not found for %s", string, filenameURL.getFilename()));
                return;
            }
        }
        this.sourceMap.put(string, new class_1147(this.field_5548, intBuffer, bl, bl2, bl3, string, filenameURL, \u26032, f, f2, f3, n, f4, false));
    }

    public void rawDataStream(AudioFormat audioFormat, boolean bl, String string, float f, float f2, float f3, int n, float f4) {
        this.sourceMap.put(string, new class_1147(this.field_5548, audioFormat, bl, string, f, f2, f3, n, f4));
    }

    public void quickPlay(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f, float f2, float f3, int n, float f4, boolean bl4) {
        IntBuffer intBuffer = null;
        if (!bl2) {
            intBuffer = this.field_5546.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.loadSound(filenameURL);
            }
            if ((intBuffer = this.field_5546.get(filenameURL.getFilename())) == null) {
                this.errorMessage("Sound buffer was not created for " + filenameURL.getFilename());
                return;
            }
        }
        SoundBuffer \u26032 = null;
        if (!bl2) {
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null && !this.loadSound(filenameURL)) {
                this.errorMessage(String.format("Source '%s' was not created because an error occurred while loading %s", string, filenameURL.getFilename()));
                return;
            }
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null) {
                this.errorMessage(String.format("Source '%s' was not created because audio data was not found for %s", string, filenameURL.getFilename()));
                return;
            }
        }
        class_1147 \u26033 = new class_1147(this.field_5548, intBuffer, bl, bl2, bl3, string, filenameURL, \u26032, f, f2, f3, n, f4, false);
        this.sourceMap.put(string, \u26033);
        this.play(\u26033);
        if (bl4) {
            \u26033.setTemporary(true);
        }
    }

    public void copySources(HashMap<String, Source> hashMap) {
        if (hashMap == null) {
            return;
        }
        Set<String> set = hashMap.keySet();
        Iterator<String> \u26032 = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = Maps.newHashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        if (this.field_5546 == null) {
            this.field_5546 = Maps.newHashMap();
            this.importantMessage("Open AL Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (\u26032.hasNext()) {
            String string = \u26032.next();
            Source \u26033 = hashMap.get(string);
            if (\u26033 == null) continue;
            SoundBuffer \u26034 = null;
            if (!\u26033.toStream) {
                this.loadSound(\u26033.filenameURL);
                \u26034 = (SoundBuffer)this.bufferMap.get(\u26033.filenameURL.getFilename());
            }
            if (!\u26033.toStream && \u26034 == null) continue;
            this.sourceMap.put(string, new class_1147(this.field_5548, this.field_5546.get(\u26033.filenameURL.getFilename()), \u26033, \u26034));
        }
    }

    public void setListenerPosition(float f, float f2, float f3) {
        super.setListenerPosition(f, f2, f3);
        this.field_5548.put(0, f);
        this.field_5548.put(1, f2);
        this.field_5548.put(2, f3);
        AL10.alListenerfv((int)4100, (FloatBuffer)this.field_5548);
        this.method_4832();
    }

    public void setListenerAngle(float f) {
        super.setListenerAngle(f);
        this.field_5545.put(0, this.listener.lookAt.x);
        this.field_5545.put(2, this.listener.lookAt.z);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.field_5545);
        this.method_4832();
    }

    public void setListenerOrientation(float f, float f2, float f3, float f4, float f5, float f6) {
        super.setListenerOrientation(f, f2, f3, f4, f5, f6);
        this.field_5545.put(0, f);
        this.field_5545.put(1, f2);
        this.field_5545.put(2, f3);
        this.field_5545.put(3, f4);
        this.field_5545.put(4, f5);
        this.field_5545.put(5, f6);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.field_5545);
        this.method_4832();
    }

    public void setListenerData(ListenerData listenerData) {
        super.setListenerData(listenerData);
        this.field_5548.put(0, listenerData.position.x);
        this.field_5548.put(1, listenerData.position.y);
        this.field_5548.put(2, listenerData.position.z);
        AL10.alListenerfv((int)4100, (FloatBuffer)this.field_5548);
        this.method_4832();
        this.field_5545.put(0, listenerData.lookAt.x);
        this.field_5545.put(1, listenerData.lookAt.y);
        this.field_5545.put(2, listenerData.lookAt.z);
        this.field_5545.put(3, listenerData.up.x);
        this.field_5545.put(4, listenerData.up.y);
        this.field_5545.put(5, listenerData.up.z);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.field_5545);
        this.method_4832();
        this.field_5544.put(0, listenerData.velocity.x);
        this.field_5544.put(1, listenerData.velocity.y);
        this.field_5544.put(2, listenerData.velocity.z);
        AL10.alListenerfv((int)4102, (FloatBuffer)this.field_5544);
        this.method_4832();
    }

    public void setListenerVelocity(float f, float f2, float f3) {
        super.setListenerVelocity(f, f2, f3);
        this.field_5544.put(0, this.listener.velocity.x);
        this.field_5544.put(1, this.listener.velocity.y);
        this.field_5544.put(2, this.listener.velocity.z);
        AL10.alListenerfv((int)4102, (FloatBuffer)this.field_5544);
    }

    public void dopplerChanged() {
        super.dopplerChanged();
        AL10.alDopplerFactor((float)SoundSystemConfig.getDopplerFactor());
        this.method_4832();
        AL10.alDopplerVelocity((float)SoundSystemConfig.getDopplerVelocity());
        this.method_4832();
    }

    private boolean method_4832() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter: " + this.field_5549);
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter: " + this.field_5549);
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value: " + this.field_5549);
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call: " + this.field_5549);
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory: " + this.field_5549);
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred: " + this.field_5549);
        return true;
    }

    public static boolean method_4831() {
        return class_1138.method_4833(false, false);
    }

    private static synchronized boolean method_4833(boolean bl, boolean bl2) {
        if (bl) {
            field_5547 = bl2;
        }
        return field_5547;
    }

    public String getClassName() {
        return "LibraryLWJGL3";
    }

    public static class class_1139
    extends SoundSystemException {
        public class_1139(String string, int n) {
            super(string, n);
        }
    }
}

