/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_1137;
import net.minecraft.class_1138;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;

public class class_1147
extends Source {
    private class_1137 field_5605;
    private IntBuffer field_5607;
    private FloatBuffer field_5603;
    private FloatBuffer field_5604;
    private FloatBuffer field_5606;

    public class_1147(FloatBuffer floatBuffer, IntBuffer intBuffer, boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, SoundBuffer soundBuffer, float f, float f2, float f3, int n, float f4, boolean bl4) {
        super(bl, bl2, bl3, string, filenameURL, soundBuffer, f, f2, f3, n, f4, bl4);
        this.field_5605 = (class_1137)this.channel;
        if (this.codec != null) {
            this.codec.reverseByteOrder(true);
        }
        this.field_5603 = floatBuffer;
        this.field_5607 = intBuffer;
        this.libraryType = class_1138.class;
        this.pitch = 1.0f;
        this.method_4890();
    }

    public class_1147(FloatBuffer floatBuffer, IntBuffer intBuffer, Source source, SoundBuffer soundBuffer) {
        super(source, soundBuffer);
        this.field_5605 = (class_1137)this.channel;
        if (this.codec != null) {
            this.codec.reverseByteOrder(true);
        }
        this.field_5603 = floatBuffer;
        this.field_5607 = intBuffer;
        this.libraryType = class_1138.class;
        this.pitch = 1.0f;
        this.method_4890();
    }

    public class_1147(FloatBuffer floatBuffer, AudioFormat audioFormat, boolean bl, String string, float f, float f2, float f3, int n, float f4) {
        super(audioFormat, bl, string, f, f2, f3, n, f4);
        this.field_5605 = (class_1137)this.channel;
        this.field_5603 = floatBuffer;
        this.libraryType = class_1138.class;
        this.pitch = 1.0f;
        this.method_4890();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean incrementSoundSequence() {
        if (!this.toStream) {
            this.errorMessage("Method 'incrementSoundSequence' may only be used for streaming sources.");
            return false;
        }
        Object object = this.soundSequenceLock;
        synchronized (object) {
            int \u26032;
            AudioFormat audioFormat;
            if (this.soundSequenceQueue == null || this.soundSequenceQueue.isEmpty()) {
                return false;
            }
            this.filenameURL = (FilenameURL)this.soundSequenceQueue.remove(0);
            if (this.codec != null) {
                this.codec.cleanup();
            }
            this.codec = SoundSystemConfig.getCodec((String)this.filenameURL.getFilename());
            if (this.codec == null) {
                return true;
            }
            this.codec.reverseByteOrder(true);
            if (this.codec.getAudioFormat() == null) {
                this.codec.initialize(this.filenameURL.getURL());
            }
            if ((audioFormat = this.codec.getAudioFormat()) == null) {
                this.errorMessage("Audio Format null in method 'incrementSoundSequence'");
                return false;
            }
            if (audioFormat.getChannels() == 1) {
                if (audioFormat.getSampleSizeInBits() == 8) {
                    \u26032 = 4352;
                } else {
                    if (audioFormat.getSampleSizeInBits() != 16) {
                        this.errorMessage("Illegal sample size in method 'incrementSoundSequence'");
                        return false;
                    }
                    \u26032 = 4353;
                }
            } else {
                if (audioFormat.getChannels() != 2) {
                    this.errorMessage("Audio data neither mono nor stereo in method 'incrementSoundSequence'");
                    return false;
                }
                if (audioFormat.getSampleSizeInBits() == 8) {
                    \u26032 = 4354;
                } else {
                    if (audioFormat.getSampleSizeInBits() != 16) {
                        this.errorMessage("Illegal sample size in method 'incrementSoundSequence'");
                        return false;
                    }
                    \u26032 = 4355;
                }
            }
            this.field_5605.method_4828(\u26032, (int)audioFormat.getSampleRate());
            this.preLoad = true;
            return true;
        }
    }

    public void listenerMoved() {
        this.positionChanged();
    }

    public void setPosition(float f, float f2, float f3) {
        super.setPosition(f, f2, f3);
        if (this.field_5604 == null) {
            this.method_4890();
        } else {
            this.positionChanged();
        }
        this.field_5604.put(0, f);
        this.field_5604.put(1, f2);
        this.field_5604.put(2, f3);
        if (this.channel != null && this.channel.attachedSource == this && this.field_5605 != null && this.field_5605.field_5539 != null) {
            AL10.alSourcefv((int)this.field_5605.field_5539.get(0), (int)4100, (FloatBuffer)this.field_5604);
            this.method_4889();
        }
    }

    public void positionChanged() {
        this.method_4891();
        this.method_4892();
        if (this.channel != null && this.channel.attachedSource == this && this.field_5605 != null && this.field_5605.field_5539 != null) {
            AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4106, (float)(this.gain * this.sourceVolume * Math.abs(this.fadeOutGain) * this.fadeInGain));
            this.method_4889();
        }
        this.method_4888();
    }

    private void method_4888() {
        if (this.channel != null && this.channel.attachedSource == this && class_1138.method_4831() && this.field_5605 != null && this.field_5605.field_5539 != null) {
            AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4099, (float)this.pitch);
            this.method_4889();
        }
    }

    public void setLooping(boolean bl) {
        super.setLooping(bl);
        if (this.channel != null && this.channel.attachedSource == this && this.field_5605 != null && this.field_5605.field_5539 != null) {
            AL10.alSourcei((int)this.field_5605.field_5539.get(0), (int)4103, (int)(bl ? 1 : 0));
            this.method_4889();
        }
    }

    public void setAttenuation(int n) {
        super.setAttenuation(n);
        if (this.channel != null && this.channel.attachedSource == this && this.field_5605 != null && this.field_5605.field_5539 != null) {
            if (n == 1) {
                AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4129, (float)this.distOrRoll);
            } else {
                AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4129, (float)0.0f);
            }
            this.method_4889();
        }
    }

    public void setDistOrRoll(float f) {
        super.setDistOrRoll(f);
        if (this.channel != null && this.channel.attachedSource == this && this.field_5605 != null && this.field_5605.field_5539 != null) {
            if (this.attModel == 1) {
                AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4129, (float)f);
            } else {
                AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4129, (float)0.0f);
            }
            this.method_4889();
        }
    }

    public void setVelocity(float f, float f2, float f3) {
        super.setVelocity(f, f2, f3);
        this.field_5606 = BufferUtils.createFloatBuffer((int)3).put(new float[]{f, f2, f3});
        this.field_5606.flip();
        if (this.channel != null && this.channel.attachedSource == this && this.field_5605 != null && this.field_5605.field_5539 != null) {
            AL10.alSourcefv((int)this.field_5605.field_5539.get(0), (int)4102, (FloatBuffer)this.field_5606);
            this.method_4889();
        }
    }

    public void setPitch(float f) {
        super.setPitch(f);
        this.method_4888();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void play(Channel channel) {
        if (!this.active()) {
            if (this.toLoop) {
                this.toPlay = true;
            }
            return;
        }
        if (channel == null) {
            this.errorMessage("Unable to play source, because channel was null");
            return;
        }
        boolean bl = bl2 = this.channel != channel;
        if (this.channel != null && this.channel.attachedSource != this) {
            boolean bl2 = true;
        }
        boolean bl3 = this.paused();
        super.play(channel);
        this.field_5605 = (class_1137)this.channel;
        if (bl2) {
            this.setPosition(this.position.x, this.position.y, this.position.z);
            this.method_4888();
            if (this.field_5605 != null && this.field_5605.field_5539 != null) {
                if (class_1138.method_4831()) {
                    AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4099, (float)this.pitch);
                    this.method_4889();
                }
                AL10.alSourcefv((int)this.field_5605.field_5539.get(0), (int)4100, (FloatBuffer)this.field_5604);
                this.method_4889();
                AL10.alSourcefv((int)this.field_5605.field_5539.get(0), (int)4102, (FloatBuffer)this.field_5606);
                this.method_4889();
                if (this.attModel == 1) {
                    AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4129, (float)this.distOrRoll);
                } else {
                    AL10.alSourcef((int)this.field_5605.field_5539.get(0), (int)4129, (float)0.0f);
                }
                this.method_4889();
                if (this.toLoop && !this.toStream) {
                    AL10.alSourcei((int)this.field_5605.field_5539.get(0), (int)4103, (int)1);
                } else {
                    AL10.alSourcei((int)this.field_5605.field_5539.get(0), (int)4103, (int)0);
                }
                this.method_4889();
            }
            if (!this.toStream) {
                if (this.field_5607 == null) {
                    this.errorMessage("No sound buffer to play");
                    return;
                }
                this.field_5605.method_4827(this.field_5607);
            }
        }
        if (!this.playing()) {
            if (this.toStream && !bl3) {
                int \u26032;
                if (this.codec == null) {
                    this.errorMessage("Decoder null in method 'play'");
                    return;
                }
                if (this.codec.getAudioFormat() == null) {
                    this.codec.initialize(this.filenameURL.getURL());
                }
                if ((audioFormat = this.codec.getAudioFormat()) == null) {
                    this.errorMessage("Audio Format null in method 'play'");
                    return;
                }
                if (audioFormat.getChannels() == 1) {
                    if (audioFormat.getSampleSizeInBits() == 8) {
                        \u26032 = 4352;
                    } else {
                        AudioFormat audioFormat;
                        if (audioFormat.getSampleSizeInBits() != 16) {
                            this.errorMessage("Illegal sample size in method 'play'");
                            return;
                        }
                        \u26032 = 4353;
                    }
                } else {
                    if (audioFormat.getChannels() != 2) {
                        this.errorMessage("Audio data neither mono nor stereo in method 'play'");
                        return;
                    }
                    if (audioFormat.getSampleSizeInBits() == 8) {
                        \u26032 = 4354;
                    } else {
                        if (audioFormat.getSampleSizeInBits() != 16) {
                            this.errorMessage("Illegal sample size in method 'play'");
                            return;
                        }
                        \u26032 = 4355;
                    }
                }
                this.field_5605.method_4828(\u26032, (int)audioFormat.getSampleRate());
                this.preLoad = true;
            }
            this.channel.play();
            if (this.pitch != 1.0f) {
                this.method_4888();
            }
        }
    }

    public boolean preLoad() {
        if (this.codec == null) {
            return false;
        }
        this.codec.initialize(this.filenameURL.getURL());
        LinkedList linkedList = Lists.newLinkedList();
        for (int i = 0; i < SoundSystemConfig.getNumberStreamingBuffers(); ++i) {
            this.soundBuffer = this.codec.read();
            if (this.soundBuffer == null || this.soundBuffer.audioData == null) break;
            linkedList.add(this.soundBuffer.audioData);
        }
        this.positionChanged();
        this.channel.preLoadBuffers(linkedList);
        this.preLoad = false;
        return true;
    }

    private void method_4890() {
        this.field_5604 = BufferUtils.createFloatBuffer((int)3).put(new float[]{this.position.x, this.position.y, this.position.z});
        this.field_5606 = BufferUtils.createFloatBuffer((int)3).put(new float[]{this.velocity.x, this.velocity.y, this.velocity.z});
        this.field_5604.flip();
        this.field_5606.flip();
        this.positionChanged();
    }

    private void method_4891() {
        if (this.field_5603 != null) {
            double d = this.position.x - this.field_5603.get(0);
            \u2603 = this.position.y - this.field_5603.get(1);
            \u2603 = this.position.z - this.field_5603.get(2);
            this.distanceFromListener = (float)Math.sqrt(d * d + \u2603 * \u2603 + \u2603 * \u2603);
        }
    }

    private void method_4892() {
        if (this.attModel == 2) {
            this.gain = this.distanceFromListener <= 0.0f ? 1.0f : (this.distanceFromListener >= this.distOrRoll ? 0.0f : 1.0f - this.distanceFromListener / this.distOrRoll);
            if (this.gain > 1.0f) {
                this.gain = 1.0f;
            }
            if (this.gain < 0.0f) {
                this.gain = 0.0f;
            }
        } else {
            this.gain = 1.0f;
        }
    }

    private boolean method_4889() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter.");
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter.");
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value.");
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call.");
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory.");
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred.");
        return true;
    }
}

