/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_4013;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_1863
implements class_4013 {
    private static final Logger field_9027 = LogManager.getLogger();
    public static final int field_9026 = "recipes/".length();
    public static final int field_9025 = ".json".length();
    private final Map<class_3956<?>, Map<class_2960, class_1860<?>>> field_9023 = class_156.method_654(Maps.newHashMap(), class_1863::method_17719);
    private boolean field_9024;

    @Override
    public void method_14491(class_3300 class_33002) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        this.field_9024 = false;
        class_1863.method_17719(this.field_9023);
        for (class_2960 class_29602 : class_33002.method_14488("recipes", string -> string.endsWith(".json"))) {
            String string2 = class_29602.method_12832();
            class_2960 \u26032 = new class_2960(class_29602.method_12836(), string2.substring(field_9026, string2.length() - field_9025));
            try {
                class_3298 class_32982 = class_33002.method_14486(class_29602);
                Throwable throwable = null;
                try {
                    JsonObject jsonObject = class_3518.method_15284(gson, IOUtils.toString((InputStream)class_32982.method_14482(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (jsonObject == null) {
                        field_9027.error("Couldn't load recipe {} as it's null or empty", (Object)\u26032);
                        continue;
                    }
                    this.method_8125(class_1863.method_17720(\u26032, jsonObject));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (class_32982 == null) continue;
                    if (throwable != null) {
                        try {
                            class_32982.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    class_32982.close();
                }
            }
            catch (JsonParseException | IllegalArgumentException throwable) {
                field_9027.error("Parsing error loading recipe {}", (Object)\u26032, (Object)throwable);
                this.field_9024 = true;
            }
            catch (IOException iOException) {
                field_9027.error("Couldn't read custom advancement {} from {}", (Object)\u26032, (Object)class_29602, (Object)iOException);
                this.field_9024 = true;
            }
        }
        field_9027.info("Loaded {} recipes", (Object)this.field_9023.size());
    }

    public void method_8125(class_1860<?> class_18602) {
        Map<class_2960, class_1860<?>> map = this.field_9023.get(class_18602.method_17716());
        if (map.containsKey(class_18602.method_8114())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + class_18602.method_8114());
        }
        map.put(class_18602.method_8114(), class_18602);
    }

    public <C extends class_1263, T extends class_1860<C>> Optional<T> method_8132(class_3956<T> class_39562, C c, class_1937 class_19372) {
        return this.method_17717(class_39562).values().stream().flatMap(class_18602 -> class_156.method_17815(class_39562.method_17725(class_18602, class_19372, c))).findFirst();
    }

    public <C extends class_1263, T extends class_1860<C>> List<T> method_17877(class_3956<T> class_39562, C c, class_1937 class_19372) {
        return this.method_17717(class_39562).values().stream().flatMap(class_18602 -> class_156.method_17815(class_39562.method_17725(class_18602, class_19372, c))).sorted(Comparator.comparing(class_18602 -> class_18602.method_8110().method_7922())).collect(Collectors.toList());
    }

    private <C extends class_1263, T extends class_1860<C>> Map<class_2960, class_1860<C>> method_17717(class_3956<T> class_39562) {
        return this.field_9023.getOrDefault(class_39562, Maps.newHashMap());
    }

    public <C extends class_1263, T extends class_1860<C>> class_2371<class_1799> method_8128(class_3956<T> class_39562, C c, class_1937 class_19372) {
        Optional<T> optional = this.method_8132(class_39562, c, class_19372);
        if (optional.isPresent()) {
            return ((class_1860)optional.get()).method_8111(c);
        }
        class_2371<class_1799> \u26032 = class_2371.method_10213(c.method_5439(), class_1799.field_8037);
        for (int i = 0; i < \u26032.size(); ++i) {
            \u26032.set(i, c.method_5438(i));
        }
        return \u26032;
    }

    public Optional<? extends class_1860<?>> method_8130(class_2960 class_29602) {
        return this.field_9023.values().stream().map(map -> (class_1860)map.get(class_29602)).filter(Objects::nonNull).findFirst();
    }

    public Collection<class_1860<?>> method_8126() {
        return this.field_9023.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
    }

    public Stream<class_2960> method_8127() {
        return this.field_9023.values().stream().flatMap(map -> map.keySet().stream());
    }

    public void method_8133() {
        class_1863.method_17719(this.field_9023);
    }

    public static class_1860<?> method_17720(class_2960 class_29602, JsonObject jsonObject) {
        String string = class_3518.method_15265(jsonObject, "type");
        return class_2378.field_17598.method_17966(new class_2960(string)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + string + "'")).method_8121(class_29602, jsonObject);
    }

    private static void method_17719(Map<class_3956<?>, Map<class_2960, class_1860<?>>> map) {
        map.clear();
        for (class_3956 class_39562 : class_2378.field_17597) {
            map.put(class_39562, Maps.newHashMap());
        }
    }
}

