/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.class_24;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2588;
import net.minecraft.class_29;
import net.minecraft.class_31;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_3536;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_32 {
    private static final Logger field_17665 = LogManager.getLogger();
    private static final DateTimeFormatter field_200 = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Path field_17666;
    private final Path field_17667;
    private final DataFixer field_17668;

    public class_32(Path path, Path path2, DataFixer dataFixer) {
        this.field_17668 = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_17666 = path;
        this.field_17667 = path2;
    }

    public String method_232() {
        return "Anvil";
    }

    public List<class_34> method_235() throws class_33 {
        if (!Files.isDirectory(this.field_17666, new LinkOption[0])) {
            throw new class_33(new class_2588("selectWorld.load_folder_access", new Object[0]).getString());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (File file : \u2603 = this.field_17666.toFile().listFiles()) {
            if (!file.isDirectory() || (\u2603 = this.method_231(\u2603 = file.getName())) == null || \u2603.method_168() != 19132 && \u2603.method_168() != 19133) continue;
            boolean bl = \u2603.method_168() != this.method_17931();
            String \u26032 = \u2603.method_150();
            if (StringUtils.isEmpty((CharSequence)\u26032)) {
                \u26032 = \u2603;
            }
            long \u26033 = 0L;
            arrayList.add(new class_34(\u2603, \u2603, \u26032, 0L, bl));
        }
        return arrayList;
    }

    private int method_17931() {
        return 19133;
    }

    public class_29 method_242(String string, @Nullable MinecraftServer minecraftServer) {
        return class_32.method_17929(this.field_17666, this.field_17668, string, minecraftServer);
    }

    protected static class_29 method_17929(Path path, DataFixer dataFixer, String string, @Nullable MinecraftServer minecraftServer) {
        return new class_29(path.toFile(), string, minecraftServer, dataFixer);
    }

    public boolean method_244(String string) {
        class_31 class_3180 = this.method_231(string);
        return class_3180 != null && class_3180.method_168() != this.method_17931();
    }

    public boolean method_17927(String string, class_3536 class_35362) {
        return class_24.method_234(this.field_17666, this.field_17668, string, class_35362);
    }

    @Nullable
    public class_31 method_231(String string) {
        return class_32.method_17928(this.field_17666, this.field_17668, string);
    }

    @Nullable
    protected static class_31 method_17928(Path path, DataFixer dataFixer, String string) {
        File file = new File(path.toFile(), string);
        if (!file.exists()) {
            return null;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists() && (\u2603 = class_32.method_17926(\u2603, dataFixer)) != null) {
            return \u2603;
        }
        \u2603 = new File(file, "level.dat_old");
        if (\u2603.exists()) {
            return class_32.method_17926(\u2603, dataFixer);
        }
        return null;
    }

    @Nullable
    public static class_31 method_17926(File file, DataFixer dataFixer) {
        try {
            class_2487 class_24872 = class_2507.method_10629(new FileInputStream(file));
            \u2603 = class_24872.method_10562("Data");
            \u2603 = \u2603.method_10573("Player", 10) ? \u2603.method_10562("Player") : null;
            \u2603.method_10551("Player");
            int \u26032 = \u2603.method_10573("DataVersion", 99) ? \u2603.method_10550("DataVersion") : -1;
            return new class_31(class_2512.method_10688(dataFixer, (DSL.TypeReference)DataFixTypes.LEVEL, \u2603, \u26032), dataFixer, \u26032, \u2603);
        }
        catch (Exception exception) {
            field_17665.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    public void method_241(String string, String string2) {
        File file = new File(this.field_17666.toFile(), string);
        if (!file.exists()) {
            return;
        }
        \u2603 = new File(file, "level.dat");
        if (\u2603.exists()) {
            try {
                class_2487 class_24872 = class_2507.method_10629(new FileInputStream(\u2603));
                \u2603 = class_24872.method_10562("Data");
                \u2603.method_10582("LevelName", string2);
                class_2507.method_10634(class_24872, new FileOutputStream(\u2603));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean method_240(String string) {
        File file = new File(this.field_17666.toFile(), string);
        if (file.exists()) {
            return false;
        }
        try {
            file.mkdir();
            file.delete();
        }
        catch (Throwable \u26032) {
            field_17665.warn("Couldn't make new level", \u26032);
            return false;
        }
        return true;
    }

    public boolean method_233(String string) {
        File file = new File(this.field_17666.toFile(), string);
        if (!file.exists()) {
            return true;
        }
        field_17665.info("Deleting level {}", (Object)string);
        for (int i = 1; i <= 5; ++i) {
            field_17665.info("Attempt {}...", (Object)i);
            if (class_32.method_17930(file.listFiles())) break;
            field_17665.warn("Unsuccessful in deleting contents.");
            if (i >= 5) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file.delete();
    }

    private static boolean method_17930(File[] fileArray) {
        for (File file : fileArray) {
            field_17665.debug("Deleting {}", (Object)file);
            if (file.isDirectory() && !class_32.method_17930(file.listFiles())) {
                field_17665.warn("Couldn't delete directory {}", (Object)file);
                return false;
            }
            if (file.delete()) continue;
            field_17665.warn("Couldn't delete file {}", (Object)file);
            return false;
        }
        return true;
    }

    public boolean method_230(String string) {
        return Files.isDirectory(this.field_17666.resolve(string), new LinkOption[0]);
    }

    public File method_239(String string, String string2) {
        return this.field_17666.resolve(string).resolve(string2).toFile();
    }

    private Path method_243(String string) {
        return this.field_17666.resolve(string);
    }

    public Path method_236() {
        return this.field_17667;
    }

    public long method_237(String string) throws IOException {
        final Path path = this.method_243(string);
        String \u26032 = LocalDateTime.now().format(field_200) + "_" + string;
        int \u26033 = 0;
        \u2603 = this.method_236();
        try {
            Files.createDirectories(Files.exists(\u2603, new LinkOption[0]) ? \u2603.toRealPath(new LinkOption[0]) : \u2603, new FileAttribute[0]);
        }
        catch (IOException \u26034) {
            throw new RuntimeException(\u26034);
        }
        while (Files.exists(\u2603 = \u2603.resolve(\u26032 + (\u26033++ > 0 ? "_" + \u26033 : "") + ".zip"), new LinkOption[0])) {
        }
        try (final ZipOutputStream \u26035 = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(\u2603.toFile())));){
            \u2603 = Paths.get(string, new String[0]);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult method_246(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                    String string = \u2603.resolve(path.relativize(path2)).toString().replace('\\', '/');
                    ZipEntry \u26032 = new ZipEntry(string);
                    \u26035.putNextEntry(\u26032);
                    com.google.common.io.Files.asByteSource((File)path2.toFile()).copyTo((OutputStream)\u26035);
                    \u26035.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.method_246((Path)object, basicFileAttributes);
                }
            });
        }
        return Files.size(\u2603);
    }
}

