/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.IItemRegisterer;
import me.shedaniel.rei.api.IPluginDisabler;
import me.shedaniel.rei.api.IRecipePlugin;
import me.shedaniel.rei.client.ConfigHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.ItemListHelper;
import me.shedaniel.rei.client.RecipeHelper;
import me.shedaniel.rei.plugin.DefaultPlugin;
import me.shedaniel.rei.plugin.PluginManager;
import me.shedaniel.rei.update.UpdateChecker;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.loader.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoughlyEnoughItemsCore
implements ClientModInitializer,
ModInitializer {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"REI");
    public static final class_2960 DELETE_ITEMS_PACKET = new class_2960("roughlyenoughitems", "delete_item");
    public static final class_2960 CREATE_ITEMS_PACKET = new class_2960("roughlyenoughitems", "create_item");
    private static final RecipeHelper RECIPE_HELPER = new RecipeHelper();
    private static final PluginManager PLUGIN_MANAGER = new PluginManager();
    private static final ItemListHelper ITEM_LIST_HELPER = new ItemListHelper();
    private static final Map<class_2960, IRecipePlugin> plugins = Maps.newHashMap();
    private static ConfigHelper configHelper;

    public static RecipeHelper getRecipeHelper() {
        return RECIPE_HELPER;
    }

    public static ConfigHelper getConfigHelper() {
        return configHelper;
    }

    public static IItemRegisterer getItemRegisterer() {
        return ITEM_LIST_HELPER;
    }

    public static IPluginDisabler getPluginDisabler() {
        return PLUGIN_MANAGER;
    }

    public static IRecipePlugin registerPlugin(class_2960 identifier, IRecipePlugin plugin) {
        plugins.put(identifier, plugin);
        LOGGER.info("REI: Registered plugin %s from %s", (Object)identifier.toString(), (Object)plugin.getClass().getSimpleName());
        plugin.onFirstLoad(RoughlyEnoughItemsCore.getPluginDisabler());
        return plugin;
    }

    public static List<IRecipePlugin> getPlugins() {
        return new LinkedList<IRecipePlugin>(plugins.values());
    }

    public static class_2960 getPluginIdentifier(IRecipePlugin plugin) {
        for (class_2960 identifier : plugins.keySet()) {
            if (!plugins.get(identifier).equals(plugin)) continue;
            return identifier;
        }
        return null;
    }

    public void onInitializeClient() {
        configHelper = new ConfigHelper();
        if (!FabricLoader.INSTANCE.getModContainers().stream().map(modContainer -> modContainer.getInfo().getId()).anyMatch(s -> s.equalsIgnoreCase("pluginloader"))) {
            LOGGER.warn("REI: Plugin Loader is not loaded! Please consider installing https://minecraft.curseforge.com/projects/pluginloader for REI plugin compatibility!");
            RoughlyEnoughItemsCore.registerPlugin(new class_2960("roughlyenoughitems", "default_plugin"), new DefaultPlugin());
        }
        ClientTickCallback.EVENT.register(GuiHelper::onTick);
        if (RoughlyEnoughItemsCore.getConfigHelper().checkUpdates()) {
            ClientTickCallback.EVENT.register(UpdateChecker::onTick);
        }
        new UpdateChecker().onInitializeClient();
    }

    public void onInitialize() {
        this.registerFabricPackets();
    }

    private void registerFabricPackets() {
        ServerSidePacketRegistry.INSTANCE.register(DELETE_ITEMS_PACKET, (packetContext, packetByteBuf) -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (!player.field_7514.method_7399().method_7960()) {
                player.field_7514.method_7396(class_1799.field_8037);
            }
        });
        ServerSidePacketRegistry.INSTANCE.register(CREATE_ITEMS_PACKET, (packetContext, packetByteBuf) -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            class_1799 stack = packetByteBuf.method_10819();
            if (player.field_7514.method_7394(stack.method_7972())) {
                player.method_14254((class_2561)new class_2585(class_1074.method_4662((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", stack.method_7972().method_7964().method_10863()).replaceAll("\\{item_count}", stack.method_7972().method_7947() + "").replaceAll("\\{player_name}", player.method_5820())), class_2556.field_11735);
            } else {
                player.method_14254((class_2561)new class_2588("text.rei.failed_cheat_items", new Object[0]), class_2556.field_11735);
            }
        });
    }
}

