/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.client.REIConfig;
import me.shedaniel.rei.client.REIItemListOrdering;
import net.fabricmc.loader.FabricLoader;

public class ConfigHelper {
    private final File configFile = new File(FabricLoader.INSTANCE.getConfigDirectory(), "rei.json");
    private REIConfig config;
    private boolean craftableOnly = false;

    public ConfigHelper() {
        try {
            this.loadConfig();
            RoughlyEnoughItemsCore.LOGGER.info("REI: Config is loaded.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() throws IOException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() && !this.configFile.createNewFile()) {
            RoughlyEnoughItemsCore.LOGGER.error("REI: Failed to save config! Overwriting with default config.");
            this.config = new REIConfig();
            return;
        }
        try (FileWriter writer = new FileWriter(this.configFile, false);){
            REIConfig.GSON.toJson((Object)this.config, (Appendable)writer);
        }
    }

    public void loadConfig() throws IOException {
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            this.config = new REIConfig();
            this.saveConfig();
            return;
        }
        boolean failed = false;
        try {
            this.config = (REIConfig)REIConfig.GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(this.configFile.toPath(), new OpenOption[0])), REIConfig.class);
        }
        catch (Exception e) {
            failed = true;
        }
        if (failed || this.config == null) {
            RoughlyEnoughItemsCore.LOGGER.error("REI: Failed to load config! Overwriting with default config.");
            this.config = new REIConfig();
        }
        this.saveConfig();
    }

    public REIItemListOrdering getItemListOrdering() {
        return this.config.itemListOrdering;
    }

    public void setItemListOrdering(REIItemListOrdering ordering) {
        this.config.itemListOrdering = ordering;
    }

    public boolean isAscending() {
        return this.config.isAscending;
    }

    public void setAscending(boolean ascending) {
        this.config.isAscending = ascending;
    }

    public boolean craftableOnly() {
        return this.craftableOnly && this.config.enableCraftableOnlyButton;
    }

    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    public boolean showCraftableOnlyButton() {
        return this.config.enableCraftableOnlyButton;
    }

    public void setShowCraftableOnlyButton(boolean enableCraftableOnlyButton) {
        this.config.enableCraftableOnlyButton = enableCraftableOnlyButton;
    }

    public String getGiveCommandPrefix() {
        return this.config.giveCommandPrefix;
    }

    public boolean sideSearchField() {
        return this.config.sideSearchField;
    }

    public void setSideSearchField(boolean sideSearchField) {
        this.config.sideSearchField = sideSearchField;
    }

    public boolean checkUpdates() {
        return this.config.checkUpdates;
    }

    public void setCheckUpdates(boolean checkUpdates) {
        this.config.checkUpdates = checkUpdates;
    }

    public boolean isMirrorItemPanel() {
        return this.config.mirrorItemPanel;
    }

    public void setMirrorItemPanel(boolean mirrorItemPanel) {
        this.config.mirrorItemPanel = mirrorItemPanel;
    }

    public boolean isLoadingDefaultPlugin() {
        return this.config.loadDefaultPlugin;
    }

    public void setLoadingDefaultPlugin(boolean loadDefaultPlugin) {
        this.config.loadDefaultPlugin = loadDefaultPlugin;
    }
}

