/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.IPluginDisabler;
import me.shedaniel.rei.api.IRecipeCategory;
import me.shedaniel.rei.api.IRecipeDisplay;
import me.shedaniel.rei.api.IRecipePlugin;
import me.shedaniel.rei.api.PluginFunction;
import me.shedaniel.rei.api.SpeedCraftAreaSupplier;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2960;

public class RecipeHelper {
    private final Map<class_2960, List<IRecipeDisplay>> recipeCategoryListMap = Maps.newHashMap();
    private final List<IRecipeCategory> categories = Lists.newArrayList();
    private final Map<class_2960, SpeedCraftAreaSupplier> speedCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<class_2960, List<SpeedCraftFunctional>> speedCraftFunctionalMap = Maps.newHashMap();
    private class_1863 recipeManager;

    public static RecipeHelper getInstance() {
        return RoughlyEnoughItemsCore.getRecipeHelper();
    }

    public List<class_1799> findCraftableByItems(List<class_1799> inventoryItems) {
        ArrayList<class_1799> craftables = new ArrayList<class_1799>();
        for (List<IRecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (IRecipeDisplay recipeDisplay : value) {
                int slotsCraftable = 0;
                List<List<class_1799>> requiredInput = recipeDisplay.getRequiredItems();
                block2: for (List<class_1799> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    boolean slotDone = false;
                    for (class_1799 possibleType : inventoryItems) {
                        for (class_1799 slotPossible : slot) {
                            if (!class_1799.method_7984((class_1799)slotPossible, (class_1799)possibleType)) continue;
                            ++slotsCraftable;
                            slotDone = true;
                            break;
                        }
                        if (!slotDone) continue;
                        continue block2;
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredItems().size()) continue;
                craftables.addAll(recipeDisplay.getOutput());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    public void registerCategory(IRecipeCategory category) {
        this.categories.add(category);
        this.recipeCategoryListMap.put(category.getIdentifier(), Lists.newLinkedList());
    }

    public void registerDisplay(class_2960 categoryIdentifier, IRecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCategoryListMap.get(categoryIdentifier).add(display);
    }

    public Map<IRecipeCategory, List<IRecipeDisplay>> getRecipesFor(class_1799 stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<class_2960, List<IRecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            IRecipeCategory category2 = this.getCategory(entry.getKey());
            for (IRecipeDisplay recipeDisplay : entry.getValue()) {
                for (class_1799 outputStack : recipeDisplay.getOutput()) {
                    if (!(category2.checkTags() ? class_1799.method_7973((class_1799)stack, (class_1799)outputStack) : class_1799.method_7984((class_1799)stack, (class_1799)outputStack))) continue;
                    ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                }
            }
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, categoriesMap.get(category.getIdentifier()));
            }
        });
        return recipeCategoryListMap;
    }

    private IRecipeCategory getCategory(class_2960 identifier) {
        return this.categories.stream().filter(category -> category.getIdentifier().equals((Object)identifier)).findFirst().orElse(null);
    }

    public class_1863 getRecipeManager() {
        return this.recipeManager;
    }

    public Map<IRecipeCategory, List<IRecipeDisplay>> getUsagesFor(class_1799 stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<class_2960, List<IRecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            IRecipeCategory category2 = this.getCategory(entry.getKey());
            block1: for (IRecipeDisplay recipeDisplay : entry.getValue()) {
                boolean found = false;
                for (List<class_1799> input : recipeDisplay.getInput()) {
                    for (class_1799 itemStack : input) {
                        if (!(category2.checkTags() ? class_1799.method_7973((class_1799)itemStack, (class_1799)stack) : class_1799.method_7984((class_1799)itemStack, (class_1799)stack))) continue;
                        ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, categoriesMap.get(category.getIdentifier()));
            }
        });
        return recipeCategoryListMap;
    }

    public List<IRecipeCategory> getCategories() {
        return new LinkedList<IRecipeCategory>(this.categories);
    }

    public SpeedCraftAreaSupplier getSpeedCraftButtonArea(IRecipeCategory category) {
        if (!this.speedCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10);
        }
        return this.speedCraftAreaSupplierMap.get(category.getIdentifier());
    }

    public void registerSpeedCraftButtonArea(class_2960 category, SpeedCraftAreaSupplier rectangle) {
        this.speedCraftAreaSupplierMap.put(category, rectangle);
    }

    public List<SpeedCraftFunctional> getSpeedCraftFunctional(IRecipeCategory category) {
        if (this.speedCraftFunctionalMap.get(category.getIdentifier()) == null) {
            return Lists.newArrayList();
        }
        return this.speedCraftFunctionalMap.get(category.getIdentifier());
    }

    public void registerSpeedCraftFunctional(class_2960 category, SpeedCraftFunctional functional) {
        LinkedList list = this.speedCraftFunctionalMap.containsKey(category) ? new LinkedList(this.speedCraftFunctionalMap.get(category)) : Lists.newLinkedList();
        list.add(functional);
        this.speedCraftFunctionalMap.put(category, list);
    }

    public void recipesLoaded(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.speedCraftAreaSupplierMap.clear();
        this.speedCraftFunctionalMap.clear();
        LinkedList<IRecipePlugin> plugins = new LinkedList<IRecipePlugin>(RoughlyEnoughItemsCore.getPlugins());
        plugins.sort((first, second) -> second.getPriority() - first.getPriority());
        RoughlyEnoughItemsCore.LOGGER.info("Loading %d REI plugins: %s", (Object)plugins.size(), (Object)String.join((CharSequence)", ", plugins.stream().map(plugin -> {
            class_2960 identifier = RoughlyEnoughItemsCore.getPluginIdentifier(plugin);
            return identifier == null ? "NULL" : identifier.toString();
        }).collect(Collectors.toList())));
        Collections.reverse(plugins);
        RoughlyEnoughItemsCore.getItemRegisterer().getModifiableItemList().clear();
        IPluginDisabler pluginDisabler = RoughlyEnoughItemsCore.getPluginDisabler();
        plugins.forEach(plugin -> {
            class_2960 identifier = RoughlyEnoughItemsCore.getPluginIdentifier(plugin);
            if (identifier == null) {
                identifier = new class_2960("null");
            }
            if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_ITEMS)) {
                plugin.registerItems(RoughlyEnoughItemsCore.getItemRegisterer());
            }
            if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_CATEGORIES)) {
                plugin.registerPluginCategories(this);
            }
            if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_RECIPE_DISPLAYS)) {
                plugin.registerRecipeDisplays(this);
            }
            if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_SPEED_CRAFT)) {
                plugin.registerSpeedCraft(this);
            }
        });
        RoughlyEnoughItemsCore.LOGGER.info("Registered REI Categories: " + String.join((CharSequence)", ", this.categories.stream().map(category -> category.getCategoryName()).collect(Collectors.toList())));
    }
}

