/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.gui.credits.CreditsScreen;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CraftableToggleButtonWidget;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.ItemSlotWidget;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.RecipeViewingWidgetScreen;
import me.shedaniel.rei.gui.widget.TextFieldWidget;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class ContainerScreenOverlay
extends class_362 {
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    public static String searchTerm = "";
    private static int page = 0;
    private static ItemListOverlay itemListOverlay;
    private final List<IWidget> widgets = Lists.newArrayList();
    private Rectangle rectangle;
    private class_1041 window;
    private ButtonWidget buttonLeft;
    private ButtonWidget buttonRight;
    private int lastLeft;

    public void onInitialized() {
        this.widgets.clear();
        this.window = class_310.method_1551().field_1704;
        this.rectangle = this.calculateBoundary();
        this.lastLeft = this.getLeft();
        itemListOverlay = new ItemListOverlay(page);
        this.widgets.add(itemListOverlay);
        itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
        this.buttonLeft = new ButtonWidget(this.rectangle.x, this.rectangle.y + 5, 16, 16, "<"){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                page--;
                if (page < 0) {
                    page = ContainerScreenOverlay.this.getTotalPage();
                }
                itemListOverlay.updateList(ContainerScreenOverlay.this.getItemListArea(), page, searchTerm);
            }
        };
        this.widgets.add(this.buttonLeft);
        this.buttonRight = new ButtonWidget(this.rectangle.x + this.rectangle.width - 18, this.rectangle.y + 5, 16, 16, ">"){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                page++;
                if (page > ContainerScreenOverlay.this.getTotalPage()) {
                    page = 0;
                }
                itemListOverlay.updateList(ContainerScreenOverlay.this.getItemListArea(), page, searchTerm);
            }
        };
        this.widgets.add(this.buttonRight);
        page = class_3532.method_15340((int)page, (int)0, (int)this.getTotalPage());
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigHelper().isMirrorItemPanel() ? this.window.method_4486() - 50 : 10, 10, 40, 20, ""){

            @Override
            public void draw(int int_1, int int_2, float float_1) {
                this.text = ContainerScreenOverlay.this.getCheatModeText();
                super.draw(int_1, int_2, float_1);
            }

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                ClientHelper.setCheating(!ClientHelper.isCheating());
            }
        });
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigHelper().isMirrorItemPanel() ? this.window.method_4486() - 50 : 10, 35, 40, 20, class_1074.method_4662((String)"text.rei.config", (Object[])new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                ClientHelper.openConfigWindow((class_437)GuiHelper.getLastContainerScreen());
            }
        });
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsCore.getConfigHelper().isMirrorItemPanel() ? this.window.method_4486() - 50 : 10, this.window.method_4502() - 30, 40, 20, class_1074.method_4662((String)"text.rei.credits", (Object[])new Object[0])){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                class_310.method_1551().method_1507((class_437)new CreditsScreen(GuiHelper.getLastContainerScreen()));
            }
        });
        this.widgets.add(new LabelWidget(this.rectangle.x + this.rectangle.width / 2, this.rectangle.y + 10, ""){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                page = class_3532.method_15340((int)page, (int)0, (int)ContainerScreenOverlay.this.getTotalPage());
                this.text = String.format("%s/%s", page + 1, ContainerScreenOverlay.this.getTotalPage() + 1);
                super.draw(mouseX, mouseY, partialTicks);
            }
        });
        if (GuiHelper.searchField == null) {
            GuiHelper.searchField = new TextFieldWidget(0, 0, 0, 0){

                @Override
                public boolean method_16807(double double_1, double double_2, int int_1) {
                    if (this.isVisible() && this.getBounds().contains(double_1, double_2) && int_1 == 1) {
                        this.setText("");
                        return true;
                    }
                    return super.method_16807(double_1, double_2, int_1);
                }
            };
        }
        GuiHelper.searchField.setChangedListener(s -> {
            searchTerm = s;
            itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
        });
        GuiHelper.searchField.setBounds(this.getTextFieldArea());
        this.widgets.add(GuiHelper.searchField);
        GuiHelper.searchField.setText(searchTerm);
        if (RoughlyEnoughItemsCore.getConfigHelper().showCraftableOnlyButton()) {
            this.widgets.add(new CraftableToggleButtonWidget(this.getCraftableToggleArea()){

                @Override
                public void onPressed(int button, double mouseX, double mouseY) {
                    RoughlyEnoughItemsCore.getConfigHelper().toggleCraftableOnly();
                    itemListOverlay.updateList(ContainerScreenOverlay.this.getItemListArea(), page, searchTerm);
                }
            });
        }
        itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
    }

    private Rectangle getTextFieldArea() {
        int widthRemoved;
        int n = widthRemoved = RoughlyEnoughItemsCore.getConfigHelper().showCraftableOnlyButton() ? 22 : 0;
        if (RoughlyEnoughItemsCore.getConfigHelper().sideSearchField()) {
            return new Rectangle(this.rectangle.x + 2, this.window.method_4502() - 22, this.rectangle.width - 6 - widthRemoved, 18);
        }
        if (class_310.method_1551().field_1755 instanceof RecipeViewingWidgetScreen) {
            RecipeViewingWidgetScreen widget = (RecipeViewingWidgetScreen)class_310.method_1551().field_1755;
            return new Rectangle(widget.getBounds().x, this.window.method_4502() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        return new Rectangle(GuiHelper.getLastMixinContainerScreen().rei_getContainerLeft(), this.window.method_4502() - 22, GuiHelper.getLastMixinContainerScreen().rei_getContainerWidth() - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle searchBoxArea = this.getTextFieldArea();
        searchBoxArea.setLocation(searchBoxArea.x + searchBoxArea.width + 4, searchBoxArea.y - 1);
        searchBoxArea.setSize(20, 20);
        return searchBoxArea;
    }

    private String getCheatModeText() {
        return class_1074.method_4662((String)String.format("%s%s", "text.rei.", ClientHelper.isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    private Rectangle getItemListArea() {
        return new Rectangle(this.rectangle.x + 2, this.rectangle.y + 24, this.rectangle.width - 4, this.rectangle.height - (RoughlyEnoughItemsCore.getConfigHelper().sideSearchField() ? 49 : 27));
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public void drawOverlay(int mouseX, int mouseY, float partialTicks) {
        List<class_1799> currentStacks = ClientHelper.getInventoryItemsTypes();
        if (this.getLeft() != this.lastLeft) {
            this.onInitialized();
        } else if (RoughlyEnoughItemsCore.getConfigHelper().craftableOnly() && (!this.hasSameListContent(new LinkedList<class_1799>(GuiHelper.inventoryStacks), currentStacks) || currentStacks.size() != GuiHelper.inventoryStacks.size())) {
            GuiHelper.inventoryStacks = ClientHelper.getInventoryItemsTypes();
            itemListOverlay.updateList(this.getItemListArea(), page, searchTerm);
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_1450();
        this.draw(mouseX, mouseY, partialTicks);
        class_308.method_1450();
        QUEUED_TOOLTIPS.stream().filter(queuedTooltip -> queuedTooltip != null).forEach(queuedTooltip -> class_310.method_1551().field_1755.method_2211(queuedTooltip.text, queuedTooltip.mouse.x, queuedTooltip.mouse.y));
        QUEUED_TOOLTIPS.clear();
        class_308.method_1450();
    }

    private boolean hasSameListContent(List<class_1799> list1, List<class_1799> list2) {
        Collections.sort(list1, (itemStack, t1) -> itemStack.method_7964().method_10863().compareToIgnoreCase(t1.method_7964().method_10863()));
        Collections.sort(list2, (itemStack, t1) -> itemStack.method_7964().method_10863().compareToIgnoreCase(t1.method_7964().method_10863()));
        String lastString = String.join((CharSequence)"", list1.stream().map(itemStack -> itemStack.method_7964().method_10863()).collect(Collectors.toList()));
        String currentString = String.join((CharSequence)"", list2.stream().map(itemStack -> itemStack.method_7964().method_10863()).collect(Collectors.toList()));
        return lastString.equals(currentString);
    }

    public void addTooltip(QueuedTooltip queuedTooltip) {
        QUEUED_TOOLTIPS.add(queuedTooltip);
    }

    public void draw(int int_1, int int_2, float float_1) {
        if (!GuiHelper.isOverlayVisible()) {
            return;
        }
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.draw(int_1, int_2, float_1);
        });
        class_308.method_1450();
    }

    private Rectangle calculateBoundary() {
        if (!RoughlyEnoughItemsCore.getConfigHelper().isMirrorItemPanel()) {
            int startX = GuiHelper.getLastMixinContainerScreen().rei_getContainerLeft() + GuiHelper.getLastMixinContainerScreen().rei_getContainerWidth() + 10;
            int width = this.window.method_4486() - startX;
            if (class_310.method_1551().field_1755 instanceof RecipeViewingWidgetScreen) {
                RecipeViewingWidgetScreen widget = (RecipeViewingWidgetScreen)class_310.method_1551().field_1755;
                startX = widget.getBounds().x + widget.getBounds().width + 10;
                width = this.window.method_4486() - startX;
            }
            return new Rectangle(startX, 0, width, this.window.method_4502());
        }
        return new Rectangle(4, 0, this.getLeft() - 6, this.window.method_4502());
    }

    private int getLeft() {
        if (class_310.method_1551().field_1755 instanceof RecipeViewingWidgetScreen) {
            RecipeViewingWidgetScreen widget = (RecipeViewingWidgetScreen)class_310.method_1551().field_1755;
            return widget.getBounds().x;
        }
        if (class_310.method_1551().field_1724.method_3130().method_14887()) {
            return GuiHelper.getLastMixinContainerScreen().rei_getContainerLeft() - 147 - 30;
        }
        return GuiHelper.getLastMixinContainerScreen().rei_getContainerLeft();
    }

    private int getTotalPage() {
        return class_3532.method_15386((float)(itemListOverlay.getCurrentDisplayed().size() / itemListOverlay.getTotalSlotsPerPage()));
    }

    public boolean method_16802(double amount) {
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        if (this.rectangle.contains(ClientHelper.getMouseLocation())) {
            if (amount > 0.0 && this.buttonLeft.enabled) {
                this.buttonLeft.onPressed(0, 0.0, 0.0);
            } else if (amount < 0.0 && this.buttonRight.enabled) {
                this.buttonRight.onPressed(0, 0.0, 0.0);
            } else {
                return false;
            }
            return true;
        }
        for (IWidget widget : this.widgets) {
            if (!widget.method_16802(amount)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean method_16805(int int_1, int int_2, int int_3) {
        void var5_12;
        void var5_10;
        void var5_8;
        for (class_364 class_3642 : this.widgets) {
            if (!class_3642.method_16805(int_1, int_2, int_3)) continue;
            return true;
        }
        if (ClientHelper.HIDE.method_1417(int_1, int_2)) {
            GuiHelper.toggleOverlayVisible();
            return true;
        }
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        Point point = ClientHelper.getMouseLocation();
        Object var5_6 = null;
        for (IWidget widget : itemListOverlay.getListeners()) {
            if (!(widget instanceof ItemSlotWidget) || !((ItemSlotWidget)widget).isHighlighted(point.x, point.y)) continue;
            class_1799 class_17992 = ((ItemSlotWidget)widget).getCurrentStack();
            break;
        }
        if (var5_8 == null && class_310.method_1551().field_1755 instanceof RecipeViewingWidgetScreen) {
            RecipeViewingWidgetScreen recipeViewingWidget = (RecipeViewingWidgetScreen)class_310.method_1551().field_1755;
            for (class_364 entry : recipeViewingWidget.method_1968()) {
                if (!(entry instanceof ItemSlotWidget) || !((HighlightableWidget)entry).isHighlighted(point.x, point.y)) continue;
                class_1799 class_17993 = ((ItemSlotWidget)entry).getCurrentStack();
                break;
            }
        }
        if (var5_10 == null && class_310.method_1551().field_1755 instanceof class_465 && GuiHelper.getLastMixinContainerScreen().rei_getHoveredSlot() != null) {
            class_1799 class_17994 = GuiHelper.getLastMixinContainerScreen().rei_getHoveredSlot().method_7677();
        }
        if (var5_12 != null && !var5_12.method_7960()) {
            if (ClientHelper.RECIPE.method_1417(int_1, int_2)) {
                return ClientHelper.executeRecipeKeyBind(this, (class_1799)var5_12);
            }
            if (ClientHelper.USAGE.method_1417(int_1, int_2)) {
                return ClientHelper.executeUsageKeyBind(this, (class_1799)var5_12);
            }
        }
        return false;
    }

    public boolean method_16806(char char_1, int int_1) {
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        for (class_364 class_3642 : this.method_1968()) {
            if (!class_3642.method_16806(char_1, int_1)) continue;
            return true;
        }
        return super.method_16806(char_1, int_1);
    }

    protected List<? extends class_364> method_1968() {
        return this.widgets;
    }

    public boolean method_16807(double double_1, double double_2, int int_1) {
        if (!GuiHelper.isOverlayVisible()) {
            return false;
        }
        return super.method_16807(double_1, double_2, int_1);
    }
}

