/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.REIItemListOrdering;
import me.shedaniel.rei.client.RecipeHelper;
import me.shedaniel.rei.client.SearchArgument;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.ItemSlotWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1074;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

public class ItemListOverlay
extends class_332
implements IWidget {
    private List<IWidget> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;
    private List<class_1799> currentDisplayed = Lists.newArrayList();

    public ItemListOverlay(int page) {
        this.page = page;
    }

    public int getTotalSlotsPerPage() {
        return this.width * this.height;
    }

    @Override
    public void draw(int int_1, int int_2, float float_1) {
        this.widgets.forEach(widget -> widget.draw(int_1, int_2, float_1));
        class_746 player = class_310.method_1551().field_1724;
        if (this.rectangle.contains(ClientHelper.getMouseLocation()) && ClientHelper.isCheating() && !player.field_7514.method_7399().method_7960() && class_310.method_1551().method_1542()) {
            GuiHelper.getLastOverlay().addTooltip(new QueuedTooltip(ClientHelper.getMouseLocation(), Arrays.asList(class_1074.method_4662((String)"text.rei.delete_items", (Object[])new Object[0]))));
        }
    }

    public void updateList(Rectangle bounds, int page, String searchTerm) {
        int j;
        this.rectangle = bounds;
        this.widgets = Lists.newLinkedList();
        this.currentDisplayed = this.processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getItemRegisterer().getItemList(), GuiHelper.inventoryStacks);
        this.page = page;
        this.calculateListSize(this.rectangle);
        double startX = this.rectangle.getCenterX() - (double)(this.width * 9);
        double startY = this.rectangle.getCenterY() - (double)(this.height * 9);
        this.listArea = new Rectangle((int)startX, (int)startY, this.width * 18, this.height * 18);
        for (int i = 0; i < this.getTotalSlotsPerPage() && (j = i + page * this.getTotalSlotsPerPage()) < this.currentDisplayed.size(); ++i) {
            ItemSlotWidget slotWidget = new ItemSlotWidget((int)(startX + (double)(i % this.width * 18)), (int)(startY + (double)(class_3532.method_15375((float)(i / this.width)) * 18)), this.currentDisplayed.get(j), false, true){

                @Override
                protected void drawToolTip(class_1799 itemStack) {
                    class_746 player = class_310.method_1551().field_1724;
                    if (!ClientHelper.isCheating() || player.field_7514.method_7399().method_7960()) {
                        super.drawToolTip(itemStack);
                    }
                }

                @Override
                public boolean onMouseClick(int button, double mouseX, double mouseY) {
                    if (this.isHighlighted(mouseX, mouseY)) {
                        if (ClientHelper.isCheating()) {
                            if (this.getCurrentStack() != null && !this.getCurrentStack().method_7960()) {
                                class_1799 cheatedStack = this.getCurrentStack().method_7972();
                                cheatedStack.method_7939(button == 0 ? 1 : (button == 1 ? cheatedStack.method_7914() : cheatedStack.method_7947()));
                                return ClientHelper.tryCheatingStack(cheatedStack);
                            }
                        } else {
                            if (button == 0) {
                                return ClientHelper.executeRecipeKeyBind(GuiHelper.getLastOverlay(), this.getCurrentStack().method_7972());
                            }
                            if (button == 1) {
                                return ClientHelper.executeUsageKeyBind(GuiHelper.getLastOverlay(), this.getCurrentStack().method_7972());
                            }
                        }
                    }
                    return false;
                }
            };
            this.widgets.add(slotWidget);
        }
    }

    public List<class_1799> getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<class_1799> processSearchTerm(String searchTerm, List<class_1799> ol, List<class_1799> inventoryItems) {
        AbstractList workingItems;
        LinkedList<class_1799> os = new LinkedList<class_1799>(ol);
        ArrayList stacks = Lists.newArrayList();
        ArrayList finalStacks = Lists.newArrayList();
        LinkedList<class_1761> itemGroups = new LinkedList<class_1761>(Arrays.asList(class_1761.field_7921));
        itemGroups.add(null);
        REIItemListOrdering ordering = RoughlyEnoughItemsCore.getConfigHelper().getItemListOrdering();
        if (ordering != REIItemListOrdering.REGISTRY) {
            Collections.sort(os, (itemStack, t1) -> {
                if (ordering.equals((Object)REIItemListOrdering.NAME)) {
                    return itemStack.method_7964().method_10863().compareToIgnoreCase(t1.method_7964().method_10863());
                }
                if (ordering.equals((Object)REIItemListOrdering.ITEM_GROUPS)) {
                    return itemGroups.indexOf(itemStack.method_7909().method_7859()) - itemGroups.indexOf(t1.method_7909().method_7859());
                }
                return 0;
            });
        }
        if (!RoughlyEnoughItemsCore.getConfigHelper().isAscending()) {
            Collections.reverse(os);
        }
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            ArrayList arguments = Lists.newArrayList();
            Arrays.stream(StringUtils.split((String)s)).forEachOrdered(s1 -> {
                if (s1.startsWith("@-") || s1.startsWith("-@")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false));
                } else if (s1.startsWith("@")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true));
                } else if (s1.startsWith("#-") || s1.startsWith("-#")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false));
                } else if (s1.startsWith("#")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true));
                } else if (s1.startsWith("-")) {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false));
                } else {
                    arguments.add(new SearchArgument(SearchArgument.ArgumentType.TEXT, (String)s1, true));
                }
            });
            os.stream().filter(itemStack -> arguments.isEmpty() || this.filterItem((class_1799)itemStack, arguments)).forEachOrdered(stacks::add);
        });
        if (splitSearchTerm.length == 0) {
            stacks.addAll(os);
        }
        AbstractList abstractList = workingItems = RoughlyEnoughItemsCore.getConfigHelper().craftableOnly() && inventoryItems.size() > 0 ? new ArrayList() : new LinkedList<class_1799>(ol);
        if (RoughlyEnoughItemsCore.getConfigHelper().craftableOnly()) {
            RecipeHelper.getInstance().findCraftableByItems(inventoryItems).forEach(workingItems::add);
            workingItems.addAll(inventoryItems);
        }
        AbstractList finalWorkingItems = workingItems;
        finalStacks.addAll(stacks.stream().filter(itemStack -> {
            if (!RoughlyEnoughItemsCore.getConfigHelper().craftableOnly()) {
                return true;
            }
            for (class_1799 workingItem : finalWorkingItems) {
                if (!itemStack.method_7962(workingItem)) continue;
                return true;
            }
            return false;
        }).distinct().collect(Collectors.toList()));
        return finalStacks;
    }

    private boolean filterItem(class_1799 itemStack, List<SearchArgument> arguments) {
        String mod = ClientHelper.getModFromItemStack(itemStack);
        List toolTipsList = class_310.method_1551().field_1755.method_2239(itemStack);
        String toolTipsMixed = toolTipsList.stream().skip(1L).collect(Collectors.joining()).toLowerCase();
        String allMixed = Stream.of(itemStack.method_7964().method_10863(), toolTipsMixed).collect(Collectors.joining()).toLowerCase();
        for (SearchArgument searchArgument2 : arguments.stream().filter(searchArgument -> !searchArgument.isInclude()).collect(Collectors.toList())) {
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && mod.toLowerCase().contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && toolTipsMixed.contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (!searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || !allMixed.contains(searchArgument2.getText().toLowerCase())) continue;
            return false;
        }
        for (SearchArgument searchArgument2 : arguments.stream().filter(SearchArgument::isInclude).collect(Collectors.toList())) {
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && !mod.toLowerCase().contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && !toolTipsMixed.contains(searchArgument2.getText().toLowerCase())) {
                return false;
            }
            if (!searchArgument2.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || allMixed.contains(searchArgument2.getText().toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    @Override
    public boolean method_16807(double double_1, double double_2, int int_1) {
        if (this.rectangle.contains(double_1, double_2)) {
            class_746 player = class_310.method_1551().field_1724;
            if (ClientHelper.isCheating() && !player.field_7514.method_7399().method_7960() && class_310.method_1551().method_1542()) {
                ClientHelper.sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && class_310.method_1551().method_1542()) {
                return false;
            }
            for (IWidget widget : this.getListeners()) {
                if (!widget.method_16807(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<IWidget> getListeners() {
        return this.widgets;
    }
}

