/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_918;

public class ItemSlotWidget
extends class_332
implements HighlightableWidget {
    private static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<class_1799> itemList = new LinkedList<class_1799>();
    private boolean drawBackground;
    private boolean showToolTips;
    private boolean clickToMoreRecipes;
    private boolean drawHighlightedBackground;
    private int x;
    private int y;

    public ItemSlotWidget(int x, int y, class_1799 itemStack, boolean drawBackground, boolean showToolTips) {
        this(x, y, Arrays.asList(itemStack), drawBackground, showToolTips);
    }

    public ItemSlotWidget(int x, int y, List<class_1799> itemList, boolean drawBackground, boolean showToolTips) {
        this.itemList = itemList;
        this.drawBackground = drawBackground;
        this.showToolTips = showToolTips;
        this.x = x;
        this.y = y;
        this.clickToMoreRecipes = false;
        this.drawHighlightedBackground = true;
    }

    public void setDrawHighlightedBackground(boolean drawHighlightedBackground) {
        this.drawHighlightedBackground = drawHighlightedBackground;
    }

    public ItemSlotWidget(int x, int y, List<class_1799> itemList, boolean drawBackground, boolean showToolTips, boolean clickToMoreRecipes) {
        this(x, y, itemList, drawBackground, showToolTips);
        this.clickToMoreRecipes = clickToMoreRecipes;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    @Override
    public List<IWidget> getListeners() {
        return new ArrayList<IWidget>();
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        class_1799 itemStack = this.getCurrentStack();
        if (this.drawBackground) {
            class_310.method_1551().method_1531().method_4618(RECIPE_GUI);
            this.method_1788(this.x - 1, this.y - 1, 0, 222, 18, 18);
        }
        if (this.drawHighlightedBackground && this.isHighlighted(mouseX, mouseY)) {
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.method_1782(this.x, this.y, this.x + 16, this.y + 16, -2130706433, -2130706433);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
        }
        if (!itemStack.method_7960()) {
            class_308.method_1453();
            class_918 itemRenderer = class_310.method_1551().method_1480();
            itemRenderer.field_4730 = 200.0f;
            itemRenderer.method_4023(itemStack, this.x, this.y);
            itemRenderer.method_4022(class_310.method_1551().field_1772, itemStack, this.x, this.y, this.getItemCountOverlay(itemStack));
            itemRenderer.field_4730 = 0.0f;
        }
        if (!itemStack.method_7960() && this.isHighlighted(mouseX, mouseY) && this.showToolTips) {
            this.drawToolTip(itemStack);
        }
    }

    protected void drawToolTip(class_1799 itemStack) {
        List<String> toolTip = this.getTooltip(itemStack);
        GuiHelper.getLastOverlay().addTooltip(new QueuedTooltip(ClientHelper.getMouseLocation(), toolTip));
    }

    protected List<String> getTooltip(class_1799 itemStack) {
        String modString = "\u00a79\u00a7o" + ClientHelper.getModFromItemStack(itemStack);
        class_310 mc = class_310.method_1551();
        List<Object> toolTip = Lists.newArrayList();
        try {
            toolTip = class_310.method_1551().field_1755.method_2239(itemStack).stream().filter(s -> !s.equals(modString)).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            toolTip.add(itemStack.method_7964().method_10863());
        }
        toolTip.addAll(this.getExtraToolTips(itemStack));
        toolTip.add(modString);
        return toolTip;
    }

    protected List<String> getExtraToolTips(class_1799 stack) {
        return Lists.newArrayList();
    }

    protected String getItemCountOverlay(class_1799 currentStack) {
        return "";
    }

    public class_1799 getCurrentStack() {
        if (this.itemList.size() == 0) {
            return new class_1799((class_1935)class_1802.field_8162);
        }
        return this.itemList.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.itemList.size() / 1.0)));
    }

    public void setItemList(List<class_1799> itemList) {
        this.itemList = itemList;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x - 1, this.y - 1, 18, 18);
    }

    @Override
    public boolean onMouseClick(int button, double mouseX, double mouseY) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.getBounds().contains(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.executeRecipeKeyBind(GuiHelper.getLastOverlay(), this.getCurrentStack().method_7972());
            }
            if (button == 1) {
                return ClientHelper.executeUsageKeyBind(GuiHelper.getLastOverlay(), this.getCurrentStack().method_7972());
            }
        }
        return false;
    }
}

