/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.rei.api.IRecipeCategory;
import me.shedaniel.rei.api.IRecipeDisplay;
import me.shedaniel.rei.api.SpeedCraftAreaSupplier;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.ClientHelper;
import me.shedaniel.rei.client.GuiHelper;
import me.shedaniel.rei.client.RecipeHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.IWidget;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.SpeedCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class RecipeViewingWidgetScreen
extends class_437 {
    public static final class_2960 CHEST_GUI_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final class_2960 CREATIVE_INVENTORY_TABS = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    public final int guiWidth = 176;
    public final int guiHeight = 186;
    private List<IWidget> widgets;
    private List<TabWidget> tabs;
    private class_1041 window;
    private Rectangle bounds;
    private Map<IRecipeCategory, List<IRecipeDisplay>> categoriesMap;
    private List<IRecipeCategory> categories;
    private IRecipeCategory selectedCategory;
    private int page;
    private int categoryPages = 0;
    private ButtonWidget recipeBack;
    private ButtonWidget recipeNext;
    private ButtonWidget categoryBack;
    private ButtonWidget categoryNext;

    public RecipeViewingWidgetScreen(class_1041 window, Map<IRecipeCategory, List<IRecipeDisplay>> categoriesMap) {
        this.window = window;
        this.widgets = Lists.newArrayList();
        this.bounds = new Rectangle(window.method_4486() / 2 - 88, window.method_4502() / 2 - 93, 176, 186);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList();
        RecipeHelper.getInstance().getCategories().forEach(category -> {
            if (categoriesMap.containsKey(category)) {
                this.categories.add((IRecipeCategory)category);
            }
        });
        this.selectedCategory = this.categories.get(0);
        this.tabs = new ArrayList<TabWidget>();
    }

    public static SpeedCraftFunctional getSpeedCraftFunctionalByCategory(class_465 containerScreen, IRecipeCategory category) {
        for (SpeedCraftFunctional functional : RecipeHelper.getInstance().getSpeedCraftFunctional(category)) {
            for (Class aClass : functional.getFunctioningFor()) {
                if (!containerScreen.getClass().isAssignableFrom(aClass)) continue;
                return functional;
            }
        }
        return null;
    }

    public boolean method_16805(int int_1, int int_2, int int_3) {
        if ((int_1 == 256 || this.field_2563.field_1690.field_1822.method_1417(int_1, int_2)) && this.method_16890()) {
            class_310.method_1551().method_1507((class_437)GuiHelper.getLastContainerScreen());
            GuiHelper.getLastOverlay().onInitialized();
            return true;
        }
        for (class_364 listener : this.field_2557) {
            if (!listener.method_16805(int_1, int_2, int_3)) continue;
            return true;
        }
        return super.method_16805(int_1, int_2, int_3);
    }

    public boolean method_2222() {
        return false;
    }

    protected void method_2224() {
        super.method_2224();
        this.tabs.clear();
        this.widgets.clear();
        this.bounds = new Rectangle(this.window.method_4486() / 2 - 88, this.window.method_4502() / 2 - 93, 176, 186);
        this.categoryBack = new ButtonWidget((int)this.bounds.getX() + 5, (int)this.bounds.getY() + 5, 12, 12, "<"){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                int currentCategoryIndex = RecipeViewingWidgetScreen.this.categories.indexOf(RecipeViewingWidgetScreen.this.selectedCategory);
                if (--currentCategoryIndex < 0) {
                    currentCategoryIndex = RecipeViewingWidgetScreen.this.categories.size() - 1;
                }
                RecipeViewingWidgetScreen.this.selectedCategory = (IRecipeCategory)RecipeViewingWidgetScreen.this.categories.get(currentCategoryIndex);
                RecipeViewingWidgetScreen.this.categoryPages = class_3532.method_15357((double)((double)currentCategoryIndex / 6.0));
                RecipeViewingWidgetScreen.this.method_2224();
            }
        };
        this.widgets.add(this.categoryBack);
        this.categoryNext = new ButtonWidget((int)this.bounds.getX() + 159, (int)this.bounds.getY() + 5, 12, 12, ">"){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                int currentCategoryIndex = RecipeViewingWidgetScreen.this.categories.indexOf(RecipeViewingWidgetScreen.this.selectedCategory);
                if (++currentCategoryIndex >= RecipeViewingWidgetScreen.this.categories.size()) {
                    currentCategoryIndex = 0;
                }
                RecipeViewingWidgetScreen.this.selectedCategory = (IRecipeCategory)RecipeViewingWidgetScreen.this.categories.get(currentCategoryIndex);
                RecipeViewingWidgetScreen.this.categoryPages = class_3532.method_15357((double)((double)currentCategoryIndex / 6.0));
                RecipeViewingWidgetScreen.this.method_2224();
            }
        };
        this.widgets.add(this.categoryNext);
        this.categoryBack.enabled = this.categories.size() > 1;
        this.categoryNext.enabled = this.categories.size() > 1;
        this.recipeBack = new ButtonWidget((int)this.bounds.getX() + 5, (int)this.bounds.getY() + 21, 12, 12, "<"){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                RecipeViewingWidgetScreen.this.page--;
                if (RecipeViewingWidgetScreen.this.page < 0) {
                    RecipeViewingWidgetScreen.this.page = RecipeViewingWidgetScreen.this.getTotalPages(RecipeViewingWidgetScreen.this.selectedCategory) - 1;
                }
                RecipeViewingWidgetScreen.this.method_2224();
            }
        };
        this.widgets.add(this.recipeBack);
        this.recipeNext = new ButtonWidget((int)this.bounds.getX() + 159, (int)this.bounds.getY() + 21, 12, 12, ">"){

            @Override
            public void onPressed(int button, double mouseX, double mouseY) {
                RecipeViewingWidgetScreen.this.page++;
                if (RecipeViewingWidgetScreen.this.page >= RecipeViewingWidgetScreen.this.getTotalPages(RecipeViewingWidgetScreen.this.selectedCategory)) {
                    RecipeViewingWidgetScreen.this.page = 0;
                }
                RecipeViewingWidgetScreen.this.method_2224();
            }
        };
        this.widgets.add(this.recipeNext);
        this.recipeBack.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPage();
        this.recipeNext.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPage();
        this.widgets.add(new LabelWidget((int)this.bounds.getCenterX(), (int)this.bounds.getY() + 7, ""){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                this.text = RecipeViewingWidgetScreen.this.selectedCategory.getCategoryName();
                super.draw(mouseX, mouseY, partialTicks);
            }
        });
        this.widgets.add(new LabelWidget((int)this.bounds.getCenterX(), (int)this.bounds.getY() + 23, ""){

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                this.text = String.format("%d/%d", RecipeViewingWidgetScreen.this.page + 1, RecipeViewingWidgetScreen.this.getTotalPages(RecipeViewingWidgetScreen.this.selectedCategory));
                super.draw(mouseX, mouseY, partialTicks);
            }
        });
        for (int i = 0; i < 6; ++i) {
            int j = i + this.categoryPages * 6;
            if (this.categories.size() <= j) continue;
            TabWidget tab = new TabWidget(i, this, new Rectangle(this.bounds.x + 4 + 28 * i, this.bounds.y - 28, 28, 28)){

                @Override
                public boolean onMouseClick(int button, double mouseX, double mouseY) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                        if (this.getId() + RecipeViewingWidgetScreen.this.categoryPages * 6 == RecipeViewingWidgetScreen.this.categories.indexOf(RecipeViewingWidgetScreen.this.selectedCategory)) {
                            return false;
                        }
                        RecipeViewingWidgetScreen.this.selectedCategory = (IRecipeCategory)RecipeViewingWidgetScreen.this.categories.get(this.getId() + RecipeViewingWidgetScreen.this.categoryPages * 6);
                        RecipeViewingWidgetScreen.this.page = 0;
                        RecipeViewingWidgetScreen.this.method_2224();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setItem(this.categories.get(j).getCategoryIcon(), this.categories.get(j).getCategoryName(), tab.getId() + this.categoryPages * 6 == this.categories.indexOf(this.selectedCategory));
        }
        SpeedCraftAreaSupplier supplier = RecipeHelper.getInstance().getSpeedCraftButtonArea(this.selectedCategory);
        SpeedCraftFunctional functional = RecipeViewingWidgetScreen.getSpeedCraftFunctionalByCategory(GuiHelper.getLastContainerScreen(), this.selectedCategory);
        if (this.page * this.getRecipesPerPage() < this.categoriesMap.get(this.selectedCategory).size()) {
            Supplier<IRecipeDisplay> topDisplaySupplier = () -> this.categoriesMap.get(this.selectedCategory).get(this.page * this.getRecipesPerPage());
            Rectangle topBounds = new Rectangle((int)this.getBounds().getCenterX() - 75, this.getBounds().y + 40, 150, this.selectedCategory.usesFullPage() ? 140 : 66);
            this.widgets.addAll(this.selectedCategory.setupDisplay(topDisplaySupplier, topBounds));
            if (supplier != null) {
                this.widgets.add(new SpeedCraftingButtonWidget(supplier.get(topBounds), supplier.getButtonText(), functional, topDisplaySupplier));
            }
            if (!this.selectedCategory.usesFullPage() && this.page * this.getRecipesPerPage() + 1 < this.categoriesMap.get(this.selectedCategory).size()) {
                Supplier<IRecipeDisplay> middleDisplaySupplier = () -> this.categoriesMap.get(this.selectedCategory).get(this.page * this.getRecipesPerPage() + 1);
                Rectangle middleBounds = new Rectangle((int)this.getBounds().getCenterX() - 75, this.getBounds().y + 113, 150, 66);
                this.widgets.addAll(this.selectedCategory.setupDisplay(middleDisplaySupplier, middleBounds));
                if (supplier != null) {
                    this.widgets.add(new SpeedCraftingButtonWidget(supplier.get(middleBounds), supplier.getButtonText(), functional, middleDisplaySupplier));
                }
            }
        }
        GuiHelper.getLastOverlay().onInitialized();
        this.field_2557.addAll(this.tabs);
        this.field_2557.add(GuiHelper.getLastOverlay());
        this.field_2557.addAll(this.widgets);
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        if (this.selectedCategory.usesFullPage()) {
            return 1;
        }
        return 2;
    }

    public void method_2214(int mouseX, int mouseY, float partialTicks) {
        this.method_2240();
        this.tabs.stream().filter(tabWidget -> !tabWidget.isSelected()).forEach(tabWidget -> tabWidget.draw(mouseX, mouseY, partialTicks));
        class_308.method_1450();
        super.method_2214(mouseX, mouseY, partialTicks);
        this.widgets.forEach(widget -> {
            class_308.method_1450();
            widget.draw(mouseX, mouseY, partialTicks);
        });
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_308.method_1450();
        this.tabs.stream().filter(TabWidget::isSelected).forEach(tabWidget -> tabWidget.draw(mouseX, mouseY, partialTicks));
        GuiHelper.getLastOverlay().drawOverlay(mouseX, mouseY, partialTicks);
    }

    public void method_2240() {
        this.method_2236(0);
        if (this.selectedCategory != null) {
            this.selectedCategory.drawCategoryBackground(this.bounds);
        } else {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_308.method_1450();
            this.field_2563.method_1531().method_4618(CHEST_GUI_TEXTURE);
            this.method_1788((int)this.bounds.getX(), (int)this.bounds.getY(), 0, 0, (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
        }
    }

    public int getTotalPages(IRecipeCategory category) {
        return class_3532.method_15384((double)((double)this.categoriesMap.get(category).size() / (double)this.getRecipesPerPage()));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean method_16806(char char_1, int int_1) {
        for (class_364 listener : this.field_2557) {
            if (!listener.method_16806(char_1, int_1)) continue;
            return true;
        }
        return super.method_16806(char_1, int_1);
    }

    public boolean method_16802(double amount) {
        for (class_364 listener : this.field_2557) {
            if (!listener.method_16802(amount)) continue;
            return true;
        }
        if (this.getBounds().contains(ClientHelper.getMouseLocation())) {
            if (amount > 0.0 && this.recipeBack.enabled) {
                this.recipeBack.onPressed(0, 0.0, 0.0);
            } else if (amount < 0.0 && this.recipeNext.enabled) {
                this.recipeNext.onPressed(0, 0.0, 0.0);
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(ClientHelper.getMouseLocation())) {
            if (amount > 0.0 && this.categoryBack.enabled) {
                this.categoryBack.onPressed(0, 0.0, 0.0);
            } else if (amount < 0.0 && this.categoryNext.enabled) {
                this.categoryNext.onPressed(0, 0.0, 0.0);
            }
        }
        return super.method_16802(amount);
    }

    public boolean method_16807(double double_1, double double_2, int int_1) {
        for (class_364 entry : this.method_1968()) {
            if (!entry.method_16807(double_1, double_2, int_1)) continue;
            this.method_1973(entry);
            if (int_1 == 0) {
                this.method_1966(true);
            }
            return true;
        }
        return false;
    }
}

