/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.update;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.update.UpdatePriority;
import me.shedaniel.rei.update.Version;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import org.apache.commons.io.IOUtils;

public class UpdateChecker
implements ClientModInitializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Version currentVersion = null;
    private static Version latestForGame = null;
    private static JsonVersionElement element;
    private static class_1937 lastWorld;
    private static String VERSION_STRING;

    public static boolean isOutdated() {
        return latestForGame.compareTo(currentVersion) == 1 && currentVersion != null;
    }

    public static UpdatePriority getUpdatePriority(List<Version> versions) {
        UpdatePriority p = UpdatePriority.NONE;
        List<UpdatePriority> priorities = Arrays.asList(UpdatePriority.values());
        for (UpdatePriority priority : versions.stream().map(UpdateChecker::getUpdatePriority).collect(Collectors.toList())) {
            if (priority.compareTo(p) <= 0) continue;
            p = priority;
        }
        return p;
    }

    public static UpdatePriority getUpdatePriority(Version version) {
        JsonArray array = element.getChangelogs().getFabric();
        for (JsonElement element : array) {
            JsonObject jsonObject = element.getAsJsonObject();
            if (!jsonObject.has("version") || !jsonObject.get("version").getAsString().equals(version.toString())) continue;
            return UpdatePriority.fromString(jsonObject.get("level").getAsString());
        }
        return UpdatePriority.NONE;
    }

    public static boolean checkUpdates() {
        return RoughlyEnoughItemsCore.getConfigHelper().checkUpdates();
    }

    public static List<String> getChangelog(Version currentVersion) {
        LinkedList changelogs = Lists.newLinkedList();
        JsonArray array = element.getChangelogs().getFabric();
        array.forEach(jsonElement -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Version jsonVersion = new Version(jsonObject.get("version").getAsString());
            if (jsonVersion.compareTo(currentVersion) > 0 && jsonVersion.compareTo(latestForGame) <= 0) {
                changelogs.add(class_1074.method_4662((String)"text.rei.update_changelog_line", (Object[])new Object[]{jsonObject.get("text").getAsString()}));
            }
        });
        return changelogs;
    }

    public static Version getCurrentVersion() {
        return currentVersion;
    }

    public static Version getLatestForGame() {
        return latestForGame;
    }

    public static void onTick(class_310 client) {
        if (client.field_1687 != lastWorld && (lastWorld = client.field_1687) != null && UpdateChecker.checkUpdates() && UpdateChecker.isOutdated()) {
            String[] t;
            String currentVersionString = UpdateChecker.getCurrentVersion() == null ? "null" : UpdateChecker.getCurrentVersion().toString();
            List<Version> versions = UpdateChecker.getVersionsHigherThan(currentVersion);
            for (String s2 : t = class_1074.method_4662((String)"text.rei.update_outdated", (Object[])new Object[]{currentVersionString, UpdateChecker.getLatestForGame(), UpdateChecker.getUpdatePriority(versions).name().toUpperCase()}).split("\n")) {
                client.field_1724.method_7353((class_2561)new class_2585(s2), false);
            }
            UpdateChecker.getChangelog(currentVersion).forEach(s -> client.field_1724.method_7353((class_2561)new class_2585(s), false));
        }
    }

    private static List<Version> getVersionsHigherThan(Version currentVersion) {
        LinkedList versions = Lists.newLinkedList();
        JsonArray array = element.getChangelogs().getFabric();
        array.forEach(jsonElement -> {
            Version jsonVersion = new Version(jsonElement.getAsJsonObject().get("version").getAsString());
            if (jsonVersion.compareTo(currentVersion) > 0) {
                versions.add(jsonVersion);
            }
        });
        return versions;
    }

    public void onInitializeClient() {
        if (!UpdateChecker.checkUpdates()) {
            return;
        }
        FabricLoader.INSTANCE.getMods().stream().map(ModContainer::getInfo).forEach(modInfo -> {
            if (modInfo.getId().equals("roughlyenoughitems")) {
                try {
                    currentVersion = new Version(modInfo.getVersionString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        InputStream downloadedStream = this.downloadVersionString();
        String downloadedString = null;
        try {
            downloadedString = IOUtils.toString((InputStream)downloadedStream, (Charset)StandardCharsets.UTF_8);
            element = (JsonVersionElement)GSON.fromJson(downloadedString, JsonVersionElement.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        latestForGame = downloadedString != null && !downloadedString.equalsIgnoreCase("{}") ? new Version(this.parseLatest(element, class_155.method_16673().getName())) : new Version("0.0.0");
    }

    private InputStream downloadVersionString() {
        try {
            URL versionUrl = new URL(VERSION_STRING);
            return versionUrl.openStream();
        }
        catch (IOException e) {
            return new StringBufferInputStream("{}");
        }
    }

    private String parseLatest(JsonVersionElement element, String gameVersion) {
        LinkedList<LatestVersionObject> objects = new LinkedList<LatestVersionObject>(element.getLatestVersions());
        for (int i = objects.size() - 1; i >= 0; --i) {
            if (!((LatestVersionObject)objects.get(i)).getGameVersion().equals(gameVersion)) continue;
            return ((LatestVersionObject)objects.get(i)).getModVersion();
        }
        return ((LatestVersionObject)objects.get(objects.size() - 1)).getModVersion();
    }

    static {
        lastWorld = null;
        VERSION_STRING = "https://raw.githubusercontent.com/shedaniel/RoughlyEnoughItems/1.14/version.json";
    }

    private class ChangelogObject {
        private JsonArray fabric = new JsonArray();
        private JsonArray rift = new JsonArray();

        private ChangelogObject() {
        }

        public JsonArray getFabric() {
            return this.fabric;
        }

        public JsonArray getRift() {
            return this.rift;
        }
    }

    private class LatestVersionObject {
        @SerializedName(value="game")
        private String gameVersion = "";
        @SerializedName(value="mod")
        private String modVersion = "";

        private LatestVersionObject() {
        }

        public String getGameVersion() {
            return this.gameVersion;
        }

        public String getModVersion() {
            return this.modVersion;
        }

        public String toString() {
            return String.format("LatestVersion[%s] = %s", this.getGameVersion(), this.getModVersion());
        }
    }

    private class JsonVersionElement {
        @SerializedName(value="latest")
        private List<LatestVersionObject> latestVersions = Lists.newArrayList();
        private ChangelogObject changelogs;

        public JsonVersionElement() {
            this.changelogs = new ChangelogObject();
        }

        public List<LatestVersionObject> getLatestVersions() {
            return this.latestVersions;
        }

        public ChangelogObject getChangelogs() {
            return this.changelogs;
        }
    }
}

